/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.gcsio.CacheEntry;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryListCache {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryListCache.class);
    protected Clock clock = Clock.SYSTEM;
    protected Config cacheConfig = new Config();

    @VisibleForTesting
    public abstract boolean supportsCacheEntryByReference();

    @VisibleForTesting
    public abstract boolean containsEntriesForImplicitDirectories();

    public abstract CacheEntry putResourceId(StorageResourceId var1) throws IOException;

    public abstract CacheEntry getCacheEntry(StorageResourceId var1) throws IOException;

    public abstract void removeResourceId(StorageResourceId var1) throws IOException;

    public abstract List<CacheEntry> getBucketList() throws IOException;

    public abstract List<CacheEntry> getRawBucketList() throws IOException;

    public abstract List<CacheEntry> getObjectList(String var1, String var2, String var3, Set<String> var4) throws IOException;

    @VisibleForTesting
    public abstract int getInternalNumBuckets() throws IOException;

    @VisibleForTesting
    public abstract int getInternalNumObjects() throws IOException;

    public Config getMutableConfig() {
        return this.cacheConfig;
    }

    @VisibleForTesting
    public synchronized void setClock(Clock clock) {
        this.clock = clock;
    }

    protected synchronized boolean isCacheEntryExpired(CacheEntry entry) {
        long creationTime = entry.getCreationTimeMillis();
        long entryAge = this.clock.currentTimeMillis() - creationTime;
        return entryAge > this.cacheConfig.getMaxEntryAgeMillis();
    }

    protected static void validateResourceId(StorageResourceId resourceId) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"DirectoryListCache requires non-null resourceId.");
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (Object)"DirectoryListCache cannot be used to cache ROOT info.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeInvalidateExpiredInfo(CacheEntry entry) {
        long maxInfoAgeMillis;
        long currentTimeMillis;
        Object object = this;
        synchronized (object) {
            currentTimeMillis = this.clock.currentTimeMillis();
            maxInfoAgeMillis = this.cacheConfig.getMaxInfoAgeMillis();
        }
        object = entry;
        synchronized (object) {
            long lastUpdated = entry.getItemInfoUpdateTimeMillis();
            long infoAge = currentTimeMillis - lastUpdated;
            if (lastUpdated > 0L && infoAge > maxInfoAgeMillis) {
                LOG.debug("Clearing itemInfo for CacheEntry '{}' with infoAge: {} ms", (Object)entry.getResourceId(), (Object)infoAge);
                entry.clearItemInfo();
            }
        }
    }

    public static enum Type {
        IN_MEMORY,
        FILESYSTEM_BACKED;

    }

    public static class Config {
        public static final long MAX_ENTRY_AGE_MILLIS_DEFAULT = 14400000L;
        public static final long MAX_INFO_AGE_MILLIS_DEFAULT = 10000L;
        private long maxEntryAgeMillis = 14400000L;
        private long maxInfoAgeMillis = 10000L;

        public synchronized long getMaxEntryAgeMillis() {
            return this.maxEntryAgeMillis;
        }

        public synchronized Config setMaxEntryAgeMillis(long maxEntryAgeMillis) {
            this.maxEntryAgeMillis = maxEntryAgeMillis;
            return this;
        }

        public synchronized long getMaxInfoAgeMillis() {
            return this.maxInfoAgeMillis;
        }

        public synchronized Config setMaxInfoAgeMillis(long maxInfoAgeMillis) {
            this.maxInfoAgeMillis = maxInfoAgeMillis;
            return this;
        }
    }
}

