/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.Preconditions;

public class GoogleCloudStorageReadOptions {
    public static final GoogleCloudStorageReadOptions DEFAULT = new Builder().build();
    public static final int DEFAULT_BACKOFF_INITIAL_INTERVAL_MILLIS = 200;
    public static final double DEFAULT_BACKOFF_RANDOMIZATION_FACTOR = 0.5;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    public static final int DEFAULT_BACKOFF_MAX_INTERVAL_MILLIS = 10000;
    public static final int DEFAULT_BACKOFF_MAX_ELAPSED_TIME_MILLIS = 120000;
    public static final boolean DEFAULT_SUPPORT_CONTENT_ENCODING = true;
    public static final boolean DEFAULT_FAST_FAIL_ON_NOT_FOUND = true;
    public static final int DEFAULT_BUFFER_SIZE = 0;
    public static final long DEFAULT_INPLACE_SEEK_LIMIT = 0L;
    private final int backoffInitialIntervalMillis;
    private final double backoffRandomizationFactor;
    private final double backoffMultiplier;
    private final int backoffMaxIntervalMillis;
    private final int backoffMaxElapsedTimeMillis;
    private final boolean supportContentEncoding;
    private final boolean fastFailOnNotFound;
    private final int bufferSize;
    private final long inplaceSeekLimit;

    private GoogleCloudStorageReadOptions(int backoffInitialIntervalMillis, double backoffRandomizationFactor, double backoffMultiplier, int backoffMaxIntervalMillis, int backoffMaxElapsedTimeMillis, boolean supportContentEncoding, boolean fastFailOnNotFound, int bufferSize, long inplaceSeekLimit) {
        this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
        this.backoffRandomizationFactor = backoffRandomizationFactor;
        this.backoffMultiplier = backoffMultiplier;
        this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
        this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
        this.supportContentEncoding = supportContentEncoding;
        this.fastFailOnNotFound = fastFailOnNotFound;
        this.bufferSize = bufferSize;
        this.inplaceSeekLimit = inplaceSeekLimit;
    }

    public int getBackoffInitialIntervalMillis() {
        return this.backoffInitialIntervalMillis;
    }

    public double getBackoffRandomizationFactor() {
        return this.backoffRandomizationFactor;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public int getBackoffMaxIntervalMillis() {
        return this.backoffMaxIntervalMillis;
    }

    public int getBackoffMaxElapsedTimeMillis() {
        return this.backoffMaxElapsedTimeMillis;
    }

    public boolean getSupportContentEncoding() {
        return this.supportContentEncoding;
    }

    public boolean getFastFailOnNotFound() {
        return this.fastFailOnNotFound;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getInplaceSeekLimit() {
        return this.inplaceSeekLimit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("backoffInitialIntervalMillis=" + this.backoffInitialIntervalMillis + " ");
        sb.append("backoffRandomizationFactor=" + this.backoffRandomizationFactor + " ");
        sb.append("backoffMultiplier=" + this.backoffMultiplier + " ");
        sb.append("backoffMaxIntervalMillis=" + this.backoffMaxIntervalMillis + " ");
        sb.append("backoffMaxElapsedTimeMillis=" + this.backoffMaxElapsedTimeMillis + " ");
        sb.append("supportContentEncoding=" + this.supportContentEncoding + " ");
        sb.append("fastFailOnNotFound=" + this.fastFailOnNotFound + " ");
        sb.append("bufferSize=" + this.bufferSize + " ");
        sb.append("inplaceSeekLimit=" + this.inplaceSeekLimit + " ");
        return sb.toString();
    }

    public static class Builder {
        private int backoffInitialIntervalMillis = 200;
        private double backoffRandomizationFactor = 0.5;
        private double backoffMultiplier = 1.5;
        private int backoffMaxIntervalMillis = 10000;
        private int backoffMaxElapsedTimeMillis = 120000;
        private boolean supportContentEncoding = true;
        private boolean fastFailOnNotFound = true;
        private int bufferSize = 0;
        private long inplaceSeekLimit = 0L;

        public Builder setBackoffInitialIntervalMillis(int backoffInitialIntervalMillis) {
            this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
            return this;
        }

        public Builder setBackoffRandomizationFactor(double backoffRandomizationFactor) {
            this.backoffRandomizationFactor = backoffRandomizationFactor;
            return this;
        }

        public Builder setBackoffMultiplier(double backoffMultiplier) {
            this.backoffMultiplier = backoffMultiplier;
            return this;
        }

        public Builder setBackoffMaxIntervalMillis(int backoffMaxIntervalMillis) {
            this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
            return this;
        }

        public Builder setBackoffMaxElapsedTimeMillis(int backoffMaxElapsedTimeMillis) {
            this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
            return this;
        }

        public Builder setSupportContentEncoding(boolean supportContentEncoding) {
            this.supportContentEncoding = supportContentEncoding;
            return this;
        }

        public Builder setFastFailOnNotFound(boolean fastFailOnNotFound) {
            this.fastFailOnNotFound = fastFailOnNotFound;
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setInplaceSeekLimit(long inplaceSeekLimit) {
            Preconditions.checkArgument((inplaceSeekLimit >= 0L ? 1 : 0) != 0, (String)"inplaceSeekLimit must be non-negative! Got %s", (Object[])new Object[]{inplaceSeekLimit});
            this.inplaceSeekLimit = inplaceSeekLimit;
            return this;
        }

        public GoogleCloudStorageReadOptions build() {
            return new GoogleCloudStorageReadOptions(this.backoffInitialIntervalMillis, this.backoffRandomizationFactor, this.backoffMultiplier, this.backoffMaxIntervalMillis, this.backoffMaxElapsedTimeMillis, this.supportContentEncoding, this.fastFailOnNotFound, this.bufferSize, this.inplaceSeekLimit);
        }
    }
}

