/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CacheEntry;
import com.google.cloud.hadoop.gcsio.CachedBucket;
import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageStrings;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDirectoryListCache
extends DirectoryListCache {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDirectoryListCache.class);
    private static final InMemoryDirectoryListCache singletonInstance = new InMemoryDirectoryListCache();
    private final Map<String, CachedBucket> bucketLookup = new HashMap<String, CachedBucket>();

    public static DirectoryListCache getInstance() {
        return singletonInstance;
    }

    @Override
    public boolean supportsCacheEntryByReference() {
        return true;
    }

    @Override
    public boolean containsEntriesForImplicitDirectories() {
        return false;
    }

    @Override
    public synchronized CacheEntry putResourceId(StorageResourceId resourceId) {
        InMemoryDirectoryListCache.validateResourceId(resourceId);
        CachedBucket resourceBucket = this.bucketLookup.get(resourceId.getBucketName());
        if (resourceBucket == null) {
            resourceBucket = new CachedBucket(resourceId.getBucketName());
            this.bucketLookup.put(resourceId.getBucketName(), resourceBucket);
        }
        if (resourceId.isStorageObject()) {
            return resourceBucket.put(resourceId);
        }
        return resourceBucket;
    }

    @Override
    public synchronized CacheEntry getCacheEntry(StorageResourceId resourceId) {
        InMemoryDirectoryListCache.validateResourceId(resourceId);
        CachedBucket bucket = this.bucketLookup.get(resourceId.getBucketName());
        if (bucket == null) {
            return null;
        }
        if (resourceId.isStorageObject()) {
            return bucket.get(resourceId);
        }
        return bucket;
    }

    @Override
    public synchronized void removeResourceId(StorageResourceId resourceId) {
        InMemoryDirectoryListCache.validateResourceId(resourceId);
        CachedBucket bucket = this.bucketLookup.get(resourceId.getBucketName());
        if (bucket == null) {
            LOG.debug("Tried to remove resourceId '{}' from nonexistent bucket '{}'", (Object)resourceId, (Object)resourceId.getBucketName());
            return;
        }
        if (resourceId.isStorageObject()) {
            LOG.debug("Explicitly removing StorageObject from CachedBucket: '{}'", (Object)resourceId);
            bucket.remove(resourceId);
        } else {
            if (bucket.getNumObjects() > 0) {
                LOG.warn("Explicitly removing non-empty Bucket: '{}', which contains {} items", (Object)resourceId, (Object)bucket.getNumObjects());
            } else {
                LOG.debug("Explicitly removing empty Bucket: '{}'", (Object)resourceId);
            }
            this.bucketLookup.remove(resourceId.getBucketName());
        }
    }

    @Override
    public synchronized List<CacheEntry> getBucketList() {
        LOG.debug("getBucketList()");
        ArrayList<CacheEntry> bucketEntries = new ArrayList<CacheEntry>();
        ArrayList<CachedBucket> expiredBuckets = new ArrayList<CachedBucket>();
        for (CachedBucket bucket : this.bucketLookup.values()) {
            this.maybeInvalidateExpiredInfo(bucket);
            if (this.isCacheEntryExpired(bucket)) {
                expiredBuckets.add(bucket);
                continue;
            }
            bucketEntries.add(bucket);
        }
        for (CachedBucket expiredBucket : expiredBuckets) {
            if (expiredBucket.getNumObjects() != 0) continue;
            LOG.debug("Removing empty expired CachedBucket: '{}'", (Object)expiredBucket.getName());
            this.bucketLookup.remove(expiredBucket.getName());
        }
        return bucketEntries;
    }

    @Override
    public synchronized List<CacheEntry> getRawBucketList() {
        LOG.debug("getRawBucketList()");
        return new ArrayList<CacheEntry>(this.bucketLookup.values());
    }

    @Override
    public synchronized List<CacheEntry> getObjectList(String bucketName, String objectNamePrefix, String delimiter, Set<String> returnedPrefixes) {
        LOG.debug("getObjectList({}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter});
        CachedBucket bucket = this.bucketLookup.get(bucketName);
        if (bucket == null) {
            return null;
        }
        ArrayList<CacheEntry> matchingObjectEntries = new ArrayList<CacheEntry>();
        boolean removedExpiredEntries = false;
        for (CacheEntry objectEntry : bucket.getObjectList(objectNamePrefix)) {
            this.maybeInvalidateExpiredInfo(objectEntry);
            if (this.isCacheEntryExpired(objectEntry)) {
                LOG.debug("Removing expired CacheEntry: '{}'", (Object)objectEntry.getResourceId());
                bucket.remove(objectEntry.getResourceId());
                removedExpiredEntries = true;
                continue;
            }
            String objectName = objectEntry.getResourceId().getObjectName();
            String matchedName = GoogleCloudStorageStrings.matchListPrefix(objectNamePrefix, delimiter, objectName);
            if (matchedName == null) continue;
            if (objectName.equals(matchedName)) {
                matchingObjectEntries.add(objectEntry);
                continue;
            }
            if (returnedPrefixes == null) continue;
            returnedPrefixes.add(matchedName);
        }
        if (removedExpiredEntries && bucket.getNumObjects() == 0 && this.isCacheEntryExpired(bucket)) {
            LOG.debug("Removing empty expired CachedBucket: '{}'", (Object)bucket.getName());
            this.bucketLookup.remove(bucket.getName());
        }
        return matchingObjectEntries;
    }

    @Override
    public synchronized int getInternalNumBuckets() {
        return this.bucketLookup.size();
    }

    @Override
    public synchronized int getInternalNumObjects() {
        int objectCount = 0;
        for (CachedBucket bucket : this.bucketLookup.values()) {
            objectCount += bucket.getNumObjects();
        }
        return objectCount;
    }
}

