/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.services.storage.Storage;
import com.google.common.base.Optional;

public class ObjectWriteConditions {
    public static final ObjectWriteConditions NONE = new ObjectWriteConditions();
    private final Optional<Long> contentGenerationMatch;
    private final Optional<Long> metaGenerationMatch;
    private final boolean ignoreGenerationMismatch;

    public ObjectWriteConditions() {
        this((Optional<Long>)Optional.absent(), (Optional<Long>)Optional.absent());
    }

    public ObjectWriteConditions(Optional<Long> contentGenerationMatch, Optional<Long> metaGenerationMatch) {
        this(contentGenerationMatch, metaGenerationMatch, false);
    }

    public ObjectWriteConditions(Optional<Long> contentGenerationMatch, Optional<Long> metaGenerationMatch, boolean ignoreGenerationMismatch) {
        this.contentGenerationMatch = contentGenerationMatch;
        this.metaGenerationMatch = metaGenerationMatch;
        this.ignoreGenerationMismatch = ignoreGenerationMismatch;
    }

    public boolean hasContentGenerationMatch() {
        return this.contentGenerationMatch.isPresent();
    }

    public boolean hasMetaGenerationMatch() {
        return this.metaGenerationMatch.isPresent();
    }

    public long getContentGenerationMatch() {
        return (Long)this.contentGenerationMatch.get();
    }

    public long getMetaGenerationMatch() {
        return (Long)this.metaGenerationMatch.get();
    }

    public boolean getIgnoreGenerationMismatch() {
        return this.ignoreGenerationMismatch;
    }

    public void apply(Storage.Objects.Insert objectToInsert) {
        if (this.hasContentGenerationMatch()) {
            objectToInsert.setIfGenerationMatch(Long.valueOf(this.getContentGenerationMatch()));
        }
        if (this.hasMetaGenerationMatch()) {
            objectToInsert.setIfMetagenerationMatch(Long.valueOf(this.getMetaGenerationMatch()));
        }
    }
}

