/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;

public final class StringPaths {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final CharMatcher BUCKET_NAME_CHAR_MATCHER = CharMatcher.ascii().and(CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.anyOf((CharSequence)"_.-"))).precomputed();

    private StringPaths() {
    }

    static String validateBucketName(String bucketName) {
        if (Strings.isNullOrEmpty((String)(bucketName = StringPaths.toFilePath(bucketName)))) {
            throw new IllegalArgumentException("GCS bucket name cannot be empty.");
        }
        if (!BUCKET_NAME_CHAR_MATCHER.matchesAllOf((CharSequence)bucketName)) {
            throw new IllegalArgumentException(String.format("Invalid GCS bucket name '%s': bucket name must contain only 'a-z0-9_.-' characters.", bucketName));
        }
        return bucketName;
    }

    static String validateObjectName(String objectName, boolean allowEmptyObjectName) {
        ((GoogleLogger.Api)logger.atFine()).log("validateObjectName('%s', %s)", (Object)objectName, allowEmptyObjectName);
        if (Strings.isNullOrEmpty((String)objectName) || objectName.equals("/")) {
            if (allowEmptyObjectName) {
                objectName = "";
            } else {
                throw new IllegalArgumentException(String.format("GCS path must include non-empty object name [objectName='%s', allowEmptyObjectName=%s]", objectName, allowEmptyObjectName));
            }
        }
        for (int i = 0; i < objectName.length() - 1; ++i) {
            if (objectName.charAt(i) != '/' || objectName.charAt(i + 1) != '/') continue;
            throw new IllegalArgumentException(String.format("GCS path must not have consecutive '/' characters: '%s'", objectName));
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        ((GoogleLogger.Api)logger.atFine()).log("validateObjectName -> '%s'", (Object)objectName);
        return objectName;
    }

    public static String fromComponents(String bucketName, String objectName) {
        if (bucketName == null && objectName != null) {
            throw new IllegalArgumentException(String.format("Invalid bucketName/objectName pair: gs://%s/%s", bucketName, objectName));
        }
        StringBuilder result = new StringBuilder("gs://");
        if (bucketName != null) {
            result.append(bucketName);
        }
        if (objectName != null) {
            result.append('/').append(objectName);
        }
        return result.toString();
    }

    public static boolean isDirectoryPath(String path) {
        return !Strings.isNullOrEmpty((String)path) && path.endsWith("/");
    }

    public static String toFilePath(String path) {
        return !Strings.isNullOrEmpty((String)path) && StringPaths.isDirectoryPath(path) ? path.substring(0, path.length() - 1) : path;
    }

    static String toDirectoryPath(String path) {
        return Strings.isNullOrEmpty((String)path) || StringPaths.isDirectoryPath(path) ? path : path + "/";
    }
}

