/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible(emulated=true)
public class BiMapInverseTester<K, V>
extends AbstractBiMapTester<K, V> {
    public void testInverseSame() {
        BiMapInverseTester.assertSame(this.getMap(), (Object)this.getMap().inverse().inverse());
    }

    @CollectionFeature.Require(value={CollectionFeature.SERIALIZABLE})
    public void testInverseSerialization() {
        BiMapPair pair = new BiMapPair(this.getMap());
        BiMapPair copy = SerializableTester.reserialize(pair);
        BiMapInverseTester.assertEquals(pair.forward, copy.forward);
        BiMapInverseTester.assertEquals(pair.backward, copy.backward);
        BiMapInverseTester.assertSame(copy.backward, (Object)copy.forward.inverse());
        BiMapInverseTester.assertSame(copy.forward, (Object)copy.backward.inverse());
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static List<Method> getInverseSameAfterSerializingMethods() {
        return Collections.singletonList(BiMapInverseTester.getMethod("testInverseSerialization"));
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static Method getMethod(String methodName) {
        return Helpers.getMethod(BiMapInverseTester.class, methodName);
    }

    private static class BiMapPair<K, V>
    implements Serializable {
        final BiMap<K, V> forward;
        final BiMap<V, K> backward;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        BiMapPair(BiMap<K, V> original) {
            this.forward = original;
            this.backward = original.inverse();
        }
    }
}

