/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class OperationParser {
    public static final String COMPONENTS_REF = "#/components/schemas/";

    public static Optional<RequestBody> getRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, Consumes classConsumes, Consumes methodConsumes, Components components, JsonView jsonViewAnnotation) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(requestBody.required());
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(requestBody.extensions());
            if (extensions != null) {
                extensions.forEach(requestBodyObject::addExtension);
            }
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent(requestBody.content(), classConsumes == null ? new String[]{} : classConsumes.value(), methodConsumes == null ? new String[]{} : methodConsumes.value(), null, components, jsonViewAnnotation).ifPresent(requestBodyObject::setContent);
        return Optional.of(requestBodyObject);
    }

    public static Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, Produces classProduces, Produces methodProduces, Components components, JsonView jsonViewAnnotation) {
        if (responses == null) {
            return Optional.empty();
        }
        ApiResponses apiResponsesObject = new ApiResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
            Map<String, Object> extensions;
            ApiResponse apiResponseObject = new ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.ref())) {
                apiResponseObject.set$ref(response.ref());
                if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                    apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                    continue;
                }
                apiResponsesObject._default(apiResponseObject);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            }
            if (response.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(response.extensions())) != null) {
                extensions.forEach(apiResponseObject::addExtension);
            }
            AnnotationsUtils.getContent(response.content(), classProduces == null ? new String[]{} : classProduces.value(), methodProduces == null ? new String[]{} : methodProduces.value(), null, components, jsonViewAnnotation).ifPresent(apiResponseObject::content);
            AnnotationsUtils.getHeaders(response.headers(), jsonViewAnnotation).ifPresent(apiResponseObject::headers);
            if (!StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) && apiResponseObject.getContent() == null && apiResponseObject.getHeaders() == null) continue;
            Map<String, Link> links = AnnotationsUtils.getLinks(response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(apiResponsesObject);
    }
}

