/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.iface;

import com.helger.base.io.stream.StreamHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;

public interface IHasInputStream {
    @Nullable
    public InputStream getInputStream();

    @Nullable
    default public InputStream getBufferedInputStream() {
        return StreamHelper.getBuffered(this.getInputStream());
    }

    @Nullable
    default public <T> T withInputStreamDo(@Nonnull Function<InputStream, T> function) throws IOException {
        try (InputStream inputStream = this.getInputStream();){
            T t = function.apply(inputStream);
            return t;
        }
    }

    @Nullable
    default public <T> T withBufferedInputStreamDo(@Nonnull Function<InputStream, T> function) throws IOException {
        try (InputStream inputStream = this.getBufferedInputStream();){
            T t = function.apply(inputStream);
            return t;
        }
    }

    public boolean isReadMultiple();
}

