/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huaweicloud.sdk.core.CustomizationConfigure;
import com.huaweicloud.sdk.core.SdkResponse;
import com.huaweicloud.sdk.core.SdkStreamRequest;
import com.huaweicloud.sdk.core.SdkStreamResponse;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServerResponseException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import com.huaweicloud.sdk.core.exchange.ApiReference;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.exchange.SdkExchangeCache;
import com.huaweicloud.sdk.core.http.Field;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.http.LocationType;
import com.huaweicloud.sdk.core.impl.DefaultHttpClient;
import com.huaweicloud.sdk.core.utils.ExceptionUtils;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcClient
implements CustomizationConfigure {
    private static final Logger logger = LoggerFactory.getLogger(HcClient.class);
    private static final int STATUS_CODE_WITH_RESPONSE_ERROR = 400;
    private HttpClient httpClient;
    private String endpoint;
    private ICredential credential;
    private HttpConfig httpConfig;
    private Map<String, String> extraHeader;

    HcClient withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    HcClient withCredential(ICredential credential) {
        this.credential = credential;
        return this;
    }

    public ICredential getCredential() {
        return this.credential;
    }

    HcClient(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.httpClient = new DefaultHttpClient(this.httpConfig);
    }

    HcClient(HttpConfig httpConfig, HttpClient httpClient) {
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
    }

    private HcClient(HttpConfig httpConfig, HttpClient httpClient, ICredential credential, String endpoint) {
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
        this.credential = credential;
        this.endpoint = endpoint;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HcClient overrideEndpoint(String endpoint) {
        return new HcClient(this.httpConfig, this.httpClient, this.credential, endpoint);
    }

    public HcClient overrideCredential(ICredential credential) {
        return new HcClient(this.httpConfig, this.httpClient, credential, this.endpoint);
    }

    public HcClient preInvoke(Map<String, String> extraHeader) {
        HcClient client = new HcClient(this.httpConfig, this.httpClient, this.credential, this.endpoint);
        client.extraHeader = extraHeader;
        return client;
    }

    public <ReqT, ResT> ResT syncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef) throws ServiceResponseException {
        return this.syncInvokeHttp(request, reqDef, new SdkExchange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, ResT> ResT syncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef, SdkExchange exchange) throws ServiceResponseException {
        if (Objects.isNull(exchange)) {
            throw new IllegalArgumentException("SdkExchange is null");
        }
        exchange.setApiReference(new ApiReference().withName(reqDef.getName()).withMethod(reqDef.getMethod().toString()).withUri(reqDef.getUri()));
        HttpRequest httpRequest = this.buildRequest(request, reqDef);
        if (Objects.nonNull(this.credential)) {
            try {
                httpRequest = this.credential.processAuthRequest(httpRequest, this.httpClient).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SdkException(e);
            }
        }
        String exchangeId = SdkExchangeCache.putExchange(exchange);
        httpRequest = httpRequest.builder().addHeader("SDK_EXCHANGE", exchangeId).build();
        try {
            HttpResponse httpResponse = this.httpClient.syncInvokeHttp(httpRequest);
            this.printAccessLog(httpRequest, httpResponse, exchange);
            if (httpResponse.getStatusCode() >= 400) {
                logger.error("ServiceResponseException occurred. Host: {} Uri: {} ServiceResponseException: {}", new Object[]{httpRequest.getUrl().getHost(), httpRequest.getUrl(), ExceptionUtils.extractErrorMessage(httpResponse)});
                throw ServiceResponseException.mapException(httpResponse.getStatusCode(), ExceptionUtils.extractErrorMessage(httpResponse));
            }
            ResT ResT = this.extractResponse(httpResponse, reqDef);
            return ResT;
        }
        finally {
            SdkExchangeCache.removeExchange(exchangeId);
        }
    }

    public <ReqT, ResT> CompletableFuture<ResT> asyncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef) {
        return this.asyncInvokeHttp(request, reqDef, new SdkExchange());
    }

    public <ReqT, ResT> CompletableFuture<ResT> asyncInvokeHttp(ReqT request, HttpRequestDef<ReqT, ResT> reqDef, SdkExchange exchange) {
        if (Objects.isNull(exchange)) {
            return CompletableFuture.supplyAsync(() -> {
                throw new IllegalArgumentException("SdkExchange is null");
            });
        }
        exchange.setApiReference(new ApiReference().withName(reqDef.getName()).withMethod(reqDef.getMethod().toString()).withUri(reqDef.getUri()));
        AtomicReference exchangeIdRef = new AtomicReference();
        HttpRequest httpRequest = this.buildRequest(request, reqDef);
        CompletableFuture<HttpRequest> validHttpRequestStage = CompletableFuture.supplyAsync(() -> httpRequest);
        if (Objects.nonNull(this.credential)) {
            validHttpRequestStage = this.credential.processAuthRequest(httpRequest, this.httpClient);
        }
        return validHttpRequestStage.thenCompose(validHttpRequest -> {
            String id = SdkExchangeCache.putExchange(exchange);
            exchangeIdRef.set(id);
            HttpRequest finalValidHttpRequest = validHttpRequest = validHttpRequest.builder().addHeader("SDK_EXCHANGE", id).build();
            return ((CompletableFuture)this.httpClient.asyncInvokeHttp((HttpRequest)validHttpRequest).thenApply(httpResponse -> {
                this.printAccessLog(finalValidHttpRequest, (HttpResponse)httpResponse, exchange);
                if (httpResponse.getStatusCode() >= 400) {
                    logger.error("ServiceResponseException occurred. Host: {} Uri: {} ServiceResponseException: {}", new Object[]{finalValidHttpRequest.getUrl().getHost(), finalValidHttpRequest.getUrl(), ExceptionUtils.extractErrorMessage(httpResponse)});
                    throw ServiceResponseException.mapException(httpResponse.getStatusCode(), ExceptionUtils.extractErrorMessage(httpResponse));
                }
                Object response = this.extractResponse((HttpResponse)httpResponse, reqDef);
                return response;
            })).whenComplete((r, e) -> SdkExchangeCache.removeExchange((String)exchangeIdRef.get()));
        });
    }

    protected <ReqT, ResT> HttpRequest buildRequest(ReqT request, HttpRequestDef<ReqT, ResT> reqDef) {
        HttpRequest.HttpRequestBuilder httpRequestBuilder = HttpRequest.newBuilder();
        httpRequestBuilder.withMethod(reqDef.getMethod()).withContentType(reqDef.getContentType()).withEndpoint(this.endpoint).withPath(reqDef.getUri());
        for (Field<ReqT, ?> field : reqDef.getRequestFields()) {
            Optional<?> reqValueOption = field.readValue(request);
            if (!reqValueOption.isPresent()) continue;
            Object reqValue = reqValueOption.get();
            if (field.getLocation() == LocationType.Header) {
                httpRequestBuilder.addHeader(field.getName(), reqValue.toString());
                continue;
            }
            if (field.getLocation() == LocationType.Query) {
                this.buildQueryParams(httpRequestBuilder, field.getName(), reqValue);
                continue;
            }
            if (field.getLocation() == LocationType.Path) {
                httpRequestBuilder.addPathParam(field.getName(), reqValue.toString());
                continue;
            }
            if (field.getLocation() != LocationType.Body) continue;
            httpRequestBuilder.withBodyAsString(JsonUtils.toJSON(reqValue));
        }
        if (request instanceof SdkStreamRequest) {
            httpRequestBuilder.withBody(((SdkStreamRequest)request).getBody());
        }
        httpRequestBuilder.addHeader("User-Agent", "huaweicloud-usdk-java/3.0");
        if (Objects.nonNull(this.extraHeader) && this.extraHeader.size() > 0) {
            this.extraHeader.forEach((k, v) -> httpRequestBuilder.addHeader((String)k, (String)v));
        }
        HttpRequest httpRequest = httpRequestBuilder.build();
        return httpRequest;
    }

    private void buildQueryParams(HttpRequest.HttpRequestBuilder httpRequestBuilder, String fieldName, Object reqValue) {
        if (reqValue instanceof Collection) {
            httpRequestBuilder.addQueryParam(fieldName, this.buildCollectionQueryParams(reqValue));
        } else if (reqValue instanceof Map) {
            Map<String, List<String>> params = this.buildMapQueryParamsLoop(fieldName, (Map)reqValue);
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                httpRequestBuilder.addQueryParam(entry.getKey(), entry.getValue());
            }
        } else {
            httpRequestBuilder.addQueryParam(fieldName, this.buildStringQueryParams(reqValue));
        }
    }

    private List<String> buildStringQueryParams(Object reqValue) {
        return Arrays.asList(reqValue.toString());
    }

    private List<String> buildCollectionQueryParams(Object reqValue) {
        return ((List)reqValue).stream().map(Object::toString).collect(Collectors.toList());
    }

    private Map<String, List<String>> buildMapQueryParamsLoop(String key, Map reqValue) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Stack stack = new Stack();
        reqValue.forEach((k, v) -> stack.push(this.buildMapQueryParams(key, k.toString(), v)));
        while (!stack.isEmpty()) {
            Map temp = (Map)stack.pop();
            temp.forEach(result::put);
        }
        return result;
    }

    private Map<String, List<String>> buildMapQueryParams(String key, String entryKey, Object entryValue) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        if (entryValue instanceof Map) {
            ((Map)entryValue).forEach((k, v) -> res.putAll(this.buildMapQueryParams(key + "[" + entryKey + "]", k.toString(), v)));
        } else if (entryValue instanceof Collection) {
            res.put(key + "[" + entryKey + "]", this.buildCollectionQueryParams(entryValue));
        } else {
            res.put(key + "[" + entryKey + "]", this.buildStringQueryParams(entryValue));
        }
        return res;
    }

    private <ReqT, ResT> ResT extractResponse(HttpResponse httpResponse, HttpRequestDef<ReqT, ResT> reqDef) {
        try {
            Object resT;
            String stringResult = httpResponse.getBodyAsString();
            if (Objects.nonNull(httpResponse.getContentType()) && httpResponse.getContentType().equals("application/octet-stream")) {
                resT = reqDef.getResponseType().newInstance();
                if (resT instanceof SdkStreamResponse) {
                    ((SdkStreamResponse)resT).setBody(httpResponse.getBody());
                }
            } else if (!reqDef.hasResponseField("body")) {
                resT = JsonUtils.toObjectIgnoreUnknown(stringResult, reqDef.getResponseType());
            } else {
                resT = reqDef.getResponseType().newInstance();
                Field<ResT, ?> responseField = reqDef.getResponseField("body");
                Object obj = this.responseToObject(stringResult, responseField);
                responseField.writeValueSafe(resT, obj, responseField.getFieldType());
            }
            if (Objects.isNull(resT)) {
                resT = reqDef.getResponseType().newInstance();
            }
            Object finalResT = resT;
            reqDef.getResponseFields().forEach(resTField -> {
                if (resTField.getLocation() == LocationType.Header) {
                    this.fillHeaderField(httpResponse, finalResT, (Field)resTField);
                }
            });
            if (finalResT instanceof SdkResponse) {
                SdkResponse sdkResponse = (SdkResponse)finalResT;
                sdkResponse.setHttpStatusCode(httpResponse.getStatusCode());
            }
            return finalResT;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Can not create response instance", (Throwable)e);
            return null;
        }
        catch (SdkException e) {
            logger.error("can not parse json result to response object", (Throwable)e);
            throw new ServerResponseException(httpResponse.getStatusCode(), null, httpResponse.getBodyAsString(), httpResponse.getHeader("X-Request-Id"));
        }
    }

    public <ResT> Object responseToObject(String respBody, Field<ResT, ?> responseField) {
        Object obj = responseField.getFieldType().isAssignableFrom(List.class) ? JsonUtils.toListObject(respBody, responseField.getInnerContainerType()) : (responseField.getFieldType().isAssignableFrom(Map.class) ? JsonUtils.toMapObject(respBody, responseField.getInnerContainerType()) : respBody);
        return obj;
    }

    private <ResT> void fillHeaderField(HttpResponse httpResponse, ResT wrapperResponse, Field<ResT, ?> field) {
        List<String> infos = httpResponse.getHeaders().get(field.getName());
        if (Objects.nonNull(infos) && infos.size() > 0) {
            if (field.getFieldType().isAssignableFrom(List.class)) {
                field.writeValueSafe(wrapperResponse, infos, List.class);
            } else {
                field.writeValueSafe(wrapperResponse, infos.get(0), String.class);
                if (infos.size() > 1) {
                    logger.error("field {} passed list {}, but configured as single value", (Object)field.getName(), (Object)infos.stream().collect(Collectors.joining(",")));
                }
            }
        } else {
            logger.warn("field {} in header read response value is empty", (Object)field.getName());
        }
    }

    @Override
    public void configJson(Consumer<ObjectMapper> func) {
        func.accept(JsonUtils.getDefaultMapper());
    }

    public void printAccessLog(HttpRequest httpRequest, HttpResponse httpResponse, SdkExchange exchange) {
        String requestId = Objects.isNull(httpResponse.getHeader("X-Request-Id")) ? "null" : httpResponse.getHeader("X-Request-Id");
        AccessLog.get().info("\"{} {}\" {} {} {} {}", new Object[]{httpRequest.getMethod(), httpRequest.getUrl(), httpResponse.getStatusCode(), httpResponse.getContentLength(), requestId, Objects.nonNull(exchange) && Objects.nonNull(exchange.getApiTimer()) ? Long.valueOf(exchange.getApiTimer().getDurationMs()) : ""});
    }

    public static class AccessLog {
        private static final Logger logger = LoggerFactory.getLogger((String)"HuaweiCloud-SDK-Access");

        public static Logger get() {
            return logger;
        }
    }
}

