/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.BinaryUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AKSKSigner {
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String ISO_8601_BASIC_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    protected static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public static Map<String, String> sign(HttpRequest request, AbstractCredentials credential) {
        String[] split;
        Date now = new Date();
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        URL url = request.getUrl();
        String canonicalHost = url.getAuthority();
        authenticationHeaders.put("Host", canonicalHost);
        String dateTimeStamp = null;
        if (!request.haveHeader("X-Sdk-Date").booleanValue()) {
            ISO_DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "UTC"));
            dateTimeStamp = ISO_DATE_FORMAT.format(now);
            authenticationHeaders.put("X-Sdk-Date", dateTimeStamp);
        } else {
            dateTimeStamp = request.getHeader("X-Sdk-Date").toString();
        }
        TreeMap<String, String> allHeaders = new TreeMap<String, String>();
        allHeaders.putAll(request.getHeaders().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), entry -> (String)((List)entry.getValue()).get(0))));
        allHeaders.putAll(authenticationHeaders.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), Map.Entry::getValue)));
        String pathOld = url.getPath();
        String canonicalURI = "";
        for (String urlSplit : split = pathOld.split("/")) {
            canonicalURI = canonicalURI + AKSKSigner.urlEncode(urlSplit) + "/";
        }
        String query = url.getQuery();
        Map<String, List<String>> parameters = request.getQueryParams();
        String canonicalQueryString = AKSKSigner.buildCanonicalQueryString(query, parameters);
        String signedHeaderNames = String.join((CharSequence)";", allHeaders.keySet());
        String canonicalHeaders = AKSKSigner.buildCanonicalHeaders(allHeaders);
        String payloadHash = AKSKSigner.buildPayloadHash(request);
        String canonicalRequest = AKSKSigner.buildCanonicalRequest(request.getMethod().name(), canonicalURI, canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String canonicalRequestHash = BinaryUtils.toHex(AKSKSigner.sha256(canonicalRequest));
        String stringToSign = AKSKSigner.getStringToSign("SDK-HMAC-SHA256", dateTimeStamp, canonicalRequestHash);
        String signatureString = AKSKSigner.signature(stringToSign, credential.getSk());
        StringBuilder authorization = new StringBuilder("SDK-HMAC-SHA256").append(" ");
        authorization.append("Access=").append(credential.getAk()).append(", ");
        authorization.append("SignedHeaders=").append(signedHeaderNames).append(", ");
        authorization.append("Signature=").append(signatureString);
        authenticationHeaders.put("Authorization", authorization.toString());
        return authenticationHeaders;
    }

    private static String buildCanonicalQueryString(String query, Map<String, List<String>> parameters) {
        SortedMap<String, List<String>> sorted = AKSKSigner.convertQuery2SortedMap(query);
        StringBuilder builder = new StringBuilder();
        if (parameters == null || parameters.isEmpty()) {
            builder.toString();
        }
        for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
            String key = pair.getKey();
            List<String> values = pair.getValue();
            ArrayList<String> escapedValues = new ArrayList<String>();
            for (String value : values) {
                escapedValues.add(AKSKSigner.urlEncode(value));
            }
            sorted.put(AKSKSigner.urlEncode(key), escapedValues);
        }
        Iterator<Map.Entry<String, List<String>>> itr = sorted.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, List<String>> pair = itr.next();
            for (int i = 0; i < pair.getValue().size(); ++i) {
                builder.append(pair.getKey());
                builder.append("=");
                builder.append(pair.getValue().get(i));
                if (i >= pair.getValue().size() - 1) continue;
                builder.append("&");
            }
            if (pair.getValue().size() == 0) {
                builder.append(pair.getKey()).append("=");
            }
            if (!itr.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    private static SortedMap<String, List<String>> convertQuery2SortedMap(String query) {
        String[] splitArr;
        TreeMap<String, List<String>> sorted = new TreeMap<String, List<String>>();
        if (query == null || query.isEmpty()) {
            return sorted;
        }
        for (String split : splitArr = query.split("&")) {
            String[] kv = split.split("=");
            if (kv.length != 2) continue;
            if (!sorted.containsKey(AKSKSigner.urlEncode(kv[0]))) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(AKSKSigner.urlEncode(kv[1]));
                sorted.put(AKSKSigner.urlEncode(kv[0]), values);
                continue;
            }
            ((List)sorted.get(AKSKSigner.urlEncode(kv[0]))).add(AKSKSigner.urlEncode(kv[1]));
        }
        return sorted;
    }

    private static String buildCanonicalHeaders(Map<String, String> heads) {
        StringBuilder sb = new StringBuilder();
        heads.forEach((key, value) -> {
            sb.append((String)key).append(":").append((String)value);
            sb.append("\n");
        });
        return sb.toString();
    }

    private static String buildPayloadHash(HttpRequest request) {
        if (request.haveHeader("X-Sdk-Content-Sha256").booleanValue()) {
            return request.getHeader("X-Sdk-Content-Sha256");
        }
        if (Objects.nonNull(request.getBodyAsString()) && !request.getBodyAsString().isEmpty()) {
            return BinaryUtils.toHex(AKSKSigner.sha256(request.getBodyAsString()));
        }
        return EMPTY_BODY_SHA256;
    }

    private static String buildCanonicalRequest(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    private static String getStringToSign(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    private static String signature(String stringToSign, String secretKey) {
        try {
            byte[] keySecret = secretKey.getBytes("UTF-8");
            byte[] signature = AKSKSigner.hmac(keySecret, stringToSign);
            return BinaryUtils.toHex(signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkException(e);
        }
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8").replace("+", "%20").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkException("UTF-8 encoding is not supported.", e);
        }
    }

    public static byte[] sha256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes("UTF-8"));
            byte[] bytes = md.digest();
            return bytes;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new SdkException("Unable to compute hash while signing request", e);
        }
    }

    protected static byte[] hmac(byte[] key, String data) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKeySpec);
            return hmac.doFinal(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SdkException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public static class Constants {
        public static final String LINE_SEPARATOR = "\n";
        public static final String SDK_NAME = "SDK";
        public static final String SDK_TERMINATOR = "sdk_request";
        public static final String SDK_SIGNING_ALGORITHM = "SDK-HMAC-SHA256";
        public static final String X_SDK_DATE = "X-Sdk-Date";
        public static final String X_SDK_CONTENT_SHA256 = "X-Sdk-Content-Sha256";
        public static final String AUTHORIZATION = "Authorization";
        public static final String HOST = "Host";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    }
}

