/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.AKSKSigner;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.AuthCache;
import com.huaweicloud.sdk.core.auth.GlobalCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.internal.InnerIamMeta;
import com.huaweicloud.sdk.core.internal.model.KeystoneCreateProjectRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneCreateProjectResponse;
import com.huaweicloud.sdk.core.internal.model.KeystoneListAuthDomainsRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneListAuthDomainsResponse;
import com.huaweicloud.sdk.core.internal.model.KeystoneListProjectsRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneListProjectsResponse;
import com.huaweicloud.sdk.core.internal.model.KeystoneListRegionsRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneListRegionsResponse;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class BasicCredentials
extends AbstractCredentials<BasicCredentials> {
    private String projectId;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public BasicCredentials withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    Map<String, Object> getPathParams() {
        LinkedHashMap<String, Object> pathParam = new LinkedHashMap<String, Object>();
        if (Objects.nonNull(this.projectId)) {
            pathParam.put("project_id", this.projectId);
        }
        return pathParam;
    }

    @Override
    public CompletableFuture<ICredential> processAuthParams(HcClient hcClient, String regionId) {
        KeystoneListProjectsRequest request;
        if (!StringUtils.isEmpty(this.projectId)) {
            return CompletableFuture.completedFuture(this);
        }
        String akWithName = this.getAk() + regionId;
        if (Objects.nonNull(AuthCache.getAuth(akWithName)) && !StringUtils.isEmpty(AuthCache.getAuth(akWithName))) {
            this.projectId = AuthCache.getAuth(akWithName);
            return CompletableFuture.completedFuture(this);
        }
        String iamEndpoint = StringUtils.isEmpty(this.getIamEndpoint()) ? "https://iam.myhuaweicloud.com" : this.getIamEndpoint();
        HcClient inner = hcClient.overrideEndpoint(iamEndpoint);
        KeystoneListProjectsResponse response = inner.syncInvokeHttp(request = new KeystoneListProjectsRequest().withName(regionId), InnerIamMeta.KEYSTONE_LIST_PROJECTS);
        if (Objects.isNull(response)) {
            throw new SdkException("failed to get project id");
        }
        this.projectId = response.getProjects().size() == 1 ? response.getProjects().get(0).getId() : this.keystoneCreateProject(inner, regionId);
        AuthCache.putAuth(akWithName, this.projectId);
        return CompletableFuture.completedFuture(this);
    }

    private String keystoneCreateProject(HcClient client, String regionId) {
        List<String> supportedRegions = this.getSupportedRegions(client);
        if (Objects.isNull(supportedRegions) || supportedRegions.size() == 0) {
            throw new SdkException("failed to list regions");
        }
        if (!supportedRegions.contains(regionId)) {
            throw new SdkException("the region input is not supported to create project automatically");
        }
        String domainId = this.getDomainId(client);
        if (StringUtils.isEmpty(domainId)) {
            throw new SdkException("failed to get domain id");
        }
        return this.getCreateProjectId(client, regionId, domainId);
    }

    private List<String> getSupportedRegions(HcClient hcClient) {
        KeystoneListRegionsRequest request = new KeystoneListRegionsRequest();
        KeystoneListRegionsResponse response = hcClient.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_REGIONS);
        if (Objects.isNull(response)) {
            throw new SdkException("failed to list all regions");
        }
        return response.getRegions().stream().map(region -> {
            if ("public".equals(region.getType())) {
                return region.getId();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getDomainId(HcClient hcClient) {
        KeystoneListAuthDomainsRequest request = new KeystoneListAuthDomainsRequest();
        KeystoneListAuthDomainsResponse response = hcClient.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_AUTH_DOMAINS);
        if (Objects.isNull(response)) {
            throw new SdkException("failed to get domain id");
        }
        return response.getDomains().get(0).getId();
    }

    private String getCreateProjectId(HcClient hcClient, String regionId, String domainId) {
        KeystoneCreateProjectRequest request;
        GlobalCredentials globalCredentials = ((GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withAk(this.getAk())).withSk(this.getSk())).withDomainId(domainId);
        HcClient innerGlobal = hcClient.overrideCredential(globalCredentials);
        KeystoneCreateProjectResponse response = innerGlobal.syncInvokeHttp(request = new KeystoneCreateProjectRequest().withBody(body -> body.withProject(project -> {
            project.withName(regionId);
            project.withDomainId(domainId);
        })), InnerIamMeta.KEYSTONE_CREATE_PROJECT);
        if (Objects.isNull(response.getProject())) {
            throw new SdkException("failed to create project");
        }
        return response.getProject().getId();
    }

    @Override
    public CompletableFuture<HttpRequest> processAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        return CompletableFuture.supplyAsync(() -> {
            HttpRequest.HttpRequestBuilder builder = httpRequest.builder().addAutoFilledPathParam(this.getPathParams());
            if (Objects.nonNull(this.getProjectId())) {
                builder.addHeader("X-Project-Id", this.projectId);
            }
            if (Objects.nonNull(this.getSecurityToken())) {
                builder.addHeader("X-Security-Token", this.getSecurityToken());
            }
            if (Objects.nonNull(httpRequest.getContentType()) && !httpRequest.getContentType().startsWith("application/json")) {
                builder.addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD");
            }
            Map<String, String> header = AKSKSigner.sign(builder.build(), this);
            builder.addHeaders(header);
            return builder.build();
        });
    }

    @Override
    public BasicCredentials deepClone() {
        return (BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)new BasicCredentials().withProjectId(this.projectId).withAk(this.getAk())).withSk(this.getSk())).withIamEndpoint(this.getIamEndpoint())).withSecurityToken(this.getSecurityToken());
    }
}

