/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.exception;

import com.huaweicloud.sdk.core.exception.ClientRequestException;
import com.huaweicloud.sdk.core.exception.SdkErrorMessage;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServerResponseException;
import java.util.Objects;

public class ServiceResponseException
extends SdkException {
    private int httpStatusCode;
    private String errorMsg;
    private String errorCode;
    private String requestId;

    public ServiceResponseException(int httpStatusCode, SdkErrorMessage sdkErrorMessage) {
        super(Objects.nonNull(sdkErrorMessage) ? sdkErrorMessage.getErrorMsg() : "ServiceResponseException");
        this.httpStatusCode = httpStatusCode;
        if (Objects.nonNull(sdkErrorMessage)) {
            this.errorCode = sdkErrorMessage.getErrorCode();
            this.errorMsg = sdkErrorMessage.getErrorMsg();
            this.requestId = sdkErrorMessage.getRequestId();
        }
    }

    public ServiceResponseException(int httpStatusCode, String errorCode, String errorMsg, String requestId) {
        super(errorMsg);
        this.httpStatusCode = httpStatusCode;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.requestId = requestId;
    }

    public static ServiceResponseException mapException(int httpStatusCode, SdkErrorMessage sdkErrorMessage) {
        if (Objects.isNull(sdkErrorMessage)) {
            return ServiceResponseException.mapException(httpStatusCode, null, null, null);
        }
        return ServiceResponseException.mapException(httpStatusCode, sdkErrorMessage.getErrorCode(), sdkErrorMessage.getErrorMsg(), sdkErrorMessage.getRequestId());
    }

    public static ServiceResponseException mapException(int httpStatusCode, String errorCode, String errorMsg, String requestId) {
        if (httpStatusCode >= 400 && httpStatusCode < 499) {
            return new ClientRequestException(httpStatusCode, errorCode, errorMsg, requestId);
        }
        if (httpStatusCode >= 500 && httpStatusCode < 600) {
            return new ServerResponseException(httpStatusCode, errorCode, errorMsg, requestId);
        }
        return new ServiceResponseException(httpStatusCode, errorCode, errorMsg, requestId);
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " {\n");
        sb.append("    httpStatusCode: ").append(this.toIndentedString(this.httpStatusCode)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMsg: ").append(this.toIndentedString(this.errorMsg)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

