/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.http;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.Field;
import com.huaweicloud.sdk.core.http.FieldExistence;
import com.huaweicloud.sdk.core.http.LocationType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FieldImpl<R, FieldT>
implements Field<R, FieldT> {
    String name;
    LocationType locationType;
    FieldExistence existence;
    Class<FieldT> fieldType;
    Function<R, Boolean> isValueProvidedFunc;
    Function<R, FieldT> valueReader;
    BiConsumer<R, FieldT> writer;
    Class<?> innerContainerType;

    public FieldImpl(String name, LocationType locationType, FieldExistence existence, Class<FieldT> fieldType) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.locationType = Objects.requireNonNull(locationType, "locationType cannot be null");
        this.existence = Objects.requireNonNull(existence, "existence cannot be null");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType cannot be null");
        this.isValueProvidedFunc = null;
        this.valueReader = null;
        this.writer = null;
    }

    public <T> FieldImpl<R, FieldT> withInnerContainerType(Class<T> innerContainerType) {
        this.innerContainerType = innerContainerType;
        return this;
    }

    public FieldImpl<R, FieldT> withReader(Function<R, FieldT> valueReader) {
        Objects.requireNonNull(valueReader, "valueReader cannot be null");
        this.valueReader = valueReader;
        return this;
    }

    public FieldImpl<R, FieldT> withWriter(BiConsumer<R, FieldT> writer) {
        this.writer = writer;
        return this;
    }

    public FieldImpl<R, FieldT> withMarshaller(Function<R, FieldT> valueReader, BiConsumer<R, FieldT> writer) {
        return this.withReader(valueReader).withWriter(writer);
    }

    public FieldImpl<R, FieldT> withValueProvideTest(Function<R, Boolean> valuePresenceTester) {
        this.isValueProvidedFunc = valuePresenceTester;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocationType getLocation() {
        return this.locationType;
    }

    @Override
    public FieldExistence getExistence() {
        return this.existence;
    }

    @Override
    public Optional<FieldT> readValue(R request) {
        FieldT value = this.valueReader.apply(request);
        if (value == null) {
            if (this.existence == FieldExistence.NULL_IGNORE) {
                return Optional.empty();
            }
            throw new SdkException("request field " + this.name + " read null value. existence is: " + this.existence.toString());
        }
        if (this.existence == FieldExistence.NON_NULL_NON_EMPTY && value.getClass() == String.class && ((String)value).isEmpty()) {
            throw new SdkException("request field " + this.name + " read empty value. not allowed by " + this.existence.toString());
        }
        return Optional.of(value);
    }

    @Override
    public boolean isValueProvided(R request) {
        if (this.isValueProvidedFunc != null) {
            return this.isValueProvidedFunc.apply(request);
        }
        throw new SdkException("isValueProvided bad call");
    }

    @Override
    public void writeValue(R request, FieldT value, Class<FieldT> clazz) {
        this.writeValueSafe(request, (Object)value, (Class<?>)clazz);
    }

    @Override
    public void writeValueSafe(R request, Object value, Class<?> clazz) {
        if (this.fieldType.isAssignableFrom(clazz)) {
            this.writer.accept(request, value);
        } else {
            FieldT enumValue = this.tryFindEnumField(request, value, clazz).orElseThrow(() -> new SdkException("input value " + value + " with class " + clazz.getSimpleName() + " is not compatible with expected class " + this.fieldType.getSimpleName()));
            this.writer.accept(request, enumValue);
        }
    }

    private <T> Optional<FieldT> tryFindEnumField(R request, Object value, Class<T> clazz) {
        if (!this.fieldType.isEnum() || !clazz.isAssignableFrom(String.class)) {
            return Optional.empty();
        }
        FieldT[] enumValues = this.fieldType.getEnumConstants();
        if (enumValues == null) {
            return Optional.empty();
        }
        for (FieldT enumValue : enumValues) {
            if (!enumValue.toString().equals(value)) continue;
            return Optional.of(enumValue);
        }
        return Optional.empty();
    }

    @Override
    public Class<FieldT> getFieldType() {
        return this.fieldType;
    }

    @Override
    public Class<?> getInnerContainerType() {
        return this.innerContainerType;
    }
}

