/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.http;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpMethod;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HttpRequest {
    public static HttpRequestBuilder newBuilder() {
        return new HttpRequestBuilder();
    }

    public HttpRequestBuilder builder();

    public String getEndpoint();

    public String getPath();

    public HttpMethod getMethod();

    public Map<String, List<String>> getQueryParams();

    public Map<String, List<String>> getHeaders();

    public Boolean haveHeader(String var1);

    public String getHeader(String var1);

    public String getContentType();

    public String getBodyAsString();

    public String getQueryParamsString();

    public String getPathParamsString();

    public URL getUrl();

    public InputStream getBody();

    public static class Impl
    implements HttpRequest,
    Cloneable {
        private static final Logger LOG = LoggerFactory.getLogger(Impl.class);
        private String endpoint;
        private String path;
        private HttpMethod method = HttpMethod.GET;
        private Map<String, List<String>> queryParams = new LinkedHashMap<String, List<String>>();
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Map<String, Object> pathParams = new LinkedHashMap<String, Object>();
        private Map<String, Object> autoFilledPathParams = new LinkedHashMap<String, Object>();
        private String contentType = "application/json";
        private String bodyAsString;
        private String queryParamsString;
        private String pathParamsString;
        private URL url;
        private InputStream body;

        @Override
        public HttpRequestBuilder builder() {
            try {
                return new HttpRequestBuilder(this.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new SdkException("Can not create a new builder", e);
            }
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public Map<String, List<String>> getQueryParams() {
            return this.queryParams;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Override
        public Boolean haveHeader(String name) {
            if (Objects.isNull(this.headers)) {
                return false;
            }
            return this.headers.containsKey(name);
        }

        @Override
        public String getHeader(String name) {
            if (Objects.isNull(this.headers)) {
                return null;
            }
            List<String> values = this.headers.get(name);
            return Objects.isNull(values) || values.isEmpty() ? null : values.get(0);
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Override
        public String getQueryParamsString() {
            return this.queryParamsString;
        }

        @Override
        public String getPathParamsString() {
            return this.pathParamsString;
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public InputStream getBody() {
            return this.body;
        }

        public Impl clone() throws CloneNotSupportedException {
            Impl impl = (Impl)super.clone();
            impl.method = this.method;
            impl.bodyAsString = this.bodyAsString;
            impl.contentType = this.contentType;
            impl.endpoint = this.endpoint;
            impl.path = this.path;
            impl.pathParams = new HashMap<String, Object>(this.pathParams);
            impl.autoFilledPathParams = new HashMap<String, Object>(this.autoFilledPathParams);
            impl.queryParams = new HashMap<String, List<String>>(this.queryParams);
            impl.headers = new HashMap<String, List<String>>(this.headers);
            return impl.buildPathParamsString().buildQueryParamsString().buildUrl();
        }

        private Impl buildPathParamsString() {
            this.pathParamsString = Objects.isNull(this.path) ? "" : this.path;
            this.pathParams.forEach((key, value) -> {
                this.pathParamsString = this.pathParamsString.replace(String.format("{%s}", key), value.toString());
            });
            this.autoFilledPathParams.forEach((key, value) -> {
                this.pathParamsString = this.pathParamsString.replace(String.format("{%s}", key), value.toString());
            });
            return this;
        }

        private Impl buildQueryParamsString() {
            StringBuilder sb = new StringBuilder();
            this.queryParams.forEach((key, values) -> {
                if (values.size() == 0) {
                    sb.append(String.format("%s=&", key));
                }
                values.forEach(value -> {
                    if (value.isEmpty()) {
                        sb.append(String.format("%s=&", key));
                    } else {
                        sb.append(String.format("%s=%s&", key, value));
                    }
                });
            });
            this.queryParamsString = sb.length() > 0 ? sb.deleteCharAt(sb.length() - 1).toString() : sb.toString();
            return this;
        }

        private Impl buildUrl() {
            try {
                this.url = !StringUtils.isEmpty((CharSequence)this.queryParamsString) ? new URL(this.endpoint + this.pathParamsString + "?" + this.queryParamsString) : new URL(this.endpoint + this.pathParamsString);
            }
            catch (MalformedURLException e) {
                LOG.error("region endpoint can not be found");
                throw new SdkException(e);
            }
            return this;
        }
    }

    public static class HttpRequestBuilder {
        private Impl httpRequest;

        private HttpRequestBuilder() {
            this.httpRequest = new Impl();
        }

        private HttpRequestBuilder(Impl httpRequest) {
            this.httpRequest = httpRequest;
        }

        public HttpRequestBuilder withEndpoint(String endpoint) {
            this.httpRequest.endpoint = endpoint;
            return this;
        }

        public HttpRequestBuilder withPath(String path) {
            this.httpRequest.path = path;
            return this;
        }

        public HttpRequestBuilder withContentType(String contentType) {
            this.httpRequest.contentType = contentType;
            if (Objects.nonNull(contentType)) {
                this.addHeader("Content-Type", contentType);
            }
            return this;
        }

        public HttpRequestBuilder withMethod(HttpMethod method) {
            this.httpRequest.method = method;
            return this;
        }

        public HttpRequestBuilder withBodyAsString(String bodyAsString) {
            this.httpRequest.bodyAsString = bodyAsString;
            return this;
        }

        public HttpRequestBuilder withBody(InputStream body) {
            this.httpRequest.body = body;
            return this;
        }

        public HttpRequestBuilder addHeader(String key, String value) {
            if (this.httpRequest.headers.containsKey(key) && Objects.nonNull(this.httpRequest.headers.get(key))) {
                ((List)this.httpRequest.headers.get(key)).add(value);
            } else {
                this.httpRequest.headers.put(key, Arrays.asList(value));
            }
            return this;
        }

        public HttpRequestBuilder addHeaders(Map<String, String> headers) {
            headers.entrySet().forEach(entry -> this.addHeader((String)entry.getKey(), (String)entry.getValue()));
            return this;
        }

        public HttpRequestBuilder addQueryParam(String key, List<String> value) {
            this.httpRequest.queryParams.putIfAbsent(key, value);
            return this;
        }

        public HttpRequestBuilder addPathParam(String key, Object value) {
            this.httpRequest.pathParams.putIfAbsent(key, value);
            return this;
        }

        public HttpRequestBuilder addPathParam(Map<String, Object> pathParam) {
            this.httpRequest.pathParams.putAll(pathParam);
            return this;
        }

        public HttpRequestBuilder addAutoFilledPathParam(String key, String value) {
            this.httpRequest.autoFilledPathParams.putIfAbsent(key, value);
            return this;
        }

        public HttpRequestBuilder addAutoFilledPathParam(Map<String, Object> pathParam) {
            this.httpRequest.autoFilledPathParams.putAll(pathParam);
            return this;
        }

        public HttpRequest build() {
            return this.httpRequest.buildPathParamsString().buildQueryParamsString().buildUrl();
        }
    }
}

