/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.utils;

import com.huaweicloud.sdk.core.exception.SdkErrorMessage;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import java.util.Map;
import java.util.Objects;

public class ExceptionUtils {
    public static SdkErrorMessage extractErrorMessage(HttpResponse httpResponse) {
        String strBody = httpResponse.getBodyAsString();
        SdkErrorMessage sdkErrorMessage = new SdkErrorMessage(httpResponse.getStatusCode());
        if (Objects.isNull(strBody)) {
            return sdkErrorMessage;
        }
        try {
            Map errResult = JsonUtils.toObject(strBody, Map.class);
            if (Objects.isNull(errResult)) {
                return sdkErrorMessage;
            }
            ExceptionUtils.processErrorMessageFromMap(sdkErrorMessage, errResult);
            ExceptionUtils.processErrorMessageFromNestedMap(sdkErrorMessage, errResult);
            if (Objects.isNull(sdkErrorMessage.getErrorMsg())) {
                sdkErrorMessage.setErrorMsg(strBody);
            }
            if (Objects.isNull(sdkErrorMessage.getRequestId()) && Objects.nonNull(httpResponse.getHeader("X-Request-Id"))) {
                sdkErrorMessage.setRequestId(httpResponse.getHeader("X-Request-Id"));
            }
        }
        catch (SdkException e) {
            sdkErrorMessage.setErrorMsg(httpResponse.getBodyAsString());
        }
        return sdkErrorMessage;
    }

    private static void processErrorMessageFromMap(SdkErrorMessage sdkErrorMessage, Map errResult) {
        sdkErrorMessage.withErrorCode(errResult.containsKey("error_code") ? errResult.get("error_code").toString() : (errResult.containsKey("code") ? errResult.get("code").toString() : null)).withErrorMsg(errResult.containsKey("error_msg") ? errResult.get("error_msg").toString() : (errResult.containsKey("message") ? errResult.get("message").toString() : null)).withRequestId(errResult.containsKey("request_id") ? errResult.get("request_id").toString() : null);
    }

    private static void processErrorMessageFromNestedMap(SdkErrorMessage sdkErrorMessage, Map errResult) {
        if (!Objects.isNull(sdkErrorMessage.getErrorCode()) && !Objects.isNull(sdkErrorMessage.getErrorMsg())) {
            return;
        }
        errResult.forEach((key, value) -> {
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                if (Objects.isNull(sdkErrorMessage.getErrorCode()) && valueMap.containsKey("code")) {
                    sdkErrorMessage.setErrorCode(valueMap.get("code").toString());
                }
                if (Objects.isNull(sdkErrorMessage.getErrorMsg()) && valueMap.containsKey("message")) {
                    sdkErrorMessage.setErrorMsg(valueMap.get("message").toString());
                }
            }
        });
    }
}

