/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.cloud.sdk.core.util.ByteArrayTypeAdapter;
import com.ibm.cloud.sdk.core.util.DateTimeTypeAdapter;
import com.ibm.cloud.sdk.core.util.DiscriminatorBasedTypeAdapterFactory;
import com.ibm.cloud.sdk.core.util.DynamicModelTypeAdapterFactory;
import java.io.IOException;
import java.util.Date;

public final class GsonSingleton {
    private static Gson gson;
    private static Gson gsonWithoutPrinting;
    public static final TypeAdapter<Number> LAZILY_PARSED_NUMBER_ADAPTER;

    private GsonSingleton() {
    }

    private static Gson createGson(boolean prettyPrint, boolean serializeNulls) {
        GsonBuilder builder = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER).setNumberToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LAZILY_PARSED_NUMBER);
        GsonSingleton.registerTypeAdapters(builder);
        if (prettyPrint) {
            builder.setPrettyPrinting();
        }
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.disableHtmlEscaping();
        return builder.create();
    }

    private static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(Date.class, (Object)new DateTimeTypeAdapter());
        builder.registerTypeAdapter(byte[].class, (Object)new ByteArrayTypeAdapter());
        builder.registerTypeAdapter(LazilyParsedNumber.class, LAZILY_PARSED_NUMBER_ADAPTER);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new DynamicModelTypeAdapterFactory());
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new DiscriminatorBasedTypeAdapterFactory());
    }

    public static synchronized Gson getGson() {
        if (gson == null) {
            gson = GsonSingleton.createGson(true, false);
        }
        return gson;
    }

    public static synchronized Gson getGsonWithoutPrettyPrinting() {
        if (gsonWithoutPrinting == null) {
            gsonWithoutPrinting = GsonSingleton.createGson(false, false);
        }
        return gsonWithoutPrinting;
    }

    public static Gson getGsonWithSerializeNulls() {
        return GsonSingleton.createGson(false, true);
    }

    static {
        LAZILY_PARSED_NUMBER_ADAPTER = new TypeAdapter<Number>(){

            public Number read(JsonReader in) throws IOException {
                JsonToken jsonToken = in.peek();
                switch (jsonToken) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                    case NUMBER: 
                    case STRING: {
                        return new LazilyParsedNumber(in.nextString());
                    }
                }
                throw new JsonSyntaxException("Expecting number, got: " + jsonToken);
            }

            public void write(JsonWriter out, Number value) throws IOException {
                out.value(value);
            }
        };
    }
}

