/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.BindingType;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import java.io.IOException;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Binding {
    String _varname = null;
    MappingExpressionParser.ExprContext _expr = null;
    DeclaredFunction _fct = null;
    BindingType _type;

    public Binding(String expression) throws ParseException, IOException {
        Expressions exprCTX = Expressions.parse(expression);
        ParseTree tree = exprCTX.getTree();
        try {
            if (tree instanceof MappingExpressionParser.Var_assignContext) {
                MappingExpressionParser.ExprContext expr;
                MappingExpressionParser.Var_assignContext ctx = (MappingExpressionParser.Var_assignContext)tree;
                this._varname = ctx.VAR_ID().getText();
                this._expr = expr = ctx.expr();
                this._type = BindingType.VARIABLE;
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Can not transform expression to a variable assignment");
        }
    }

    public Binding(String varName, String expression) throws ParseException, IOException {
        if (!varName.startsWith("$")) {
            varName = "$" + varName;
        }
        Expressions exprCTX = Expressions.parse(expression);
        ParseTree tree = exprCTX.getTree();
        try {
            if (tree instanceof MappingExpressionParser.Function_declContext) {
                DeclaredFunction fct;
                MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)tree;
                MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
                MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
                this._fct = fct = new DeclaredFunction(varList, exprList);
                this._type = BindingType.FUNCTION;
                this._varname = varName;
            } else if (tree instanceof MappingExpressionParser.Var_assignContext) {
                MappingExpressionParser.ExprContext expr;
                MappingExpressionParser.Var_assignContext ctx = (MappingExpressionParser.Var_assignContext)tree;
                this._varname = ctx.VAR_ID().getText();
                this._expr = expr = ctx.expr();
                this._type = BindingType.VARIABLE;
                this._varname = varName;
            } else if (tree instanceof MappingExpressionParser.IdContext) {
                this._expr = new MappingExpressionParser.StringContext(new MappingExpressionParser.ExprContext());
                this._expr.addChild((TerminalNode)tree.getChild(0));
                this._type = BindingType.VARIABLE;
                this._varname = varName;
            } else {
                this._expr = (MappingExpressionParser.ExprContext)tree;
                this._type = BindingType.VARIABLE;
                this._varname = varName;
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Can not transform expression to a function declaration");
        }
    }

    public String getVarName() {
        return this._varname;
    }

    public DeclaredFunction getFunction() {
        return this._fct;
    }

    public MappingExpressionParser.ExprContext getExpression() {
        return this._expr;
    }

    public BindingType getType() {
        return this._type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this._type) {
            case VARIABLE: {
                sb.append(this._varname);
                sb.append("=");
                sb.append(this._expr.getText());
                break;
            }
            case FUNCTION: {
                sb.append("function(");
                List<TerminalNode> varList = this._fct.getVariables();
                int count = 0;
                for (TerminalNode tn : varList) {
                    if (count > 0) {
                        sb.append(",");
                    }
                    sb.append(tn.getText());
                    ++count;
                }
                sb.append("){");
                MappingExpressionParser.ExprListContext expListCtx = this._fct.getExpressionList();
                sb.append(expListCtx.getText());
                sb.append("}");
                break;
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Binding test = new Binding("$x:=4");
            System.out.println(test);
            test = new Binding("addx", "function($a,$b){$a+$b}");
            System.out.println(test);
        }
        catch (ParseException | IOException e) {
            e.printStackTrace();
        }
    }
}

