/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import java.time.Instant;

public class MillisFunction
extends FunctionBase
implements Function {
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$millis");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        LongNode result = null;
        int argCount = MillisFunction.getArgumentCount(ctx);
        if (argCount != 0) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        long millis = Instant.now().toEpochMilli();
        result = new LongNode(millis);
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 0;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<:n>";
    }
}

