/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.FrameFormatException;
import com.ibm.ws.wsoc.FrameState;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.WsocBufferException;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FrameReadProcessor {
    private static final TraceComponent tc = Tr.register(FrameReadProcessor.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private static final int BUFFER_ARRAY_INITIAL_SIZE = 10;
    private static final int BUFFER_ARRAY_GROWTH_SIZE = 10;
    private static final byte FIN_MASK = -128;
    private static final byte RSV_MASK = 112;
    private static final byte RSV_SHIFT = 4;
    private static final byte OPCODE_MASK = 15;
    private static final byte MASK_FLAG_MASK = -128;
    private static final byte FIRST_PAYLOAD_LEN_MASK = 127;
    private static final byte OPCODE_TEXT_DATA = 1;
    private static final byte OPCODE_BINARY_DATA = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int SIZE_INIT = 2;
    private static final int SIZE_16BIT_PAYLOAD_LENGTH = 2;
    private static final int SIZE_64BIT_PAYLOAD_LENGTH = 8;
    private static final int SIZE_MASK = 4;
    private byte fin;
    private byte rsv;
    private byte opcode;
    private byte maskFlag;
    private int payloadLength7bit;
    private int mask;
    private final byte[] maskArray = new byte[4];
    private long payloadLength;
    FrameState frameState = FrameState.INIT;
    int currentBufferArrayIndex = -1;
    int countOfBuffers = 0;
    byte controlByte1 = 0;
    byte controlByte2 = 0;
    boolean binaryData = false;
    boolean textData = false;
    boolean controlFrame = false;
    OpcodeType controlOpcodeType;
    boolean shouldReadMaskedData = false;
    private WsByteBuffer[] frameBuffers = new WsByteBuffer[10];
    static final long serialVersionUID = -6717461704884155705L;

    public void initialize(boolean shouldReadMaskedData) {
        this.shouldReadMaskedData = shouldReadMaskedData;
    }

    public void reset(boolean releaseBuffers) {
        if (releaseBuffers) {
            this.releaseBuffers();
        }
        this.frameState = FrameState.INIT;
        this.currentBufferArrayIndex = -1;
        this.countOfBuffers = 0;
        this.controlByte1 = 0;
        this.controlByte2 = 0;
        this.frameBuffers = new WsByteBuffer[10];
    }

    public synchronized void releaseBuffers() {
        for (int i = 0; i < this.countOfBuffers; ++i) {
            if (this.frameBuffers[i] == null) continue;
            this.frameBuffers[i].release();
            this.frameBuffers[i] = null;
        }
        this.countOfBuffers = 0;
    }

    public int processNextBuffer(@Sensitive WsByteBuffer buf) throws FrameFormatException, WsocBufferException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Entered processNextBuffer with frameState of:  " + (Object)((Object)this.frameState)), (Object[])new Object[0]);
        }
        if (this.frameState == FrameState.PAYLOAD_COMPLETE) {
            return -3;
        }
        if (this.countOfBuffers >= this.frameBuffers.length) {
            int originalSize = this.frameBuffers.length;
            WsByteBuffer[] temp = new WsByteBuffer[originalSize + 10];
            System.arraycopy(this.frameBuffers, 0, temp, 0, originalSize);
            this.frameBuffers = temp;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding buf at index:  " + this.countOfBuffers), (Object[])new Object[0]);
        }
        this.frameBuffers[this.countOfBuffers] = buf;
        ++this.countOfBuffers;
        if (this.frameState == FrameState.INIT) {
            long bytesToProcess = this.bytesRemaining();
            if (bytesToProcess < 2L) {
                return -2;
            }
            this.currentBufferArrayIndex = 0;
            this.controlByte1 = this.grabNextByte();
            this.fin = (byte)(this.controlByte1 & 0xFFFFFF80);
            if (this.fin != 0) {
                this.fin = 1;
            }
            this.rsv = (byte)((byte)(this.controlByte1 & 0x70) >>> 4);
            if (this.rsv != 0) {
                throw new FrameFormatException("Reserved frame must be 0.");
            }
            this.opcode = (byte)(this.controlByte1 & 0xF);
            if (this.opcode == 1) {
                this.textData = true;
            } else if (this.opcode == 2) {
                this.binaryData = true;
            } else if (this.opcode == 9) {
                this.controlFrame = true;
                this.controlOpcodeType = OpcodeType.PING;
            } else if (this.opcode == 10) {
                this.controlFrame = true;
                this.controlOpcodeType = OpcodeType.PONG;
            } else if (this.opcode == 8) {
                this.controlFrame = true;
                this.controlOpcodeType = OpcodeType.CONNECTION_CLOSE;
            }
            if (this.controlFrame && this.fin == 0) {
                throw new FrameFormatException("Control frames must have FIN bit set to 1.");
            }
            this.controlByte2 = this.grabNextByte();
            this.maskFlag = (byte)(this.controlByte2 & 0xFFFFFF80);
            if (this.maskFlag != 0) {
                this.maskFlag = 1;
            }
            this.payloadLength7bit = this.controlByte2 & 0x7F;
            if (this.payloadLength7bit == 126) {
                this.frameState = FrameState.FIND_16BIT_PAYLOAD_LENGTH;
            } else if (this.payloadLength7bit == 127) {
                this.frameState = FrameState.FIND_64BIT_PAYLOAD_LENGTH;
            } else {
                this.payloadLength = this.payloadLength7bit;
                this.frameState = FrameState.FIND_MASK;
            }
            if (this.payloadLength7bit >= 126 && this.controlFrame) {
                FrameFormatException e = new FrameFormatException("Control frame must have payload length less than 126 bytes");
                throw e;
            }
        }
        if (this.frameState == FrameState.FIND_16BIT_PAYLOAD_LENGTH) {
            long bytesToProcess = this.bytesRemaining();
            if (bytesToProcess < 2L) {
                return -2;
            }
            this.payloadLength = this.grabNext16BitInt();
            this.frameState = FrameState.FIND_MASK;
        }
        if (this.frameState == FrameState.FIND_64BIT_PAYLOAD_LENGTH) {
            long bytesToProcess = this.bytesRemaining();
            if (bytesToProcess < 8L) {
                return -2;
            }
            this.payloadLength = this.grabNext64BitLong();
            this.frameState = FrameState.FIND_MASK;
        }
        if (this.frameState == FrameState.FIND_MASK) {
            if (this.shouldReadMaskedData) {
                long bytesToProcess = this.bytesRemaining();
                if (bytesToProcess < 4L) {
                    return -2;
                }
                this.mask = this.grabNext32BitInt();
                this.maskArray[0] = (byte)(this.mask >> 24 & 0xFF);
                this.maskArray[1] = (byte)(this.mask >> 16 & 0xFF);
                this.maskArray[2] = (byte)(this.mask >> 8 & 0xFF);
                this.maskArray[3] = (byte)(this.mask & 0xFF);
            }
            this.frameState = FrameState.FIND_PAYLOAD;
        }
        if (this.frameState == FrameState.FIND_PAYLOAD) {
            long count = 0L;
            int remaining = 0;
            for (int i = 0; i < this.countOfBuffers; ++i) {
                remaining = this.frameBuffers[i].remaining();
                if (count + (long)remaining <= this.payloadLength) {
                    if ((count += (long)remaining) != this.payloadLength) continue;
                    this.frameState = FrameState.PAYLOAD_COMPLETE;
                    return -1;
                }
                int nextPosition = this.frameBuffers[i].position() + (int)(this.payloadLength - count);
                this.frameState = FrameState.PAYLOAD_COMPLETE;
                return nextPosition;
            }
            return -2;
        }
        FrameFormatException e = new FrameFormatException("Frame was not processed correctly");
        throw e;
    }

    public byte getFin() {
        return this.fin;
    }

    public byte getRsv() {
        return this.rsv;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public byte getMaskFlag() {
        return this.maskFlag;
    }

    public int getMask() {
        return this.mask;
    }

    @Sensitive
    public byte[] getMaskArray() {
        return this.maskArray;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    @Sensitive
    public WsByteBuffer[] getFrameBuffers() {
        return this.frameBuffers;
    }

    public int getFrameBufferListSize() {
        return this.countOfBuffers;
    }

    @Sensitive
    public WsByteBuffer getBufferAtIndex(int index) {
        return this.frameBuffers[index];
    }

    public FrameState getFrameState() {
        return this.frameState;
    }

    public boolean getControlFrame() {
        return this.controlFrame;
    }

    public OpcodeType getControlOpcodeType() {
        return this.controlOpcodeType;
    }

    public void unmaskPayload() {
        Utils.maskPayload(this.getMaskArray(), this.frameBuffers, this.countOfBuffers);
    }

    private int grabNext16BitInt() throws WsocBufferException {
        int value = 0;
        byte b1 = this.grabNextByte();
        byte b2 = this.grabNextByte();
        value = (b1 & 0xFF) << 8 | b2 & 0xFF;
        return value;
    }

    private int grabNext32BitInt() throws WsocBufferException {
        int value = 0;
        for (int i = 3; i >= 0; --i) {
            byte b = this.grabNextByte();
            value |= (b & 0xFF) << i * 8;
        }
        return value;
    }

    public long grabNext64BitLong() throws WsocBufferException {
        long value = 0L;
        for (int i = 7; i >= 0; --i) {
            byte b = this.grabNextByte();
            value |= ((long)b & 0xFFL) << i * 8;
        }
        return value;
    }

    public long bytesRemaining() {
        long count = 0L;
        for (int i = 0; i < this.countOfBuffers; ++i) {
            count += (long)this.frameBuffers[i].remaining();
        }
        return count;
    }

    private byte grabNextByte() throws WsocBufferException {
        int startArrayIndex;
        int i;
        if (this.frameBuffers[this.currentBufferArrayIndex].hasRemaining()) {
            return this.frameBuffers[this.currentBufferArrayIndex].get();
        }
        for (i = startArrayIndex = this.currentBufferArrayIndex + 1; i < this.countOfBuffers; ++i) {
            if (!this.frameBuffers[i].hasRemaining()) continue;
            byte b = this.frameBuffers[i].get();
            this.currentBufferArrayIndex = i;
            return b;
        }
        this.currentBufferArrayIndex = i;
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"bytes.notavailable", null);
        WsocBufferException e = new WsocBufferException(msg);
        throw e;
    }
}

