/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annocache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.FragmentAnnotations;
import com.ibm.ws.container.service.annocache.WebAnnotations;
import com.ibm.ws.container.service.annocache.internal.AnnotationsAdapterImpl;
import com.ibm.ws.container.service.annocache.internal.FragmentAnnotationsImpl;
import com.ibm.ws.container.service.annocache.internal.ModuleAnnotationsImpl;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.container.service.config.WebFragmentsInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAnnotationsImpl
extends ModuleAnnotationsImpl
implements WebAnnotations {
    private final String webModuleName;
    private final WebFragmentsInfo webFragments;
    private Map<String, WebFragmentInfo> pathToFragments;
    private Map<WebFragmentInfo, String> fragmentToPath;
    static final long serialVersionUID = -286858371504810347L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebAnnotationsImpl(AnnotationsAdapterImpl annotationsAdapter, Container rootContainer, OverlayContainer rootOverlayContainer, ArtifactContainer rootArtifactContainer, Container rootAdaptableContainer, WebModuleInfo webModuleInfo) throws UnableToAdaptException {
        super(annotationsAdapter, rootContainer, rootOverlayContainer, rootArtifactContainer, rootAdaptableContainer, webModuleInfo);
        this.webModuleName = webModuleInfo.getName();
        this.webFragments = (WebFragmentsInfo)rootAdaptableContainer.adapt(WebFragmentsInfo.class);
        this.fragmentToPath = new IdentityHashMap<WebFragmentInfo, String>();
        this.pathToFragments = new HashMap<String, WebFragmentInfo>();
    }

    @Override
    public WebModuleInfo getModuleInfo() {
        return (WebModuleInfo)super.getModuleInfo();
    }

    @Override
    public String getWebModuleName() {
        return this.webModuleName;
    }

    @Override
    public WebFragmentsInfo getWebFragments() {
        return this.webFragments;
    }

    @Override
    public List<WebFragmentInfo> getOrderedItems() {
        return this.getWebFragments().getOrderedFragments();
    }

    @Override
    public List<WebFragmentInfo> getExcludedItems() {
        return this.getWebFragments().getExcludedFragments();
    }

    private String getFragmentPath(WebFragmentInfo fragment) {
        return this.fragmentToPath.get(fragment);
    }

    private String getUniquePath(String fragmentPath) {
        String uniquePath = fragmentPath;
        int count = 1;
        while (this.pathToFragments.containsKey(uniquePath)) {
            uniquePath = fragmentPath + "_" + count;
            ++count;
        }
        return uniquePath;
    }

    private String putUniquePath(WebFragmentInfo fragment, String fragmentPath) {
        String uniqueFragmentPath = this.getUniquePath(fragmentPath);
        this.fragmentToPath.put(fragment, uniqueFragmentPath);
        this.pathToFragments.put(uniqueFragmentPath, fragment);
        return uniqueFragmentPath;
    }

    @Override
    protected void addInternalToClassSource() {
        Container nextContainer;
        String nextUri;
        String methodName = "addInternalToClassSource";
        if (this.rootClassSource == null) {
            return;
        }
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return;
        }
        for (WebFragmentInfo nextFragment : this.getOrderedItems()) {
            String nextPath;
            String nextPrefix;
            boolean nextIsMetadataComplete;
            ClassSource_Aggregate.ScanPolicy nextPolicy;
            nextUri = nextFragment.getLibraryURI();
            nextContainer = nextFragment.getFragmentContainer();
            if (nextFragment.isSeedFragment()) {
                nextPolicy = ClassSource_Aggregate.ScanPolicy.SEED;
                nextIsMetadataComplete = false;
            } else {
                nextPolicy = ClassSource_Aggregate.ScanPolicy.PARTIAL;
                nextIsMetadataComplete = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": URI [ " + nextUri + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Container [ " + nextContainer + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Metadata Complete [ " + nextIsMetadataComplete + " ]"), (Object[])new Object[0]);
            }
            if (nextUri.equals("WEB-INF/classes")) {
                nextContainer = nextContainer.getEnclosingContainer().getEnclosingContainer();
                nextPrefix = "WEB-INF/classes/";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Assigned Prefix [ " + nextPrefix + " ]"), (Object[])new Object[0]);
                }
            } else {
                nextPrefix = null;
            }
            if ((nextPath = this.getContainerPath(nextContainer)) == null) {
                return;
            }
            nextPath = this.putUniquePath(nextFragment, nextPath);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Path [ " + nextPath + " ]"), (Object[])new Object[0]);
            }
            if (this.addContainerClassSource(nextPath, nextContainer, nextPrefix, nextPolicy)) continue;
            return;
        }
        for (WebFragmentInfo nextFragment : this.getExcludedItems()) {
            String nextPath;
            nextUri = nextFragment.getLibraryURI();
            nextContainer = nextFragment.getFragmentContainer();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": URI [ " + nextUri + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Container [ " + nextContainer + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Excluded [ true ]"), (Object[])new Object[0]);
            }
            if ((nextPath = this.getContainerPath(nextContainer)) == null) {
                return;
            }
            nextPath = this.putUniquePath(nextFragment, nextPath);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Path [ " + nextPath + " ]"), (Object[])new Object[0]);
            }
            if (this.addContainerClassSource(nextPath, nextContainer, ClassSource_Aggregate.ScanPolicy.EXCLUDED)) continue;
            return;
        }
    }

    @Override
    public FragmentAnnotations getFragmentAnnotations(WebFragmentInfo fragment) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return null;
        }
        return new FragmentAnnotationsImpl(useTargets, this.getFragmentPath(fragment));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.WebAnnotationsImpl", WebAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    }
}

