/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax.events;

import com.ibm.xml.xlxp2.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class CharactersImpl
extends XMLEventImpl
implements Characters {
    private final String fData;
    private Boolean fIsWhiteSpace;

    public CharactersImpl(String string) {
        this(string, null);
    }

    public CharactersImpl(String string, Location location) {
        this(string, 4, location);
    }

    public CharactersImpl(String string, int n) {
        this(string, n, null);
    }

    public CharactersImpl(String string, int n, Location location) {
        super(n, location);
        this.fData = string;
    }

    public String getData() {
        return this.fData;
    }

    public boolean isWhiteSpace() {
        Boolean bl = this.fIsWhiteSpace;
        if (bl == null) {
            int n = this.fData != null ? this.fData.length() : 0;
            bl = n == 0 ? Boolean.FALSE : Boolean.TRUE;
            for (int i = n - 1; i >= 0; --i) {
                char c = this.fData.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
                bl = Boolean.FALSE;
                break;
            }
            this.fIsWhiteSpace = bl;
        }
        return bl == Boolean.TRUE;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            if (this.isCData()) {
                writer.write("<![CDATA[");
                writer.write(this.fData);
                writer.write("]]>");
            } else if (this.isIgnorableWhiteSpace()) {
                writer.write(CharactersImpl.escape(this.fData, 4));
            } else {
                writer.write(CharactersImpl.escape(this.fData, 4));
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }
}

