/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class UCSEncodingSupport
implements EncodingSupport {
    public static final int UTF_16 = 0;
    public static final int UTF_16BE = 1;
    public static final int UTF_16LE = 2;
    public static final int UTF_32BE = 3;
    public static final int UTF_32LE = 4;
    private static final int ENCODINGS_COUNT = 5;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = ArrayAllocator.newObjectArray(EncodingSupport.class, 5);
        } else if (fgSingletons[n] != null) {
            return fgSingletons[n];
        }
        switch (n) {
            case 0: {
                UCSEncodingSupport.fgSingletons[n] = new UTF16();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 1: {
                UCSEncodingSupport.fgSingletons[n] = new UTF16BE();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 2: {
                UCSEncodingSupport.fgSingletons[n] = new UTF16LE();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 3: {
                UCSEncodingSupport.fgSingletons[n] = new UTF32BE();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 4: {
                UCSEncodingSupport.fgSingletons[n] = new UTF32LE();
                return UCSEncodingSupport.fgSingletons[n];
            }
        }
        return null;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        return byteStreamDataSource.load(parsedEntity);
    }

    protected UCSEncodingSupport() {
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF32LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n8 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n9 = 0;
                if (byteStreamDataSource.stream != null && n8 < byteStreamDataSource.readLength) {
                    n7 = byteStreamDataSource.readLength - n8;
                    n6 = byteStreamDataSource.stream.read(byArray2, n8, n7);
                    if (n6 == -1) {
                        byteStreamDataSource.stream.close();
                        byteStreamDataSource.stream = null;
                        if (n8 == 0) {
                            byteStreamDataSource.readOffset = n8;
                            dataBuffer.endOffset = n2;
                            return null;
                        }
                    } else {
                        n5 = n7 >> byteStreamDataSource.bufferLoadFactor;
                        while (n6 < n5) {
                            n4 = n8 + n6;
                            n3 = byteStreamDataSource.stream.read(byArray2, n4, n7 - n6);
                            if (n3 == -1) {
                                byteStreamDataSource.stream.close();
                                byteStreamDataSource.stream = null;
                                break;
                            }
                            n6 += n3;
                        }
                        n9 = n6;
                    }
                }
                n9 += n8;
                n8 = 0;
                while (n8 + 3 < n9 && n2 < n) {
                    n7 = byArray2[n8++] & 0xFF;
                    n6 = byArray2[n8++] & 0xFF;
                    n5 = byArray2[n8++] & 0xFF;
                    if ((n4 = byArray2[n8++] & 0xFF) == 0 && n5 == 0) {
                        if (n6 == 0 && n7 < 128) {
                            if (n7 != 13) {
                                byArray[n2++] = (byte)n7;
                                continue;
                            }
                            if (n8 + 3 < n9) {
                                byArray[n2++] = 10;
                                n7 = byArray2[n8++] & 0xFF;
                                n6 = byArray2[n8++] & 0xFF;
                                n5 = byArray2[n8++] & 0xFF;
                                if ((n4 = byArray2[n8++] & 0xFF) == 0 && n5 == 0 && n6 == 0 && (n7 == 10 || !bl && n7 == 133)) continue;
                                n8 -= 4;
                                continue;
                            }
                            if (byteStreamDataSource.stream == null) {
                                byArray[n2++] = 10;
                                break;
                            }
                            n8 -= 4;
                            break;
                        }
                        n3 = (n6 << 8) + n7;
                        if (!(bl || n3 != 133 && n3 != 8232)) {
                            byArray[n2++] = 10;
                            continue;
                        }
                        if (n3 < 2048) {
                            if (n2 + 1 < n) {
                                byArray[n2++] = (byte)(0xC0 | n3 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                                continue;
                            }
                            n8 -= 4;
                            break;
                        }
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n3 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                            continue;
                        }
                        n8 -= 4;
                        break;
                    }
                    if (n2 + 3 < n) {
                        n3 = (n4 << 24) + (n5 << 16) + (n6 << 8) + n7;
                        byArray[n2++] = (byte)(0xF0 | n3 >> 18);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                        continue;
                    }
                    n8 -= 4;
                    break;
                }
                if (n8 < n9) {
                    if ((n9 -= n8) < 4 && byteStreamDataSource.stream == null) {
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    System.arraycopy(byArray2, n8, byArray2, 0, n9);
                    n8 = n9;
                } else {
                    n8 = 0;
                }
                byteStreamDataSource.readOffset = n8;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF32BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n8 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n9 = 0;
                if (byteStreamDataSource.stream != null && n8 < byteStreamDataSource.readLength) {
                    n7 = byteStreamDataSource.readLength - n8;
                    n6 = byteStreamDataSource.stream.read(byArray2, n8, n7);
                    if (n6 == -1) {
                        byteStreamDataSource.stream.close();
                        byteStreamDataSource.stream = null;
                        if (n8 == 0) {
                            byteStreamDataSource.readOffset = n8;
                            dataBuffer.endOffset = n2;
                            return null;
                        }
                    } else {
                        n5 = n7 >> byteStreamDataSource.bufferLoadFactor;
                        while (n6 < n5) {
                            n4 = n8 + n6;
                            n3 = byteStreamDataSource.stream.read(byArray2, n4, n7 - n6);
                            if (n3 == -1) {
                                byteStreamDataSource.stream.close();
                                byteStreamDataSource.stream = null;
                                break;
                            }
                            n6 += n3;
                        }
                        n9 = n6;
                    }
                }
                n9 += n8;
                n8 = 0;
                while (n8 + 3 < n9 && n2 < n) {
                    n7 = byArray2[n8++] & 0xFF;
                    n6 = byArray2[n8++] & 0xFF;
                    n5 = byArray2[n8++] & 0xFF;
                    n4 = byArray2[n8++] & 0xFF;
                    if (n7 == 0 && n6 == 0) {
                        if (n5 == 0 && n4 < 128) {
                            if (n4 != 13) {
                                byArray[n2++] = (byte)n4;
                                continue;
                            }
                            if (n8 + 3 < n9) {
                                byArray[n2++] = 10;
                                n7 = byArray2[n8++] & 0xFF;
                                n6 = byArray2[n8++] & 0xFF;
                                n5 = byArray2[n8++] & 0xFF;
                                n4 = byArray2[n8++] & 0xFF;
                                if (n7 == 0 && n6 == 0 && n5 == 0 && (n4 == 10 || !bl && n4 == 133)) continue;
                                n8 -= 4;
                                continue;
                            }
                            if (byteStreamDataSource.stream == null) {
                                byArray[n2++] = 10;
                                break;
                            }
                            n8 -= 4;
                            break;
                        }
                        n3 = (n5 << 8) + n4;
                        if (!(bl || n3 != 133 && n3 != 8232)) {
                            byArray[n2++] = 10;
                            continue;
                        }
                        if (n3 < 2048) {
                            if (n2 + 1 < n) {
                                byArray[n2++] = (byte)(0xC0 | n3 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                                continue;
                            }
                            n8 -= 4;
                            break;
                        }
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n3 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                            continue;
                        }
                        n8 -= 4;
                        break;
                    }
                    if (n2 + 3 < n) {
                        n3 = (n7 << 24) + (n6 << 16) + (n5 << 8) + n4;
                        byArray[n2++] = (byte)(0xF0 | n3 >> 18);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                        continue;
                    }
                    n8 -= 4;
                    break;
                }
                if (n8 < n9) {
                    if ((n9 -= n8) < 4 && byteStreamDataSource.stream == null) {
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    System.arraycopy(byArray2, n8, byArray2, 0, n9);
                    n8 = n9;
                } else {
                    n8 = 0;
                }
                byteStreamDataSource.readOffset = n8;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                int n3;
                int n4;
                int n5;
                int n6;
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n7 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n8 = 0;
                if (byteStreamDataSource.stream != null && n7 < byteStreamDataSource.readLength) {
                    n6 = byteStreamDataSource.readLength - n7;
                    n5 = byteStreamDataSource.stream.read(byArray2, n7, n6);
                    if (n5 == -1) {
                        byteStreamDataSource.stream.close();
                        byteStreamDataSource.stream = null;
                        if (n7 == 0) {
                            byteStreamDataSource.readOffset = n7;
                            dataBuffer.endOffset = n2;
                            return null;
                        }
                    } else {
                        n4 = n6 >> byteStreamDataSource.bufferLoadFactor;
                        while (n5 < n4) {
                            n3 = n7 + n5;
                            int n9 = byteStreamDataSource.stream.read(byArray2, n3, n6 - n5);
                            if (n9 == -1) {
                                byteStreamDataSource.stream.close();
                                byteStreamDataSource.stream = null;
                                break;
                            }
                            n5 += n9;
                        }
                        n8 = n5;
                    }
                }
                n8 += n7;
                n7 = 0;
                while (n7 + 1 < n8 && n2 < n) {
                    n6 = byArray2[n7++] & 0xFF;
                    if ((n5 = byArray2[n7++] & 0xFF) == 0 && n6 < 128) {
                        if (n6 != 13) {
                            byArray[n2++] = (byte)n6;
                            continue;
                        }
                        if (n7 + 1 < n8) {
                            byArray[n2++] = 10;
                            n6 = byArray2[n7++] & 0xFF;
                            if ((n5 = byArray2[n7++] & 0xFF) == 0 && (n6 == 10 || !bl && n6 == 133)) continue;
                            n7 -= 2;
                            continue;
                        }
                        if (byteStreamDataSource.stream == null) {
                            byArray[n2++] = 10;
                            break;
                        }
                        n7 -= 2;
                        break;
                    }
                    n4 = (n5 << 8) + n6;
                    if (!(bl || n4 != 133 && n4 != 8232)) {
                        byArray[n2++] = 10;
                        continue;
                    }
                    if (n4 < 2048) {
                        if (n2 + 1 < n) {
                            byArray[n2++] = (byte)(0xC0 | n4 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                            continue;
                        }
                        n7 -= 2;
                        break;
                    }
                    if (n4 < 55296 || n4 >= 57344) {
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n4 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                            continue;
                        }
                        n7 -= 2;
                        break;
                    }
                    if (n4 < 56320) {
                        if (n7 < n8 && n2 + 3 < n) {
                            if ((n3 = ((n5 = byArray2[n7++] & 0xFF) << 8) + (n6 = byArray2[n7++] & 0xFF)) >= 56320 && n3 < 57344) {
                                n4 = 65536 + (n4 - 55296 << 10) + (n3 - 56320);
                                byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 12);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                                continue;
                            }
                            return CharConversionError.invalidSecondHalfOfSurrogatePair();
                        }
                        n7 -= 2;
                        break;
                    }
                    return CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
                if (n7 < n8) {
                    if ((n8 -= n7) < 2 && byteStreamDataSource.stream == null) {
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    System.arraycopy(byArray2, n7, byArray2, 0, n8);
                    n7 = n8;
                } else {
                    n7 = 0;
                }
                byteStreamDataSource.readOffset = n7;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                int n3;
                int n4;
                int n5;
                int n6;
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n7 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n8 = 0;
                if (byteStreamDataSource.stream != null && n7 < byteStreamDataSource.readLength) {
                    n6 = byteStreamDataSource.readLength - n7;
                    n5 = byteStreamDataSource.stream.read(byArray2, n7, n6);
                    if (n5 == -1) {
                        byteStreamDataSource.stream.close();
                        byteStreamDataSource.stream = null;
                        if (n7 == 0) {
                            byteStreamDataSource.readOffset = n7;
                            dataBuffer.endOffset = n2;
                            return null;
                        }
                    } else {
                        n4 = n6 >> byteStreamDataSource.bufferLoadFactor;
                        while (n5 < n4) {
                            n3 = n7 + n5;
                            int n9 = byteStreamDataSource.stream.read(byArray2, n3, n6 - n5);
                            if (n9 == -1) {
                                byteStreamDataSource.stream.close();
                                byteStreamDataSource.stream = null;
                                break;
                            }
                            n5 += n9;
                        }
                        n8 = n5;
                    }
                }
                n8 += n7;
                n7 = 0;
                while (n7 + 1 < n8 && n2 < n) {
                    n6 = byArray2[n7++] & 0xFF;
                    n5 = byArray2[n7++] & 0xFF;
                    if (n6 == 0 && n5 < 128) {
                        if (n5 != 13) {
                            byArray[n2++] = (byte)n5;
                            continue;
                        }
                        if (n7 + 1 < n8) {
                            byArray[n2++] = 10;
                            n6 = byArray2[n7++] & 0xFF;
                            n5 = byArray2[n7++] & 0xFF;
                            if (n6 == 0 && (n5 == 10 || !bl && n5 == 133)) continue;
                            n7 -= 2;
                            continue;
                        }
                        if (byteStreamDataSource.stream == null) {
                            byArray[n2++] = 10;
                            break;
                        }
                        n7 -= 2;
                        break;
                    }
                    n4 = (n6 << 8) + n5;
                    if (!(bl || n4 != 133 && n4 != 8232)) {
                        byArray[n2++] = 10;
                        continue;
                    }
                    if (n4 < 2048) {
                        if (n2 + 1 < n) {
                            byArray[n2++] = (byte)(0xC0 | n4 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                            continue;
                        }
                        n7 -= 2;
                        break;
                    }
                    if (n4 < 55296 || n4 >= 57344) {
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n4 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                            continue;
                        }
                        n7 -= 2;
                        break;
                    }
                    if (n4 < 56320) {
                        if (n7 < n8 && n2 + 3 < n) {
                            if ((n3 = ((n6 = byArray2[n7++] & 0xFF) << 8) + (n5 = byArray2[n7++] & 0xFF)) >= 56320 && n3 < 57344) {
                                n4 = 65536 + (n4 - 55296 << 10) + (n3 - 56320);
                                byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 12);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                                continue;
                            }
                            byteStreamDataSource.readOffset = n7 - 2;
                            return CharConversionError.invalidSecondHalfOfSurrogatePair();
                        }
                        n7 -= 2;
                        break;
                    }
                    byteStreamDataSource.readOffset = n7 - 2;
                    return CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
                if (n7 < n8) {
                    if ((n8 -= n7) < 2 && byteStreamDataSource.stream == null) {
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    System.arraycopy(byArray2, n7, byArray2, 0, n8);
                    n7 = n8;
                } else {
                    n7 = 0;
                }
                byteStreamDataSource.readOffset = n7;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            return CharConversionError.inconsistentEncoding();
        }
    }
}

