/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XByte;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ByteDV
extends TypeValidator {
    private final int totalDigits;
    private final byte[] enumeration;
    private final byte maxInclusive;
    private final byte maxExclusive;
    private final byte minInclusive;
    private final byte minExclusive;

    public ByteDV(String string, String string2, String string3, String[] stringArray, byte[] byArray, byte by, byte by2, byte by3, byte by4, int n, int n2) {
        super(string, string2, string3, 36, 4, stringArray, ByteDV.computeDefinedFacets(n2, by, by2, by3, by4), false);
        this.totalDigits = n;
        this.enumeration = byArray;
        this.maxInclusive = by3;
        this.maxExclusive = by4;
        this.minInclusive = by;
        this.minExclusive = by2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XByte xByte = new XByte(ByteDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xByte;
            validatedInfo.errorCode = 0;
        }
        return xByte;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        byte by = XSIntegerUtil.parseByte(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = by == ((XByte)validatedInfo.actualValue).value ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(by, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXByte(by);
    }

    public int preCheckFacets(byte by, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(by, xMLString);
        }
        return 0;
    }

    private int checkFacets(byte by, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && this.getTotalDigits(by) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && by < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && by <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && by > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && by >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != by) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n, byte by, byte by2, byte by3, byte by4) {
        if ((n & 0x100) != 0 && by <= -128) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x20) != 0 && by3 >= 127) {
            n &= 0xFFFFFFDF;
        }
        if ((n & 0x80) != 0 && by2 < -128) {
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x40) != 0 && by4 > 127) {
            n &= 0xFFFFFFBF;
        }
        return n;
    }

    private int getTotalDigits(byte by) {
        if (by >= 0) {
            return by < 10 ? 1 : (by < 100 ? 2 : 3);
        }
        return by > -10 ? 1 : (by > -100 ? 2 : 3);
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        int n2;
        if ((n & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n3 = n2 = stringArray != null ? stringArray.length : 0;
        if (n2 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static byte parse(XMLString xMLString) {
        return XSIntegerUtil.parseByte(xMLString, dummyOneElementArray);
    }
}

