/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.utility.internal.cmdline.DownloadAction;
import com.ibm.ws.install.utility.internal.cmdline.FindAction;
import com.ibm.ws.install.utility.internal.cmdline.HelpAction;
import com.ibm.ws.install.utility.internal.cmdline.InstallAction;
import com.ibm.ws.install.utility.internal.cmdline.TestConnectionAction;
import com.ibm.ws.install.utility.internal.cmdline.UninstallAction;
import com.ibm.ws.install.utility.internal.cmdline.ViewSettingsAction;
import com.ibm.ws.kernel.boot.cmdline.ActionDefinition;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.internal.cmdline.FeatureToolException;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public enum Action implements ActionDefinition
{
    download(new DownloadAction(), -1, "--overwrite", "--location", "--acceptLicense", "--viewLicenseAgreement", "--viewLicenseInfo", "--verbose", "name..."),
    find(new FindAction(), -1, "--showDescriptions", "--type", "--name", "--from", "--verbose", "[searchString]"),
    install(new InstallAction(), -1, "--to", "--acceptLicense", "--viewLicenseAgreement", "--viewLicenseInfo", "--from", "--downloadDependencies", "--verbose", "name..."),
    testConnection(new TestConnectionAction(), -1, "[repoName]"),
    uninstall(new UninstallAction(), -1, "--noPrompts", "--force", "--verbose", "name..."),
    viewSettings(new ViewSettingsAction(), 0, "--viewValidationMessages"),
    help(new HelpAction(), 0, new String[0]);

    private List<String> commandOptions;
    private ActionHandler action;
    private int positionalOptions;

    private Action(ActionHandler a, int count, String ... args) {
        this.commandOptions = Collections.unmodifiableList(Arrays.asList(args));
        this.action = a;
        this.positionalOptions = count;
    }

    public List<String> getCommandOptions() {
        return this.commandOptions;
    }

    public int numPositionalArgs() {
        return this.positionalOptions;
    }

    public ExitCode handleTask(Arguments args) {
        try {
            InstallKernel installKernel = InstallKernelFactory.getInstance();
            String verboseLevel = args.getOption("verbose");
            Level logLevel = Level.INFO;
            if (verboseLevel != null && verboseLevel.isEmpty()) {
                logLevel = Level.FINE;
            } else if (verboseLevel != null && verboseLevel.equalsIgnoreCase("debug")) {
                logLevel = Level.FINEST;
            }
            ((InstallKernelImpl)installKernel).enableConsoleLog(logLevel);
            return this.action.handleTask(System.out, System.err, args);
        }
        catch (FeatureToolException fte) {
            System.err.println(fte.getMessage());
            fte.printStackTrace();
            return fte.getReturnCode();
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return ReturnCode.RUNTIME_EXCEPTION;
        }
    }

    public boolean showOptions() {
        List<String> options = this.getCommandOptions();
        for (String option : options) {
            if (!option.startsWith("-")) continue;
            return true;
        }
        return false;
    }
}

