/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.AlignmentBoundary;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StringHolder;
import org.omg.GIOP.IORAddressingInfoHelper;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.LocateStatusType_1_2Holder;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.TargetAddressHolder;
import org.omg.GIOP.Version;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedProfileHelper;

public final class GIOPIncomingMessage {
    private ORBInstance orbInstance_;
    private InputStream in_;
    private static int maxMessageSize_;
    private Version version_ = new Version();
    private boolean littleEndian;
    private boolean fragmentToFollow;
    private MsgType_1_1 type_;
    private int size_;
    private ConcurrentMap<Integer, Fragment> fragmentMap;
    private Fragment lastFragment_;

    private void skipServiceContextList(InputStream in) {
        int len = in.read_ulong();
        for (int i = 0; i < len; ++i) {
            in.skipAlign(AlignmentBoundary.FOUR_BYTE_BOUNDARY);
            in._OB_skip(4);
            int datalen = in.read_ulong();
            in._OB_skip(datalen);
        }
    }

    private void readServiceContextList(ServiceContexts contexts) {
        for (int len = this.in_.read_ulong(); len > 0; --len) {
            contexts.mutable().add(this.readServiceContext());
        }
    }

    private ServiceContext readServiceContext() {
        ServiceContext sc = new ServiceContext();
        sc.context_id = this.in_.read_ulong();
        int datalen = this.in_.read_ulong();
        sc.context_data = new byte[datalen];
        this.in_.read_octet_array(sc.context_data, 0, datalen);
        return sc;
    }

    private void readTargetAddress(TargetAddressHolder target) {
        target.value = new TargetAddress();
        short discriminator = this.in_.read_short();
        switch (discriminator) {
            case 0: {
                int len = this.in_.read_ulong();
                byte[] seq = new byte[len];
                this.in_.read_octet_array(seq, 0, len);
                target.value.object_key(seq);
                break;
            }
            case 1: {
                target.value.profile(TaggedProfileHelper.read((org.omg.CORBA.portable.InputStream)this.in_));
                break;
            }
            case 2: {
                target.value.ior(IORAddressingInfoHelper.read((org.omg.CORBA.portable.InputStream)this.in_));
                break;
            }
            default: {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974929) + ": invalid target address", 1095974929, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    GIOPIncomingMessage(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
        this.fragmentMap = new ConcurrentHashMap<Integer, Fragment>();
        this.lastFragment_ = null;
    }

    Version version() {
        return this.version_;
    }

    boolean swap() {
        return this.littleEndian;
    }

    MsgType_1_1 type() {
        return this.type_;
    }

    int size() {
        return this.size_;
    }

    InputStream input() {
        InputStream result = this.in_;
        this.in_ = null;
        return result;
    }

    void extractHeader(ReadBuffer br) {
        InputStream in = new InputStream(br, false);
        this.in_ = null;
        if (71 != in.read_octet() || 73 != in.read_octet() || 79 != in.read_octet() || 80 != in.read_octet()) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974929) + ": missing GIOP magic key", 1095974929, CompletionStatus.COMPLETED_MAYBE);
        }
        this.version_.major = in.read_octet();
        this.version_.minor = in.read_octet();
        if (this.version_.major != 1 || this.version_.minor > 2) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974937), 1095974937, CompletionStatus.COMPLETED_MAYBE);
        }
        switch (this.version_.minor) {
            case 0: {
                this.littleEndian = in.read_boolean();
                in._OB_swap(this.littleEndian);
                this.fragmentToFollow = false;
                byte msgType = in.read_octet();
                this.type_ = MsgType_1_1.from_int((int)msgType);
                this.size_ = in.read_ulong();
                if (this.type_.value() <= 6) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930) + ": invalid message type for GIOP 1.0", 1095974930, CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: 
            case 2: {
                byte flags = in.read_octet();
                this.littleEndian = (flags & 1) == 1;
                this.fragmentToFollow = (flags & 2) == 2;
                in._OB_swap(this.littleEndian);
                this.type_ = MsgType_1_1.from_int((int)in.read_octet());
                this.size_ = in.read_ulong();
                if (this.type_.value() <= 7) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930) + ": invalid message type for GIOP 1.1/1.2", 1095974930, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                throw Assert.fail();
            }
        }
        if (maxMessageSize_ > 0 && this.size_ > maxMessageSize_) {
            String msg = "incoming message size (" + this.size_ + ") exceeds maximum (" + maxMessageSize_ + ")";
            this.orbInstance_.getLogger().warning(msg);
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1095974913), 1095974913, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.version_.minor == 2 && this.fragmentToFollow && (this.size_ + 12) % 8 != 0) {
            throw new COMM_FAILURE(String.format("%s: invalid GIOP 1.2 fragment size %d", MinorCodes.describeCommFailure(1095974934), this.size_), 1095974934, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    boolean consumeBuffer(WriteBuffer writer) {
        if (this.fragmentToFollow && this.type_ != MsgType_1_1.Fragment) {
            this.startNewFragmentedMessage(writer);
            return false;
        }
        if (this.type_ == MsgType_1_1.Fragment) {
            return this.consumeFragment(writer.readFromStart());
        }
        if (this.type_ == MsgType_1_1.CancelRequest) {
            this.processCancelRequest(writer.readFromStart());
            return true;
        }
        this.readEntireMessage(writer.readFromStart());
        return true;
    }

    private boolean consumeFragment(ReadBuffer reader) {
        Fragment complete;
        if (this.version_.minor < 1) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974934), 1095974934, CompletionStatus.COMPLETED_MAYBE);
        }
        Fragment fragment = complete = this.version_.minor == 1 ? this.handleFollowingFragmentGiop11(reader) : this.handleFollowingFragmentGiop12(reader);
        if (complete == null) {
            return false;
        }
        this.version_ = complete.version;
        this.littleEndian = complete.littleEndian;
        this.type_ = complete.type;
        this.fragmentToFollow = false;
        this.size_ = complete.writeBuffer.length() - 12;
        this.readEntireMessage(complete.writeBuffer.readFromStart());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fragment handleFollowingFragmentGiop11(ReadBuffer reader) {
        if (this.lastFragment_ == null) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974934), 1095974934, CompletionStatus.COMPLETED_MAYBE);
        }
        Assert.ensure(reader.getPosition() == 12);
        this.lastFragment_.addFragment(this.orbInstance_, reader);
        if (this.lastFragment_.reqId == null) {
            InputStream reqIn = new InputStream(this.lastFragment_.writeBuffer.readFromStart(), 12, this.swap());
            try {
                this.skipServiceContextList(reqIn);
                this.lastFragment_.reqId = reqIn.read_ulong();
            }
            catch (MARSHAL mARSHAL) {
                // empty catch block
            }
        }
        if (this.fragmentToFollow) {
            return null;
        }
        try {
            Fragment fragment = this.lastFragment_;
            return fragment;
        }
        finally {
            this.lastFragment_ = null;
        }
    }

    private Fragment handleFollowingFragmentGiop12(ReadBuffer reader) {
        InputStream in = new InputStream(reader, 12, this.swap());
        int reqId = in.read_ulong();
        Fragment frag = (Fragment)this.fragmentMap.get(reqId);
        if (frag == null) {
            return null;
        }
        Assert.ensure(reader.getPosition() == 16);
        frag.addFragment(this.orbInstance_, reader);
        if (this.fragmentToFollow) {
            return null;
        }
        this.fragmentMap.remove(reqId, frag);
        return frag;
    }

    private void processCancelRequest(ReadBuffer reader) {
        this.readEntireMessage(reader);
        int reqId = this.readCancelRequestHeader();
        if (this.version_.minor == 1) {
            if (this.lastFragment_ != null && this.lastFragment_.reqId == reqId) {
                this.lastFragment_ = null;
            }
        } else {
            this.fragmentMap.remove(reqId);
        }
        this.in_._OB_reset();
    }

    private void readEntireMessage(ReadBuffer reader) {
        this.in_ = new InputStream(reader, 12, this.swap());
    }

    private void startNewFragmentedMessage(WriteBuffer writer) {
        if (this.version_.minor < 1) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974934), 1095974934, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.version_.minor == 1) {
            this.startNewGiop11FragmentedMessage(writer);
        } else {
            this.startNewGiop12FragmentedMessage(writer);
        }
    }

    private void startNewGiop11FragmentedMessage(WriteBuffer writer) {
        if (this.type_ != MsgType_1_1.Request && this.type_ != MsgType_1_1.Reply) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974934), 1095974934, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.lastFragment_ != null) {
            this.lastFragment_ = null;
        }
        Integer reqId = null;
        try {
            InputStream in = new InputStream(writer.readFromStart(), 12, this.swap());
            this.skipServiceContextList(in);
            reqId = in.read_ulong();
        }
        catch (MARSHAL mARSHAL) {
            // empty catch block
        }
        this.lastFragment_ = new Fragment(this.version_.major, this.version_.minor, this.littleEndian, reqId, this.type_, writer);
    }

    private void startNewGiop12FragmentedMessage(WriteBuffer writer) {
        int reqId;
        if (this.type_ != MsgType_1_1.Request && this.type_ != MsgType_1_1.Reply && this.type_ != MsgType_1_1.LocateRequest && this.type_ != MsgType_1_1.LocateReply) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974934), 1095974934, CompletionStatus.COMPLETED_MAYBE);
        }
        boolean haveReqId = false;
        try {
            InputStream in = new InputStream(writer.readFromStart(), 12, this.swap());
            reqId = in.read_ulong();
        }
        catch (MARSHAL ex) {
            throw Assert.fail("Should have had 16 bytes in fragment", ex);
        }
        Fragment frag = new Fragment(this.version_.major, this.version_.minor, this.littleEndian, reqId, this.type_, writer);
        this.fragmentMap.put(reqId, frag);
    }

    int readRequestHeader(BooleanHolder response, TargetAddressHolder target, StringHolder op, ServiceContexts contexts) {
        Assert.ensure(this.type_ == MsgType_1_1.Request);
        int id = 0;
        switch (this.version_.minor) {
            case 0: {
                this.readServiceContextList(contexts);
                id = this.in_.read_ulong();
                response.value = this.in_.read_boolean();
                int len = this.in_.read_ulong();
                byte[] key = new byte[len];
                this.in_.read_octet_array(key, 0, len);
                target.value = new TargetAddress();
                target.value.object_key(key);
                len = this.in_.read_ulong();
                byte[] s = new byte[len];
                this.in_.read_octet_array(s, 0, len);
                op.value = new String(s, 0, len - 1);
                len = this.in_.read_ulong();
                if (len <= 0) break;
                this.in_._OB_skip(len);
                break;
            }
            case 1: {
                this.readServiceContextList(contexts);
                id = this.in_.read_ulong();
                response.value = this.in_.read_boolean();
                this.in_._OB_skip(3);
                int len = this.in_.read_ulong();
                byte[] key = new byte[len];
                this.in_.read_octet_array(key, 0, len);
                target.value = new TargetAddress();
                target.value.object_key(key);
                len = this.in_.read_ulong();
                byte[] s = new byte[len];
                this.in_.read_octet_array(s, 0, len);
                op.value = new String(s, 0, len - 1);
                len = this.in_.read_ulong();
                if (len <= 0) break;
                this.in_._OB_skip(len);
                break;
            }
            case 2: {
                id = this.in_.read_ulong();
                byte flags = this.in_.read_octet();
                response.value = (flags & 1) == 1;
                this.in_._OB_skip(3);
                this.readTargetAddress(target);
                int len = this.in_.read_ulong();
                byte[] s = new byte[len];
                this.in_.read_octet_array(s, 0, len);
                op.value = new String(s, 0, len - 1);
                this.readServiceContextList(contexts);
                if (this.in_.getPosition() >= this.size_ + 12) break;
                this.in_.skipAlign(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
                break;
            }
            default: {
                throw Assert.fail();
            }
        }
        return id;
    }

    int readReplyHeader(ReplyStatusType_1_2Holder status, ServiceContexts contexts) {
        Assert.ensure(this.type_ == MsgType_1_1.Reply);
        int id = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                this.readServiceContextList(contexts);
                id = this.in_.read_ulong();
                status.value = ReplyStatusType_1_2.from_int((int)this.in_.read_ulong());
                if (status.value.value() <= 3) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930) + ": invalid reply status", 1095974930, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                id = this.in_.read_ulong();
                status.value = ReplyStatusType_1_2.from_int((int)this.in_.read_ulong());
                if (status.value.value() > 5) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930) + ": invalid reply status", 1095974930, CompletionStatus.COMPLETED_MAYBE);
                }
                this.readServiceContextList(contexts);
                if (this.in_.getPosition() >= this.size_ + 12) break;
                this.in_.skipAlign(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
                break;
            }
            default: {
                throw Assert.fail();
            }
        }
        return id;
    }

    int readCancelRequestHeader() {
        Assert.ensure(this.type_ == MsgType_1_1.CancelRequest);
        int id = this.in_.read_ulong();
        return id;
    }

    int readLocateRequestHeader(TargetAddressHolder target) {
        Assert.ensure(this.type_ == MsgType_1_1.LocateRequest);
        int id = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                id = this.in_.read_ulong();
                int keylen = this.in_.read_ulong();
                byte[] key = new byte[keylen];
                this.in_.read_octet_array(key, 0, keylen);
                target.value = new TargetAddress();
                target.value.object_key(key);
                break;
            }
            case 2: {
                id = this.in_.read_ulong();
                this.readTargetAddress(target);
                break;
            }
            default: {
                throw Assert.fail();
            }
        }
        return id;
    }

    int readLocateReplyHeader(LocateStatusType_1_2Holder status) {
        Assert.ensure(this.type_ == MsgType_1_1.LocateReply);
        int id = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                id = this.in_.read_ulong();
                status.value = LocateStatusType_1_2.from_int((int)this.in_.read_ulong());
                if (status.value.value() <= 2) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930) + ": invalid locate reply status", 1095974930, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                id = this.in_.read_ulong();
                status.value = LocateStatusType_1_2.from_int((int)this.in_.read_ulong());
                if (status.value.value() <= 5) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974930) + ": invalid locate reply status", 1095974930, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                throw Assert.fail();
            }
        }
        return id;
    }

    public static void setMaxMessageSize(int max) {
        maxMessageSize_ = max;
    }

    private class Fragment {
        private final Version version;
        private final boolean littleEndian;
        private Integer reqId;
        private final MsgType_1_1 type;
        private final WriteBuffer writeBuffer;

        public Fragment(byte major, byte minor, boolean littleEndian, Integer reqId, MsgType_1_1 type, WriteBuffer writeBuffer) {
            this.version = new Version(major, minor);
            this.littleEndian = littleEndian;
            this.reqId = reqId;
            this.type = type;
            this.writeBuffer = writeBuffer;
        }

        void addFragment(ORBInstance orbInstance, ReadBuffer readBuffer) {
            if (maxMessageSize_ > 0 && this.writeBuffer.length() + readBuffer.available() > maxMessageSize_) {
                String msg = "incoming fragment exceeds maximum message size (" + maxMessageSize_ + ")";
                GIOPIncomingMessage.this.orbInstance_.getLogger().warning(msg);
                throw new IMP_LIMIT(MinorCodes.describeImpLimit(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
            }
            this.writeBuffer.ensureAvailable(readBuffer.available());
            readBuffer.readBytes(this.writeBuffer);
        }
    }
}

