/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.List;

public final class ParseParams {
    public static int parse(String str, int start, List<String> params) {
        int pos = start;
        int strLen = str.length();
        boolean error = false;
        int result = -1;
        while (pos < strLen && result == -1 && !error) {
            char ch = str.charAt(pos);
            while (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
                ch = str.charAt(++pos);
            }
            int startPos = pos;
            int endPos = 0;
            char quote = '\u0000';
            boolean done = false;
            block8: while (!done && !error) {
                if (pos == strLen) {
                    endPos = pos;
                    done = true;
                    continue;
                }
                ch = str.charAt(pos);
                switch (ch) {
                    case ',': {
                        if (quote == '\u0000') {
                            endPos = pos;
                            result = pos + 1;
                            done = true;
                            continue block8;
                        }
                        ++pos;
                        continue block8;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (quote == '\u0000') {
                            endPos = pos;
                            done = true;
                            continue block8;
                        }
                        ++pos;
                        continue block8;
                    }
                    case '\\': {
                        if (++pos == strLen) {
                            error = true;
                            continue block8;
                        }
                        ++pos;
                        continue block8;
                    }
                    case '\"': 
                    case '\'': {
                        if (quote == '\u0000') {
                            if (pos > startPos) {
                                done = true;
                                endPos = pos;
                                continue block8;
                            }
                            quote = ch;
                            ++pos;
                            continue block8;
                        }
                        if (quote == ch) {
                            quote = '\u0000';
                            done = true;
                            endPos = pos++;
                            continue block8;
                        }
                        error = true;
                        continue block8;
                    }
                }
                ++pos;
            }
            if (quote != '\u0000') {
                error = true;
            }
            if (error || pos <= startPos) continue;
            ch = str.charAt(startPos);
            if (ch == '\'' || ch == '\"') {
                ++startPos;
            }
            int len = endPos - startPos;
            StringBuffer buf = new StringBuffer(len);
            for (int s = startPos; s < endPos; ++s) {
                ch = str.charAt(s);
                if (ch == '\\') continue;
                buf.append(ch);
            }
            params.add(buf.toString());
        }
        return result;
    }
}

