/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ESIInvalidatorServlet;
import com.ibm.websphere.servlet.cache.ExternalCacheAdapter;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.servlet.Afpa;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.servlet.http.HttpServletResponse;

public class ExternalCacheGroup
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Tr.register(ExternalCacheGroup.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final int SHARED = 0;
    public static final int NOT_SHARED = 1;
    private String id = null;
    private int type = 0;
    private Hashtable addressToBeanName = new Hashtable();
    private Hashtable addressToBean = new Hashtable();
    private ExternalCacheAdapter[] adapters = new ExternalCacheAdapter[0];

    public ExternalCacheGroup(String id, int type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public void addExternalCacheAdapter(String address, String beanName) {
        Object temp;
        ExternalCacheAdapter externalCacheAdapter = null;
        try {
            externalCacheAdapter = ExternalCacheGroup.initializeAdapter(address, beanName.trim());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.ExternalCacheGroup.addExternalCacheAdapter", (String)"92", (Object)this);
            Tr.error((TraceComponent)tc, (String)"dynacache.externaladaptererror", (Object[])new Object[]{ex.getMessage()});
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding externalCache: " + this.id + " " + address + " " + beanName), (Object[])new Object[0]);
        }
        if ((temp = this.addressToBeanName.get(address)) != null) {
            Tr.error((TraceComponent)tc, (String)"dynacache.externaldup", (Object[])new Object[]{address});
        }
        this.addressToBeanName.put(address, beanName);
        this.addressToBean.put(address, externalCacheAdapter);
        this.adapters = this.addressToBean.values().toArray(new ExternalCacheAdapter[0]);
    }

    public void removeExternalCacheAdapter(String address) {
        this.addressToBean.remove(address);
        this.addressToBeanName.remove(address);
        this.adapters = this.addressToBean.values().toArray(new ExternalCacheAdapter[0]);
    }

    public void invalidatePages(ValueSet urlValueSet) {
        String methodName = "invalidatePages()";
        for (int i = 0; i < this.adapters.length; ++i) {
            try {
                this.adapters[i].invalidatePages(urlValueSet.iterator());
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.invalidatePages", (String)"120", null);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("invalidatePages() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
            }
        }
    }

    public void invalidateIds(HashMap ids) {
        String methodName = "invalidateIds()";
        for (int i = 0; i < this.adapters.length; ++i) {
            try {
                this.adapters[i].invalidateIds(ids.keySet().iterator());
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.invalidateIds", (String)"141", null);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("invalidateIds() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
            }
        }
    }

    public void clear(InvalidateByTemplateEvent ie) {
        String methodName = "clear()";
        for (int i = 0; i < this.adapters.length; ++i) {
            try {
                this.adapters[i].clear();
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.clear", (String)"162", null);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("clear() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
            }
        }
    }

    public void invalidateIds(HashSet ids) {
        String methodName = "invalidateIds()";
        for (ValueSet v : ids) {
            if (v == null || v.size() <= 0) continue;
            for (int i = 0; i < this.adapters.length; ++i) {
                try {
                    this.adapters[i].invalidateIds(v.iterator());
                    continue;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.invalidateIds", (String)"188", null);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("invalidateIds() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
                }
            }
        }
    }

    public void writePages(ArrayList contentVector) {
        String methodName = "writePages()";
        for (int i = 0; i < this.adapters.length; ++i) {
            try {
                this.adapters[i].writePages(contentVector.iterator());
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.writePages", (String)"210", null);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("writePages() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
            }
        }
    }

    private static ExternalCacheAdapter initializeAdapter(String address, String adapterBeanName) throws IOException, ClassNotFoundException {
        String methodName = "initializeAdapter()";
        try {
            ExternalCacheAdapter externalCacheAdapter = null;
            if (adapterBeanName.equals("com.ibm.websphere.servlet.cache.ESIInvalidatorServlet")) {
                externalCacheAdapter = new ESIInvalidatorServlet();
            } else if (adapterBeanName.equals("com.ibm.ws.cache.servlet.Afpa")) {
                externalCacheAdapter = new Afpa();
            } else {
                Class<?> extClass = ExternalCacheGroup.class.getClassLoader().loadClass(adapterBeanName);
                externalCacheAdapter = (ExternalCacheAdapter)extClass.newInstance();
            }
            externalCacheAdapter.setAddress(address);
            return externalCacheAdapter;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.initializeAdapter", (String)"233", null);
            throw new ClassNotFoundException(adapterBeanName);
        }
    }

    public void preInvoke(ServletCacheRequest req, HttpServletResponse resp) {
        String methodName = "preInvoke()";
        for (int i = 0; i < this.adapters.length; ++i) {
            try {
                this.adapters[i].preInvoke(req, resp);
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.preInvoke", (String)"244", null);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("preInvoke() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
            }
        }
    }

    public void postInvoke(ServletCacheRequest req, HttpServletResponse resp) {
        String methodName = "postInvoke()";
        for (int i = 0; i < this.adapters.length; ++i) {
            try {
                this.adapters[i].postInvoke(req, resp);
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ExternalCacheGroup.postInvoke", (String)"257", null);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("postInvoke() " + this.adapters[i] + " Exception: " + ExceptionUtility.getStackTrace((Throwable)ex)), (Object[])new Object[0]);
            }
        }
    }
}

