/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.TransactionSynchronizationRegistryFactory;
import com.ibm.tx.jta.impl.DirectEnlistXAResourceInfo;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.HeuristicOutcome;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.JTAXAResourceImpl;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.PartnerLogData;
import com.ibm.tx.jta.impl.PartnerLogTable;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.RegisteredResources;
import com.ibm.tx.jta.impl.RegisteredSyncs;
import com.ibm.tx.jta.impl.TimeoutManager;
import com.ibm.tx.jta.impl.TransactionState;
import com.ibm.tx.jta.impl.TxExecutionContextHandler;
import com.ibm.tx.jta.impl.TxPrimaryKey;
import com.ibm.tx.jta.impl.XARecoveryData;
import com.ibm.tx.jta.impl.XidImpl;
import com.ibm.tx.util.TMHelper;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.TransactionScopeDestroyer;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.uow.UOWScopeLTCAware;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionImpl
implements Transaction,
ResourceCallback,
UOWScopeLTCAware,
UOWCoordinator {
    public static final String TRANSACTION_LOG_NAME = "tranlog";
    public static final String PARTNER_LOG_NAME = "partnerlog";
    public static final int TRAN_STATE_SECTION = 0;
    public static final int CORBA_RESOURCE_SECTION = 1;
    public static final int XARESOURCE_SECTION = 2;
    public static final int GLOBALID_SECTION = 3;
    public static final int RECOVERYCOORD_SECTION = 4;
    public static final int RESOURCE_WSC_SECTION = 5;
    public static final int RECCOORD_WSC_SECTION = 6;
    public static final int RESOURCE_ADAPTER_SECTION = 7;
    public static final int HEURISTIC_OUTCOME_SECTION = 8;
    public static final int RECCOORD_WSAT_SECTION = 9;
    public static final int WSAT_ASYNC_RESOURCE_SECTION = 10;
    public static final int NEXT_ID_SECTION = 30;
    public static final int LOW_WATERMARK_SECTION = 31;
    public static final int SERVER_STATE_SECTION = 32;
    public static final int CLASSPATH_SECTION = 33;
    public static final int XARESOURCEDATA_SECTION = 34;
    public static final int WSCOORDINATOR_SECTION = 35;
    public static final int JCAPROVIDER_SECTION = 36;
    public static final int RESOURCE_PRIORITY_SECTION = 37;
    public static final int APPLID_DATA_SECTION = 253;
    public static final int EPOCH_DATA_SECTION = 254;
    public static final int SERVER_DATA_SECTION = 255;
    protected TransactionState _status;
    protected int _timeout;
    protected boolean _subordinate;
    protected volatile boolean _rollbackOnly;
    private volatile Throwable _originalException;
    protected volatile boolean _timedOut;
    protected boolean _subRollback;
    protected RegisteredResources _resources;
    protected RetryAlarm _retryAlarm;
    protected RegisteredSyncs _syncs;
    protected ArrayList<ResourceCallback> _destroyCallbacks;
    private int _finishCount;
    protected RecoverableUnit _logUnit;
    protected RecoveryLog _tranLog;
    protected boolean _systemExceptionOccured;
    protected Exception _heuristicOnPrepare;
    protected int _retryAttempts;
    public static final int defaultRetryTime = 60;
    private static final String DISABLE_2PC_DEFAULT_PROPERTY = "com.ibm.tx.jta.disable2PC";
    protected long _expirationTime;
    protected volatile Xid _xid;
    protected int _localTID;
    private String _tranName;
    protected JCARecoveryData _JCARecoveryData;
    protected Xid _JCAXid;
    private static boolean _disable2PCDefault = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean(TransactionImpl.DISABLE_2PC_DEFAULT_PROPERTY);
        }
    });
    protected boolean _disableTwoPhase = _disable2PCDefault;
    protected boolean _needsManualCompletion;
    protected FailureScopeController _failureScopeController;
    protected boolean _inRecovery;
    protected boolean _doNotRetryRecovery;
    private Map<Object, Object> _synchronizationRegistryResources;
    public static final long GLOBAL_TRANSACTION_LOCAL_ID_MODIFIER = 0x6000000000000000L;
    private Thread _mostRecentThread;
    protected static boolean _isZos;
    public ConfigurationProvider _configProvider = ConfigurationProviderManager.getConfigurationProvider();
    static final boolean auditRecovery;
    private Byte _completedLTCBoundary;
    protected String _taskId;
    private TimeoutManager.TimeoutInfo _timeoutInfo;
    int _txType = 1;
    private final TransactionSynchronizationRegistry tsr = TransactionSynchronizationRegistryFactory.getTransactionSynchronizationRegistry();
    private static TraceComponent tc;
    private static final TraceComponent tcSummary;

    public static void setDisable2PCDefault(boolean disable2PCDefault) {
        _disable2PCDefault = disable2PCDefault;
    }

    public TransactionImpl(FailureScopeController fsc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TransactionImpl", (Object)fsc);
        }
        this._failureScopeController = fsc;
        this.traceCreate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TransactionImpl");
        }
    }

    protected TransactionImpl() {
    }

    public TransactionImpl(int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TransactionImpl", (Object)timeout);
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        TxPrimaryKey pk = this.initializeTran(timeout);
        this._xid = new XidImpl(pk);
        this.traceCreate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TransactionImpl");
        }
    }

    public TransactionImpl(int timeout, Xid xid, JCARecoveryData jcard) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TransactionImpl", (Object)new Object[]{timeout, xid, jcard});
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        this._subordinate = true;
        TxPrimaryKey pk = this.initializeTran(timeout);
        this._xid = new XidImpl(xid, pk);
        this._JCARecoveryData = jcard;
        this._JCAXid = new XidImpl(xid);
        this.traceCreate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TransactionImpl");
        }
    }

    public TransactionImpl(int txType, int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TransactionImpl", (Object)new Object[]{txType, timeout});
        }
        this._txType = txType;
        this.traceCreate();
        this._status = this.createState(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TransactionImpl");
        }
    }

    protected TxPrimaryKey initializeTran(int timeout) {
        this._localTID = LocalTIDTable.getLocalTID(this);
        TxPrimaryKey pk = new TxPrimaryKey(this._localTID, Configuration.getCurrentEpoch());
        this.initialize(timeout);
        if (this._timeout > 0) {
            this._expirationTime = pk.getTimeStamp() + (long)this._timeout * 1000L;
        }
        return pk;
    }

    protected void initialize(int timeout) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("(SPI) Transaction BEGIN occurred for TX: " + this._localTID));
        }
        if (this._failureScopeController != null) {
            this._failureScopeController.registerTransaction(this, false);
            if (this._failureScopeController.getRecoveryManager() == null || this._failureScopeController.getRecoveryManager().recoveryFailed()) {
                this._disableTwoPhase = true;
            }
        } else {
            this._disableTwoPhase = true;
        }
        if (tc.isDebugEnabled() && this._disableTwoPhase) {
            Tr.debug((TraceComponent)tc, (String)"No recovery log is currently available. Transaction can only support 1PC protocol");
        }
        this._status = this.createState(this);
        int maximumTransactionTimeout = this._configProvider.getMaximumTransactionTimeout();
        if (maximumTransactionTimeout > 0 && (timeout > maximumTransactionTimeout || timeout == 0)) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Timeout limited by maximumTransactionTimeout");
            }
            timeout = maximumTransactionTimeout;
        }
        if (timeout > 0) {
            this._timeout = timeout;
            TimeoutManager.setTimeout(this, 1, timeout);
        }
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean reconstruct(RecoverableUnit log, RecoveryLog tranLog) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconstruct", (Object)new Object[]{log, tranLog});
        }
        boolean result = true;
        RecoverableUnitSection raSection = log.lookupSection(7);
        if (raSection != null) {
            this._subordinate = true;
            byte[] logData = raSection.lastData();
            this._JCAXid = logData.length > 20 ? this.createJCAXid(logData, 8) : this._xid;
            long recoveryId = Util.getLongFromBytes(logData, 0);
            PartnerLogData pld = this._failureScopeController.getRecoveryManager().getPartnerLogTable().findEntry(recoveryId);
            if (pld instanceof JCARecoveryData) {
                this._JCARecoveryData = (JCARecoveryData)pld;
                this._JCARecoveryData.incrementCount();
                this.addDestroyCallback(this);
            } else {
                SystemException e = new SystemException();
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.TransactionImpl.reconstruct", (String)"632", (Object)this);
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"reconstruct", this.getClass().getName(), e});
                throw e;
            }
        }
        RecoveryManager recoveryManager = this._failureScopeController.getRecoveryManager();
        this._status = this.createState(this);
        int state = this._status.reconstruct(log);
        if (state == -1 || state == 4 || state == 6) {
            result = false;
        } else {
            this.reconstructCoordinators(log);
            this.getResources().reconstruct(recoveryManager, log);
            if (this._subordinate && (state == 7 || state == 8)) {
                this.prolongFinish();
            }
            this._localTID = LocalTIDTable.getLocalTID(this);
            this._failureScopeController.registerTransaction(this, true);
            this._inRecovery = true;
        }
        this._logUnit = log;
        this._tranLog = tranLog;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconstruct", (Object)new Object[]{result, this._subordinate});
        }
        return result;
    }

    protected TransactionState createState(TransactionImpl tx) {
        return new TransactionState(tx);
    }

    protected Xid createJCAXid(byte[] logData, int offset) {
        return new XidImpl(logData, offset);
    }

    protected void reconstructCoordinators(RecoverableUnit log) throws SystemException {
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void recover() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)this);
        }
        int state = this._status.getState();
        if (this._subordinate) {
            block0 : switch (state) {
                case 3: 
                case 4: 
                case 7: {
                    this.recoverCommit(true);
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    this.recoverRollback(true);
                    break;
                }
                default: {
                    if (this._JCARecoveryData != null) {
                        String id = this._JCARecoveryData.getWrapper().getProviderId();
                        if (TMHelper.isProviderInstalled((String)id)) {
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug((TraceComponent)tc, (String)"recover", (Object)("Do nothing. Expect provider " + id + " will complete."));
                            break;
                        }
                        switch (this._configProvider.getHeuristicCompletionDirection()) {
                            case 0: {
                                Tr.error((TraceComponent)tc, (String)"WTRN0098_COMMIT_RA_UNINSTALLED", (Object)new Object[]{this.getTranName(), id});
                                this.recoverCommit(false);
                                break block0;
                            }
                            case 2: {
                                this._needsManualCompletion = true;
                                Tr.info((TraceComponent)tc, (String)"WTRN0101_MANUAL_RA_UNINSTALLED", (Object)new Object[]{this.getTranName(), id});
                                break block0;
                            }
                        }
                        Tr.error((TraceComponent)tc, (String)"WTRN0099_ROLLBACK_RA_UNINSTALLED", (Object)new Object[]{this.getTranName(), id});
                        this.recoverRollback(false);
                        break;
                    }
                    this.retryCompletion();
                    break;
                }
            }
        } else if (state == 9) {
            switch (ConfigurationProviderManager.getConfigurationProvider().getHeuristicCompletionDirection()) {
                case 0: {
                    Tr.error((TraceComponent)tc, (String)"WTRN0096_HEURISTIC_MAY_HAVE_OCCURED", (Object)this.getTranName());
                    this.recoverCommit(false);
                    break;
                }
                case 2: {
                    this._needsManualCompletion = true;
                    Tr.info((TraceComponent)tc, (String)"WTRN0097_HEURISTIC_MANUAL_COMPLETION", (Object)this.getTranName());
                    break;
                }
                default: {
                    Tr.error((TraceComponent)tc, (String)"WTRN0102_HEURISTIC_MAY_HAVE_OCCURED", (Object)this.getTranName());
                    this.recoverRollback(false);
                    break;
                }
            }
        } else if (state == 3) {
            this.recoverCommit(false);
        } else {
            this.recoverRollback(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    protected void retryCompletion() {
    }

    public boolean isSubordinate() {
        return this._subordinate;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object)"(SPI)");
        }
        try {
            this.processCommit();
        }
        catch (HeuristicHazardException hhe) {
            HeuristicMixedException hme = new HeuristicMixedException(hhe.getLocalizedMessage());
            hme.initCause(hhe.getCause());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)new Object[]{"(SPI)", hme});
            }
            throw hme;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"(SPI)");
            }
        }
    }

    public void commit_one_phase() throws RollbackException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit_one_phase");
        }
        this._subordinate = false;
        try {
            this.processCommit();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit_one_phase");
            }
        }
    }

    private void processCommit() throws RollbackException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        int state = this.stage1CommitProcessing();
        try {
            this.stage2CommitProcessing(state);
        }
        finally {
            state = this._status.getState();
            this.notifyCompletion();
        }
        this.stage3CommitProcessing(state);
    }

    protected int stage1CommitProcessing() throws HeuristicMixedException, HeuristicRollbackException, SystemException, HeuristicHazardException {
        int state;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stage1CommitProcessing");
        }
        if (this.prePrepare()) {
            try {
                if (!this.hasResources()) {
                    state = 4;
                    this._status.setState(state);
                    this.postCompletion(3);
                }
                if (this._resources.isOnlyAgent()) {
                    state = this.commitXAResources();
                }
                state = this.prepareResources();
            }
            catch (HeuristicMixedException hme) {
                this.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stage1CommitProcessing", (Object)((Object)hme));
                }
                throw hme;
            }
            catch (HeuristicHazardException hhe) {
                this.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stage1CommitProcessing", (Object)hhe);
                }
                throw hhe;
            }
            catch (HeuristicRollbackException hre) {
                this.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stage1CommitProcessing", (Object)((Object)hre));
                }
                throw hre;
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.stage1CommitProcessing", (String)"1545", (Object)this);
                this.notifyCompletion();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stage1CommitProcessing", (Object)((Object)se));
                }
                throw se;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.TransactionImpl.stage1CommitProcessing", (String)"1551", (Object)this);
                this.notifyCompletion();
                SystemException se = new SystemException(t.getLocalizedMessage());
                se.initCause(t);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stage1CommitProcessing", (Object)new Object[]{t, se});
                }
                throw se;
            }
        } else {
            this._status.setState(5);
            state = this._status.getState();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stage1CommitProcessing", (Object)TransactionState.stateToString(state));
        }
        return state;
    }

    protected void coreStage2CommitProcessing(int state) throws HeuristicHazardException, SystemException, HeuristicMixedException, HeuristicRollbackException, HeuristicCommitException {
        switch (state) {
            case 3: {
                this.internalCommit();
                break;
            }
            case 5: {
                this.internalRollback();
                break;
            }
            case 9: {
                this.needsLPSHeuristicCompletion();
            }
        }
    }

    protected void stage2CommitProcessing(int state) throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)TransactionState.stateToString(state));
        }
        try {
            this.coreStage2CommitProcessing(state);
        }
        catch (HeuristicMixedException hme) {
            this.addHeuristic();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)((Object)hme));
            }
            throw hme;
        }
        catch (HeuristicHazardException hhe) {
            this.addHeuristic();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)hhe);
            }
            throw hhe;
        }
        catch (HeuristicCommitException hce) {
            this.addHeuristic();
            HeuristicMixedException hme = new HeuristicMixedException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)((Object)hme));
            }
            throw hme;
        }
        catch (HeuristicRollbackException hre) {
            this.addHeuristic();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)((Object)hre));
            }
            throw hre;
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.stage2CommitProcessing", (String)"1170", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)((Object)se));
            }
            throw se;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.TransactionImpl.stage2CommitProcessing", (String)"1176", (Object)this);
            SystemException se = new SystemException(t.getLocalizedMessage());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing", (Object)new Object[]{t, se});
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stage2CommitProcessing");
        }
    }

    protected void addHeuristic() {
    }

    private void stage3CommitProcessing(int state) throws SystemException, RollbackException, HeuristicMixedException, HeuristicHazardException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stage3CommitProcessing", (Object)TransactionState.stateToString(state));
        }
        switch (state) {
            case 5: 
            case 6: {
                RollbackException rbe;
                if (this._systemExceptionOccured) {
                    SystemException se = new SystemException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"stage3CommitProcessing", (Object)((Object)se));
                    }
                    throw se;
                }
                if (this._heuristicOnPrepare != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"stage3CommitProcessing", (Object)this._heuristicOnPrepare);
                    }
                    if (this._heuristicOnPrepare instanceof HeuristicMixedException) {
                        throw (HeuristicMixedException)((Object)this._heuristicOnPrepare);
                    }
                    throw (HeuristicHazardException)this._heuristicOnPrepare;
                }
                if (this.getOriginalException() == null) {
                    rbe = new RollbackException();
                } else {
                    rbe = new RollbackException();
                    rbe.initCause(this.getOriginalException());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"stage3CommitProcessing", (Object)((Object)rbe));
                }
                throw rbe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stage3CommitProcessing");
        }
    }

    private void needsLPSHeuristicCompletion() throws SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, HeuristicCommitException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"needsLPSHeuristicCompletion");
        }
        try {
            switch (this._configProvider.getHeuristicCompletionDirection()) {
                case 0: {
                    Tr.error((TraceComponent)tc, (String)"WTRN0096_HEURISTIC_MAY_HAVE_OCCURED", (Object)this.getTranName());
                    this._status.setState(3);
                    this.internalCommit();
                    break;
                }
                case 2: {
                    this._needsManualCompletion = true;
                    Tr.info((TraceComponent)tc, (String)"WTRN0097_HEURISTIC_MANUAL_COMPLETION", (Object)this.getTranName());
                    this.distributeAfter(3);
                    this.prolongFinish();
                    break;
                }
                default: {
                    Tr.error((TraceComponent)tc, (String)"WTRN0102_HEURISTIC_MAY_HAVE_OCCURED", (Object)this.getTranName());
                    this._status.setState(5);
                    this.internalRollback();
                }
            }
            throw new HeuristicHazardException();
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"needsLPSHeuristicCompletion");
            }
            throw throwable;
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        int state;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
        }
        if ((state = this._status.getState()) == 0) {
            this.cancelAlarms();
            try {
                this._status.setState(5);
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.rollback", (String)"1587", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught setting state to ROLLING_BACK!", (Object)((Object)se));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
                }
                throw se;
            }
            try {
                this.internalRollback();
            }
            catch (HeuristicMixedException hme) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HeuristicMixedException caught rollback processing", (Object)((Object)hme));
                }
                this.addHeuristic();
            }
            catch (HeuristicHazardException hhe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HeuristicHazardException caught rollback processing", (Object)hhe);
                }
                this.addHeuristic();
            }
            catch (HeuristicCommitException hce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HeuristicHazardException caught rollback processing", (Object)((Object)hce));
                }
                this.addHeuristic();
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.rollback", (String)"1626", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"SystemException caught during rollback", (Object)((Object)se));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
                }
                throw se;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.tx.jta.TransactionImpl.rollback", (String)"1633", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception caught during rollback", (Object)ex);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
                }
                throw new SystemException(ex.getLocalizedMessage());
            }
            finally {
                this.notifyCompletion();
            }
        } else {
            if (state == -1) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No transaction available!");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
                }
                throw new IllegalStateException();
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Invalid transaction state:" + state));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
        }
    }

    public int internalPrepare() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, IllegalStateException, SystemException {
        int state;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalPrepare");
        }
        if ((state = this._status.getState()) != 0) {
            if (state == -1) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No transaction available!");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"internalPrepare");
                }
                throw new IllegalStateException();
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Invalid transaction state: ", (Object)TransactionState.stateToString(state));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalPrepare");
            }
            throw new SystemException();
        }
        this.prePrepare();
        int result = this.prepareResources();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalPrepare", (Object)result);
        }
        return result;
    }

    protected int prepareResources() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareResources");
        }
        if (this.distributeEnd()) {
            try {
                this._status.setState(1);
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.prepareResources", (String)"446", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepareResources", (Object)((Object)se));
                }
                throw se;
            }
            this.perfPreparing();
            try {
                boolean xaOKVote;
                int vote;
                try {
                    vote = this.getResources().distributePrepare(this._subordinate, this.canOptimise());
                    xaOKVote = vote == 0;
                }
                catch (RollbackException rbe) {
                    FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.TransactionImpl.prepareResources", (String)"467", (Object)this);
                    this.setPrepareXAFailed();
                    throw rbe;
                }
                catch (SystemException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.prepareResources", (String)"473", (Object)this);
                    this.setPrepareXAFailed();
                    throw se;
                }
                boolean isXALastAgent = this.getResources().isLastAgentEnlisted();
                if (_isZos) {
                    vote = this.prepareZOSResources(isXALastAgent, vote);
                }
                if (isXALastAgent) {
                    vote = this.getResources().commitLastAgent(vote == 0, xaOKVote);
                }
                try {
                    switch (vote) {
                        case 0: {
                            if (this._subordinate) {
                                this._status.setState(2);
                                break;
                            }
                            this._status.setState(3);
                            break;
                        }
                        case 10: {
                            this.perfOnePhase();
                        }
                        case 3: {
                            this._status.setState(4);
                            this.postCompletion(3);
                            break;
                        }
                        case 11: {
                            this._status.setState(6);
                            this.perfOnePhase();
                            this.postCompletion(4);
                            break;
                        }
                        case 12: {
                            if (this._configProvider.isLoggingForHeuristicReportingEnabled()) break;
                            this._status.setState(9);
                        }
                    }
                }
                catch (SystemException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1496", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception caught setting state after PREPARE", (Object)((Object)se));
                    }
                    throw se;
                }
            }
            catch (RollbackException rbe) {
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1505", (Object)this);
                try {
                    this._status.setState(5);
                }
                catch (SystemException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1512", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepareResources", (Object)((Object)se));
                    }
                    throw se;
                }
            }
            catch (HeuristicMixedException he) {
                try {
                    this.logHeuristic(true);
                    if (this._status.getState() == 1) {
                        this._status.setState(5);
                    }
                }
                catch (SystemException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1533", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepareResources, se");
                    }
                    throw se;
                }
                if (!this._subordinate) {
                    this._heuristicOnPrepare = he;
                }
                throw he;
            }
            catch (HeuristicHazardException he) {
                try {
                    this.logHeuristic(true);
                    if (this._status.getState() == 1) {
                        this._status.setState(5);
                    }
                }
                catch (SystemException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1564", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepareResources", (Object)((Object)se));
                    }
                    throw se;
                }
                if (!this._subordinate) {
                    this._heuristicOnPrepare = he;
                }
                throw he;
            }
            catch (HeuristicRollbackException hre) {
                this.postCompletion(3);
                if (this._subordinate) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0057_HEURISTIC_ON_SUBORDINATE");
                    throw new SystemException();
                }
                throw hre;
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1598", (Object)this);
                this._systemExceptionOccured = true;
                try {
                    if (this._status.getState() == 1) {
                        this._status.setState(5);
                    }
                }
                catch (SystemException se2) {
                    FFDCFilter.processException((Throwable)se2, (String)"com.ibm.tx.jta.impl.TransactionImpl.prepareResources", (String)"1611", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"prepareResources", (Object)((Object)se2));
                    }
                    throw se2;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareResources");
        }
        return this._status.getState();
    }

    protected void perfOnePhase() {
    }

    protected int prepareZOSResources(boolean isXALastAgent, int vote) throws RollbackException, HeuristicMixedException, SystemException {
        return vote;
    }

    protected boolean canOptimise() {
        boolean ret;
        boolean bl = ret = !this._subordinate && this._configProvider.isOnePCOptimization();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"canOptimise", (Object)ret);
        }
        return ret;
    }

    protected void perfPreparing() {
    }

    protected void setPrepareXAFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPrepareXAFailed");
        }
        this.setRBO();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPrepareXAFailed");
        }
    }

    protected synchronized boolean prePrepare() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prePrepare");
        }
        this.cancelAlarms();
        if (!this._rollbackOnly && this._syncs != null) {
            this._syncs.distributeBefore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prePrepare", (Object)(!this._rollbackOnly ? 1 : 0));
        }
        return !this._rollbackOnly;
    }

    protected void cancelAlarms() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelAlarms");
        }
        if (this._timeout > 0) {
            TimeoutManager.setTimeout(this, 0, 0);
            this._timeout = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelAlarms");
        }
    }

    protected boolean distributeEnd() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeEnd");
        }
        if (!this.getResources().distributeEnd(0x4000000)) {
            this.setRBO();
        }
        if (this._rollbackOnly) {
            try {
                this._status.setState(5);
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.distributeEnd", (String)"1731", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"distributeEnd", (Object)((Object)se));
                }
                throw se;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeEnd", (Object)(!this._rollbackOnly ? 1 : 0));
        }
        return !this._rollbackOnly;
    }

    protected int commitXAResources() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"commitXAResources");
            }
            if (this.distributeEnd()) {
                this._status.setState(10);
                this.perfPreparing();
                this.perfCommitting();
                int status = 3;
                try {
                    this.getResources().flowCommitOnePhase(false);
                    this.perfOnePhase();
                    this._status.setState(4);
                }
                catch (HeuristicMixedException hme) {
                    this.processC1PHeuristic();
                    status = 5;
                    throw hme;
                }
                catch (HeuristicHazardException hhe) {
                    this.processC1PHeuristic();
                    status = 5;
                    throw hhe;
                }
                catch (HeuristicRollbackException hre) {
                    this.processC1PHeuristic();
                    status = 5;
                    throw hre;
                }
                catch (RollbackException rbe) {
                    status = 4;
                    this._status.setState(6);
                }
                catch (SystemException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TransactionImpl.commitXAResources", (String)"1816", (Object)this);
                    this._status.setState(6);
                    throw se;
                }
                finally {
                    this.postCompletion(status);
                    if (!this._systemExceptionOccured) break block13;
                    throw new SystemException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commitXAResources");
        }
        return this._status.getState();
    }

    protected void processC1PHeuristic() {
    }

    public void internalCommit() throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        this.internalCommit(false, false);
    }

    public void internalCommit(boolean cascaded, boolean boolafter) throws HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalCommit");
        }
        if (cascaded && boolafter) {
            this.postCompletion(3, cascaded, boolafter);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalCommit");
            }
            return;
        }
        this.perfCommitting();
        HeuristicMixedException savedHme = null;
        try {
            if (_isZos) {
                savedHme = this.internalZOSCommit();
            }
            this.getResources().distributeCommit();
        }
        catch (HeuristicMixedException hme) {
            this.logHeuristic(true);
            throw hme;
        }
        catch (HeuristicHazardException hhe) {
            this.logHeuristic(true);
            throw hhe;
        }
        catch (HeuristicRollbackException hre) {
            this.logHeuristic(true);
            throw hre;
        }
        finally {
            this.postCompletion(3, cascaded, boolafter);
            if (savedHme != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"internalCommit", (Object)((Object)savedHme));
                }
                throw savedHme;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalCommit");
            }
        }
    }

    protected HeuristicMixedException internalZOSCommit() {
        return null;
    }

    protected void perfCommitting() {
    }

    public void internalRollback() throws HeuristicMixedException, HeuristicHazardException, HeuristicCommitException, SystemException {
        this.internalRollback(false, false);
    }

    public void internalRollback(boolean cascaded, boolean cascafter) throws HeuristicMixedException, HeuristicHazardException, HeuristicCommitException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalRollback");
        }
        if (cascaded && cascafter) {
            this.postCompletion(4, cascaded, cascafter);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalRollback");
            }
            return;
        }
        SystemException ex = null;
        try {
            HeuristicMixedException savedHme = null;
            if (_isZos) {
                try {
                    this.internalZOSRollback();
                }
                catch (HeuristicMixedException hme) {
                    savedHme = hme;
                }
                catch (SystemException se) {
                    ex = se;
                }
            }
            this.getResources().distributeEnd(0x4000000);
            this.getResources().distributeRollback();
            if (savedHme != null) {
                throw savedHme;
            }
        }
        catch (HeuristicMixedException hme) {
            this.logHeuristic(false);
            throw hme;
        }
        catch (HeuristicHazardException hhe) {
            this.logHeuristic(false);
            throw hhe;
        }
        catch (HeuristicCommitException hce) {
            this.logHeuristic(false);
            throw hce;
        }
        finally {
            this.postCompletion(4, cascaded, cascafter);
            if (ex != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"internalRollback", (Object)((Object)ex));
                }
                throw ex;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalRollback");
            }
        }
    }

    protected void internalZOSRollback() throws HeuristicMixedException, SystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverCommit(boolean waitForHeuristic) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverCommit", (Object)new Object[]{waitForHeuristic, this._doNotRetryRecovery});
        }
        if (!this._doNotRetryRecovery) {
            this.auditTransaction();
            int state = this._status.getState();
            try {
                if (state != 3 && state != 7 && state != 4) {
                    this._status.setState(3);
                }
                this.getResources().distributeCommit();
            }
            catch (HeuristicMixedException hme) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverCommit processing", (Object)((Object)hme));
                }
                this.logHeuristicInRecovery(true);
                this.addHeuristic();
            }
            catch (HeuristicHazardException hhe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverCommit processing", (Object)hhe);
                }
                this.logHeuristicInRecovery(true);
                this.addHeuristic();
            }
            catch (HeuristicRollbackException hre) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverCommit processing", (Object)((Object)hre));
                }
                this.logHeuristicInRecovery(true);
                this.addHeuristic();
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.recoverCommit", (String)"1096", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverCommit processing", (Object)((Object)se));
                }
                Tr.error((TraceComponent)tc, (String)"WTRN0058_RECOVERY_EXCEPTION_IN_COMMIT", (Object)new Object[]{this.getTranName(), se});
            }
            finally {
                if (waitForHeuristic && state != 7 && 7 == this._status.getState()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Transaction state now heuristic");
                    }
                    this.prolongFinish();
                }
                this._doNotRetryRecovery = true;
                this.postCompletion(3);
                this.notifyCompletion();
            }
        }
        this.handleHeuristicOnCommit(waitForHeuristic);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverCommit");
        }
    }

    protected void handleHeuristicOnCommit(boolean waitForHeuristic) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleHeuristicOnCommit", (Object)waitForHeuristic);
        }
        if (this._doNotRetryRecovery && waitForHeuristic && 7 == this._status.getState()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"recoverCommit", (Object)"Checking if we can forget transaction");
            }
            if (this._JCARecoveryData == null) {
                this.notifyCompletion();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHeuristicOnCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverRollback(boolean waitForHeuristic) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverRollback", (Object)new Object[]{waitForHeuristic, this._doNotRetryRecovery});
        }
        if (!this._doNotRetryRecovery) {
            this.auditTransaction();
            int state = this._status.getState();
            try {
                if (state != 5 && state != 8 && state != 6) {
                    this._status.setState(5);
                }
                if (state == 0) {
                    this.getResources().distributeEnd(0x4000000);
                }
                this.getResources().distributeRollback();
            }
            catch (HeuristicMixedException hme) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverRollback processing", (Object)((Object)hme));
                }
                this.logHeuristicInRecovery(false);
                this.addHeuristic();
            }
            catch (HeuristicCommitException hce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverRollback processing", (Object)((Object)hce));
                }
                this.logHeuristicInRecovery(false);
                this.addHeuristic();
            }
            catch (HeuristicHazardException hhe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverRollback processing", (Object)hhe);
                }
                this.logHeuristicInRecovery(false);
                this.addHeuristic();
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.recoverRollback", (String)"1142", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught during recoverRollback processing", (Object)((Object)se));
                }
                Tr.error((TraceComponent)tc, (String)"WTRN0059_RECOVERY_EXCEPTION_IN_ROLLBACK", (Object)new Object[]{this.getTranName(), se});
            }
            finally {
                if (waitForHeuristic && state != 8 && 8 == this._status.getState()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Transaction state now heuristic");
                    }
                    this.prolongFinish();
                }
                this._doNotRetryRecovery = true;
                this.postCompletion(4);
                this.notifyCompletion();
            }
        }
        this.handleHeuristicOnRollback(waitForHeuristic);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverRollback");
        }
    }

    protected void handleHeuristicOnRollback(boolean waitForHeuristic) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleHeuristicOnRollback", (Object)waitForHeuristic);
        }
        if (this._doNotRetryRecovery && waitForHeuristic && 8 == this._status.getState()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"recoverRollback", (Object)"Checking if we can forget transaction");
            }
            if (this._JCARecoveryData == null) {
                this.notifyCompletion();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHeuristicOnRollback");
        }
    }

    protected void setRBO() {
        if (!this._rollbackOnly) {
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)"Transaction setRollbackOnly.", (Object)new Object[]{this, this._xid, Util.stackToDebugString(new Throwable())});
            }
            this._rollbackOnly = true;
        }
    }

    public void setOriginalException(Throwable originalException) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setOriginalException");
        }
        this._originalException = originalException;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setOriginalException");
        }
    }

    public Throwable getOriginalException() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOriginalException");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOriginalException", (Object)this._originalException);
        }
        return this._originalException;
    }

    public void setRollbackOnly() throws IllegalStateException {
        int state;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRollbackOnly", (Object)"(SPI)");
        }
        if ((state = this._status.getState()) == -1 || state == 4 || state == 6) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setRollbackOnly", (Object)"(SPI)");
            }
            throw new IllegalStateException("No transaction available");
        }
        this.setRBO();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRollbackOnly", (Object)"(SPI)");
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", xaRes});
        }
        switch (this._status.getState()) {
            case 0: {
                if (!this._timedOut) break;
            }
            case 5: 
            case 6: 
            case 8: {
                RollbackException rbe = new RollbackException("Transaction rolled back");
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1760", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", rbe});
                }
                throw rbe;
            }
            default: {
                IllegalStateException ise = new IllegalStateException("Transaction is inactive or prepared");
                FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1769", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
                }
                throw ise;
            }
        }
        if (xaRes == null) {
            IllegalStateException ise = new IllegalStateException("Cannot enlist a null resource");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        try {
            if (xaRes instanceof OnePhaseXAResource) {
                this.getResources().enlistResource(xaRes);
            } else {
                int recoveryId = TransactionManagerFactory.getTransactionManager().registerResourceInfo("unused", new DirectEnlistXAResourceInfo(xaRes));
                this.enlistResource(xaRes, recoveryId);
            }
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1858", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1868", (Object)this);
            this.setRollbackOnly();
            RollbackException rbe = new RollbackException(t.getMessage());
            rbe.initCause(t);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", rbe});
            }
            throw rbe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", Boolean.TRUE});
        }
        return true;
    }

    public boolean enlistResource(XAResource xaRes, int recoveryIndex) throws RollbackException, IllegalStateException, SystemException {
        return this.enlistResource(xaRes, recoveryIndex, 0);
    }

    public boolean enlistResource(XAResource xaRes, int recoveryIndex, int branchCoupling) throws RollbackException, IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", xaRes, recoveryIndex, branchCoupling});
        }
        switch (this._status.getState()) {
            case 0: {
                if (!this._timedOut) break;
            }
            case 5: 
            case 6: 
            case 8: {
                RollbackException rbe = new RollbackException("Transaction rolled back");
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1895", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", rbe});
                }
                throw rbe;
            }
            default: {
                IllegalStateException ise = new IllegalStateException("Transaction is inactive or prepared");
                FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1904", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
                }
                throw ise;
            }
        }
        if (xaRes == null) {
            String msg = "XAResource reference is null";
            IllegalStateException ise = new IllegalStateException("XAResource reference is null");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1914", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        if (recoveryIndex < 0) {
            String msg = "Illegal attempt to enlist 2PC XAResource without recovery information";
            IllegalStateException ise = new IllegalStateException("Illegal attempt to enlist 2PC XAResource without recovery information");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1934", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        PartnerLogTable plt = this._failureScopeController.getPartnerLogTable();
        PartnerLogData pld = plt.getEntry(recoveryIndex);
        if (pld instanceof XARecoveryData) {
            XARecoveryData recData = (XARecoveryData)pld;
            try {
                this.getResources().enlistResource(xaRes, recData, branchCoupling);
            }
            catch (RollbackException rbe) {
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"2035", (Object)this);
                this.setRollbackOnly();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", rbe});
                }
                throw rbe;
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"2042", (Object)this);
                this.setRollbackOnly();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", se});
                }
                throw se;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"2049", (Object)this);
                this.setRollbackOnly();
                SystemException se = new SystemException(t.getLocalizedMessage());
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", t});
                }
                throw se;
            }
        } else {
            String msg = "XAResource recovery data token invalid";
            SystemException se = new SystemException("XAResource recovery data token invalid");
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.enlistResource", (String)"1955", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", se});
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", Boolean.TRUE});
        }
        return true;
    }

    public void enlistResource(JTAResource remoteRes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI): args: ", remoteRes});
        }
        this.getResources().addRes(remoteRes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)"(SPI)");
        }
    }

    public void logLPSState() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logLPSState");
        }
        if (this._configProvider.isLoggingForHeuristicReportingEnabled()) {
            this._status.setState(9);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logLPSState");
        }
    }

    protected void logHeuristic(boolean commit) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logHeuristic", (Object)commit);
        }
        if (this._subordinate && this._status.getState() != 1) {
            this.getResources().logHeuristic(commit);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logHeuristic");
        }
    }

    private void logHeuristicInRecovery(boolean commit) {
        try {
            this.logHeuristic(commit);
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.logHeuristicInRecovery", (String)"2955", (Object)this);
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)tc, (String)"delistResource", (Object)new Object[]{"(SPI)", xaRes, Util.printFlag(flag)});
        }
        if (this._status.getState() != 0) {
            String msg = "Transaction is inactive or prepared";
            IllegalStateException ise = new IllegalStateException("Transaction is inactive or prepared");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.delistResource", (String)"2212", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        if (xaRes == null) {
            String msg = "XAResource reference is null";
            IllegalStateException ise = new IllegalStateException("XAResource reference is null");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.delistResource", (String)"2224", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        boolean delisted = false;
        try {
            delisted = this.getResources().delistResource(xaRes, flag);
        }
        catch (SystemException se) {
            try {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.delistResource", (String)"1928", (Object)this);
                throw se;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)new Object[]{"(SPI)", delisted});
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)new Object[]{"(SPI)", delisted});
        }
        return delisted;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException {
        this.registerSynchronization(sync, 1);
    }

    public void registerSynchronization(Synchronization sync, int tier) throws RollbackException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerSynchronization", (Object)new Object[]{"(SPI)", this, sync, tier});
        }
        switch (this._status.getState()) {
            case 0: {
                if (!this._timedOut) break;
            }
            case 5: 
            case 6: 
            case 8: {
                RollbackException rbe = new RollbackException("Transaction rolled back");
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.TransactionImpl.registerSynchronization", (String)"2289", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"registerSynchronization", (Object)new Object[]{"(SPI)", rbe});
                }
                throw rbe;
            }
            default: {
                IllegalStateException ise = new IllegalStateException("Transaction is inactive or prepared");
                FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.TransactionImpl.registerSynchronization", (String)"2297", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"registerSynchronization", (Object)new Object[]{"(SPI)", ise});
                }
                throw ise;
            }
        }
        this.getSyncs().add(sync, tier);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerSynchronization", (Object)"(SPI)");
        }
    }

    public int getStatus() {
        int state = 5;
        switch (this._status.getState()) {
            case -1: {
                state = 6;
                break;
            }
            case 0: {
                if (this._rollbackOnly) {
                    state = 1;
                    break;
                }
                state = 0;
                break;
            }
            case 1: 
            case 9: {
                state = 7;
                break;
            }
            case 2: {
                state = 2;
                break;
            }
            case 3: 
            case 10: {
                state = 8;
                break;
            }
            case 4: 
            case 7: {
                state = 3;
                break;
            }
            case 5: {
                state = 9;
                break;
            }
            case 6: 
            case 8: {
                state = 4;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getStatus (SPI)", (Object)Util.printStatus(state));
        }
        return state;
    }

    public RegisteredResources getResources() {
        if (this._resources == null) {
            this._resources = new RegisteredResources(this, this._disableTwoPhase);
        }
        return this._resources;
    }

    public RegisteredSyncs getSyncs() {
        if (this._syncs == null) {
            this._syncs = new RegisteredSyncs(this);
        }
        return this._syncs;
    }

    public TransactionState getTransactionState() {
        return this._status;
    }

    public XidImpl getXidImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getXidImpl", (Object)this);
        }
        return this.getXidImpl(true);
    }

    public XidImpl getXidImpl(boolean createIfAbsent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXidImpl", (Object)new Object[]{this, createIfAbsent});
        }
        if (createIfAbsent && this._xid == null) {
            this._xid = new XidImpl(new TxPrimaryKey(this._localTID, Configuration.getCurrentEpoch()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getXidImpl", (Object)this._xid);
        }
        return (XidImpl)this._xid;
    }

    public void setXidImpl(XidImpl xid) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setXidImpl", (Object)new Object[]{xid, this});
        }
        this._xid = xid;
    }

    @Override
    public Xid getXid() {
        return this.getXidImpl();
    }

    public String getTranName() {
        return Util.toHexString(this.getTID()).toUpperCase();
    }

    public long getLocalTID() {
        return this._localTID;
    }

    public RecoverableUnit getLog() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLog");
        }
        if (this._logUnit == null) {
            this._tranLog = this._failureScopeController.getTransactionLog();
            if (this._tranLog != null) {
                try {
                    this._logUnit = this._tranLog.createRecoverableUnit();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.TransactionImpl.getLog", (String)"2134", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WTRN0066_LOG_WRITE_ERROR", (Object)e);
                    this._rollbackOnly = true;
                    throw new SystemException(e.getLocalizedMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLog", (Object)this._logUnit);
        }
        return this._logUnit;
    }

    protected void postCompletion(int status) {
        this.postCompletion(status, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCompletion(int status, boolean cascaded, boolean cascafter) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postCompletion", (Object)status);
        }
        try {
            Object tScopeDestroyer;
            if (!this._inRecovery && (tScopeDestroyer = this.tsr.getResource((Object)"transactionScopeDestroyer")) instanceof TransactionScopeDestroyer) {
                ((TransactionScopeDestroyer)tScopeDestroyer).destroy();
            }
        }
        catch (IllegalStateException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting transactionScopeDestroyer", (Object)e);
            }
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionImpl.postCompletion", (String)"2738", (Object)this);
        }
        if (cascaded && cascafter) {
            try {
                this.distributeAfter(status);
            }
            catch (SystemException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionImpl.postCompletion", (String)"2870", (Object)this);
                this._systemExceptionOccured = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"postCompletion");
            }
            return;
        }
        this.perfCompleted(status);
        try {
            if (this._resources != null && HeuristicOutcome.isHeuristic(this._resources.getHeuristicOutcome())) {
                try {
                    this._resources.distributeForget();
                }
                catch (SystemException se) {
                    this._systemExceptionOccured = true;
                }
            }
            if (_isZos && this.postZOSCompletion()) {
            } else if (this.requireRetry()) {
                if (this._inRecovery) {
                    int heuristicRetryLimit;
                    if (this._retryAlarm == null) {
                        this._retryAttempts = 0;
                        this._retryAlarm = new RetryAlarm();
                    }
                    if ((heuristicRetryLimit = this._configProvider.getHeuristicRetryLimit()) <= 0 || this._retryAttempts < heuristicRetryLimit) {
                        ++this._retryAttempts;
                        this.prolongFinish();
                        this._doNotRetryRecovery = false;
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"WTRN0055_GIVING_UP_OUTCOME_DELIVERY", (Object)this.getTranName());
                        this.getResources().destroyResources();
                    }
                } else {
                    this._retryAlarm = new RetryAlarm();
                    this._retryAlarm.start();
                }
            }
        }
        finally {
            try {
                if (!cascaded) {
                    this.distributeAfter(status);
                }
            }
            catch (SystemException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TransactionImpl.postCompletion", (String)"2870", (Object)this);
                this._systemExceptionOccured = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postCompletion");
        }
    }

    protected boolean postZOSCompletion() {
        return false;
    }

    protected void perfCompleted(int status) {
    }

    protected void distributeAfter(int status) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeAfter", (Object)status);
        }
        TransactionManagerFactory.getTransactionManager().suspend();
        if (this._syncs != null) {
            this._syncs.distributeAfter(status);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeAfter");
        }
    }

    public final synchronized void prolongFinish() {
        ++this._finishCount;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"prolongFinish", (Object)this._finishCount);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized void notifyCompletion() {
        if (TransactionImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)TransactionImpl.tc, (String)"notifyCompletion", (Object)("finishCount=" + this._finishCount));
        }
        if (--this._finishCount < 0) {
            try {
                switch (this._status.getState()) {
                    case 3: 
                    case 7: {
                        this._status.setState(4);
                        ** break;
lbl9:
                        // 1 sources

                        break;
                    }
                    case 5: 
                    case 8: {
                        this._status.setState(6);
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 1: 
                    case 10: {
                        this._status.setState(4);
                        break;
                    }
                    ** default:
lbl18:
                    // 1 sources

                    break;
                }
            }
            catch (SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.TransactionImpl.notifyCompletion", (String)"2416", (Object)this);
                if (TransactionImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TransactionImpl.tc, (String)"SystemException setting state during completion processing", (Object)se);
                }
            }
            finally {
                this.forgetTransaction(true);
            }
        }
        if (TransactionImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)TransactionImpl.tc, (String)"notifyCompletion");
        }
    }

    protected void forgetTransaction(boolean transactionCompleted) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forgetTransaction", (Object)transactionCompleted);
        }
        if (_isZos) {
            this.forgetZOSTransaction();
        }
        if (this._destroyCallbacks != null) {
            for (int i = 0; i < this._destroyCallbacks.size(); ++i) {
                this._destroyCallbacks.get(i).destroy();
            }
            this._destroyCallbacks.clear();
            this._destroyCallbacks = null;
        }
        if (this._logUnit != null && transactionCompleted) {
            try {
                this._tranLog.removeRecoverableUnit(this._logUnit.identity());
            }
            catch (Exception e) {
                if (e instanceof LogClosedException && this._failureScopeController.getTransactionLog() == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction log has been shut down");
                    }
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.TransactionImpl.forgetTransaction", (String)"1199", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0066_LOG_WRITE_ERROR", (Object)e);
            }
            this._logUnit = null;
        }
        LocalTIDTable.removeLocalTID(this._localTID);
        if (_isZos) {
            this.removeZOSTransaction();
        }
        if (this._failureScopeController != null) {
            this._failureScopeController.deregisterTransaction(this, this._inRecovery);
        }
        if (this._JCARecoveryData != null) {
            TxExecutionContextHandler.removeTxn(this.getXid());
        }
        this._status.reset();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forgetTransaction");
        }
    }

    protected void removeZOSTransaction() {
    }

    protected void forgetZOSTransaction() {
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public byte[] getTID() {
        return this.getXidImpl().getOtidBytes();
    }

    @Override
    public boolean getRollbackOnly() {
        return this._rollbackOnly;
    }

    @Override
    public int getTxType() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTxType", (Object)this._txType);
        }
        return this._txType;
    }

    public final boolean equals(Object t) {
        TransactionImpl tran;
        if (t == this) {
            return true;
        }
        return t instanceof TransactionImpl && (tran = (TransactionImpl)t).getLocalTID() == this.getLocalTID();
    }

    public final int hashCode() {
        return this._localTID;
    }

    @Override
    public void setCompletedLTCBoundary(Byte completedLTCBoundary) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setCompletedLTCBoundary", (Object)new Object[]{completedLTCBoundary});
        }
        this._completedLTCBoundary = completedLTCBoundary;
    }

    @Override
    public Byte getCompletedLTCBoundary() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCompletedLTCBoundary", (Object)this._completedLTCBoundary);
        }
        return this._completedLTCBoundary;
    }

    public String toString() {
        String result = this._tranName;
        if (result == null) {
            String tail = this._localTID == 0 ? "" : "#tid=" + this._localTID;
            result = this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + tail;
            if (this._localTID != 0) {
                this._tranName = result;
            }
        }
        return result;
    }

    public synchronized void timeoutTransaction(boolean initial) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"timeoutTransaction", (Object)initial);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("(SPI) Transaction TIMEOUT occurred for TX: " + this.getLocalTID()));
        }
        this._timedOut = true;
        this._rollbackOnly = true;
        if (this._status.getState() == 0) {
            if (this._timeout == 0) {
                this._timeout = 10;
            }
            TimeoutManager.setTimeout(this, 3, this._timeout);
        }
        if (initial) {
            this.abortTransactionParticipants();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"timeoutTransaction");
        }
    }

    protected synchronized void abortTransactionParticipants() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abortTransactionParticipants");
        }
        this.getResources().abort();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abortTransactionParticipants");
        }
    }

    public boolean isTimedOut() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isTimedOut", (Object)this._timedOut);
        }
        return this._timedOut;
    }

    public void subRollback() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"subRollback");
        }
        this._subRollback = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"subRollback");
        }
    }

    public boolean isSubRollback() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isSubRollback", (Object)this._subRollback);
        }
        return this._subRollback;
    }

    public void putResource(Object key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putResource", (Object)new Object[]{key, value, this});
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putResource", (Object)npe);
            }
            throw npe;
        }
        if (this._synchronizationRegistryResources == null) {
            this._synchronizationRegistryResources = new HashMap<Object, Object>();
        }
        this._synchronizationRegistryResources.put(key, value);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putResource");
        }
    }

    public Object getResource(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource", (Object)new Object[]{key, this});
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResource", (Object)npe);
            }
            throw npe;
        }
        if (this._synchronizationRegistryResources == null) {
            this._synchronizationRegistryResources = new HashMap<Object, Object>();
        }
        Object resource = this._synchronizationRegistryResources.get(key);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResource", (Object)resource);
        }
        return resource;
    }

    public long getLocalId() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLocalId", (Object)this);
        }
        return (long)this._localTID | 0x6000000000000000L;
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object)new Object[]{sync, this});
        }
        this.getSyncs().add(sync, 2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization");
        }
    }

    public String getUOWName() {
        return this.getTranName();
    }

    public boolean requireRetry() {
        return this._resources != null && this._resources.requireRetry();
    }

    public boolean isRAImport() {
        boolean result;
        boolean bl = result = this._JCARecoveryData != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isRAImport", (Object)result);
        }
        return result;
    }

    public JCARecoveryData getJCARecoveryData() {
        return this._JCARecoveryData;
    }

    public void setJCARecoveryData(JCARecoveryData jcard) {
        this._JCARecoveryData = jcard;
    }

    public Xid getJCAXid() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getJCAXid", (Object)new Object[]{this, this._JCAXid});
        }
        return this._JCAXid;
    }

    @Override
    public void destroy() {
        if (this._JCARecoveryData != null) {
            this._JCARecoveryData.decrementCount();
        }
    }

    public void addDestroyCallback(ResourceCallback callback) {
        if (this._destroyCallbacks == null) {
            this._destroyCallbacks = new ArrayList();
        }
        this._destroyCallbacks.add(callback);
    }

    public boolean isJCAImportedAndPrepared(String providerId) {
        return this._JCARecoveryData != null && this._status.getState() == 2 && this._JCARecoveryData.getWrapper().getProviderId().equals(providerId);
    }

    public boolean hasResources() {
        return this._resources != null;
    }

    public void enableLPS() {
    }

    public void setMostRecentThread(Thread thread) {
        this._mostRecentThread = thread;
    }

    public Thread getMostRecentThread() {
        return this._mostRecentThread;
    }

    public void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object)this);
        }
        this.preserveSuperiorCoordinator();
        if (this.isRAImport()) {
            this.getJCARecoveryData().setRecovered(false);
        }
        for (JTAResource resource : this.getResources().getResourceObjects()) {
            if (resource instanceof JTAXAResourceImpl) {
                long rmid = ((JTAXAResourceImpl)resource).getRecoveryId();
                PartnerLogData pld = this._inRecovery ? this._failureScopeController.getRecoveryManager().getPartnerLogTable().findEntry(rmid) : this._failureScopeController.getPartnerLogTable().findEntry(rmid);
                if (pld == null) continue;
                pld.setRecovered(false);
                continue;
            }
            this.preserveSubordinateResource(resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    protected void preserveSuperiorCoordinator() {
    }

    protected void preserveSubordinateResource(JTAResource resource) {
    }

    @Override
    public String getTaskId() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTaskId", (Object)this._taskId);
        }
        return this._taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTaskId", (Object)new Object[]{taskId, this});
        }
        this._taskId = taskId;
    }

    public boolean auditSendCompletion(JTAResource resource, boolean outcome) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditSendCompletion", (Object)new Object[]{this, resource, outcome});
        }
        boolean result = false;
        if (this._inRecovery && auditRecovery && resource instanceof JTAXAResourceImpl) {
            if (outcome) {
                Tr.audit((TraceComponent)tc, (String)"WTRN0137_REC_TXN_COMMIT", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe()});
            } else {
                Tr.audit((TraceComponent)tc, (String)"WTRN0138_REC_TXN_ROLLBACK", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe()});
            }
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditSendCompletion", (Object)result);
        }
        return result;
    }

    public void auditCompletionResponse(int code, JTAResource resource, boolean outcome) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditCompletionResponse", (Object)new Object[]{this, code, resource, outcome});
        }
        if (this._inRecovery && auditRecovery && resource instanceof JTAXAResourceImpl) {
            if (outcome) {
                if (code == 0) {
                    Tr.audit((TraceComponent)tc, (String)"WTRN0140_REC_TXN_COMMITED", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe()});
                } else {
                    Tr.audit((TraceComponent)tc, (String)"WTRN0141_REC_TXN_COMMITERR", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe(), XAReturnCodeHelper.convertXACode(code)});
                }
            } else if (code == 0) {
                Tr.audit((TraceComponent)tc, (String)"WTRN0142_REC_TXN_ROLLED", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe()});
            } else {
                Tr.audit((TraceComponent)tc, (String)"WTRN0143_REC_TXN_ROLLEDERR", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe(), XAReturnCodeHelper.convertXACode(code)});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditCompletionResponse");
        }
    }

    public boolean auditSendForget(JTAResource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditSendForget", (Object)new Object[]{this, resource});
        }
        boolean result = false;
        if (this._inRecovery && auditRecovery && resource instanceof JTAXAResourceImpl) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0139_REC_TXN_FORGET", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe()});
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditSendForget", (Object)result);
        }
        return result;
    }

    public void auditForgetResponse(int code, JTAResource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditForgetResponse", (Object)new Object[]{this, code, resource});
        }
        if (this._inRecovery && auditRecovery && resource instanceof JTAXAResourceImpl) {
            if (code == 0) {
                Tr.audit((TraceComponent)tc, (String)"WTRN0144_REC_TXN_FORGOT", (Object)new Object[]{this._localTID, this.printXID(resource), resource.describe()});
            } else {
                Tr.audit((TraceComponent)tc, (String)"WTRN0145_REC_TXN_FORGETERR", (Object)new Object[]{this._localTID, resource.getXID(), resource.describe(), XAReturnCodeHelper.convertXACode(code)});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditForgetResponse");
        }
    }

    public void auditTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditTransaction", (Object)this);
        }
        if (this._inRecovery && auditRecovery) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0136_RECOVERING_TRAN", (Object)new Object[]{this.getTranName(), this._localTID, Util.printStatus(this.getStatus())});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditTransaction");
        }
    }

    private String printXID(JTAResource r) {
        return ((XidImpl)r.getXID()).printOtid();
    }

    public TimeoutManager.TimeoutInfo setTimeoutInfo(TimeoutManager.TimeoutInfo timeoutInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeoutInfo", (Object)timeoutInfo);
        }
        TimeoutManager.TimeoutInfo ret = this._timeoutInfo;
        this._timeoutInfo = timeoutInfo;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeoutInfo", (Object)ret);
        }
        return ret;
    }

    public TimeoutManager.TimeoutInfo getTimeoutInfo() {
        return this._timeoutInfo;
    }

    protected void traceCreate() {
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"Transaction created.", (Object)new Object[]{this, this._xid, Util.stackToDebugString(new Throwable())});
        }
    }

    static {
        auditRecovery = ConfigurationProviderManager.getConfigurationProvider().getAuditRecovery();
        tc = Tr.register(TransactionImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
        tcSummary = Tr.register((String)"TRANSUMMARY", (String)"TransactionSummary", null);
    }

    public class RetryAlarm
    implements AlarmListener {
        private int _count;
        private int _wait;
        private Alarm _alarm;
        private final AlarmManager _alarmManager;
        private boolean _finished;

        public RetryAlarm() {
            this._alarmManager = TransactionImpl.this._configProvider.getAlarmManager();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RetryAlarm");
            }
        }

        public void start() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RetryAlarm.start");
            }
            this._count = 0;
            int heuristicRetryInterval = TransactionImpl.this._configProvider.getHeuristicRetryInterval();
            this._wait = heuristicRetryInterval <= 0 ? 60 : heuristicRetryInterval;
            TransactionImpl.this.prolongFinish();
            if (TransactionImpl.this.getResources().retryImmediately()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Retrying immediately");
                }
                this._alarm = this._alarmManager.scheduleDeferrableAlarm(0L, (AlarmListener)this);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrying in " + this._wait + " seconds"));
                }
                this._alarm = this._alarmManager.scheduleDeferrableAlarm((long)this._wait * 1000L, (AlarmListener)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RetryAlarm.start");
            }
        }

        public synchronized void stop() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RetryAlarm.stop");
            }
            if (!this._finished) {
                this._finished = true;
                if (this._alarm != null) {
                    this._alarm.cancel();
                    this._alarm = null;
                }
                Tr.error((TraceComponent)tc, (String)"WTRN0077_OPERATOR_CANCELLED", (Object)TransactionImpl.this.getTranName());
                TransactionImpl.this.getResources().destroyResources();
                this.finishTransaction();
                TransactionImpl.this.getResources().updateHeuristicOutcome(10);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RetryAlarm.stop");
            }
        }

        public synchronized void alarm(Object alarmContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RetryAlarm.alarm");
            }
            if (!this._finished) {
                try {
                    boolean retryRequired = TransactionImpl.this.getResources().distributeOutcome();
                    if (retryRequired |= TransactionImpl.this.getResources().distributeForget()) {
                        ++this._count;
                        int heuristicRetryLimit = TransactionImpl.this._configProvider.getHeuristicRetryLimit();
                        if (heuristicRetryLimit > 0 && this._count >= heuristicRetryLimit) {
                            Tr.warning((TraceComponent)tc, (String)"WTRN0055_GIVING_UP_OUTCOME_DELIVERY", (Object)TransactionImpl.this.getTranName());
                            TransactionImpl.this.getResources().destroyResources();
                            this.finishTransaction();
                            this._finished = true;
                            TransactionImpl.this.getResources().updateHeuristicOutcome(10);
                            return;
                        }
                        if (this._count % 10 == 0 && this._wait < 0x3FFFFFFF) {
                            this._wait *= 2;
                        }
                        if (TransactionImpl.this.getResources().retryImmediately()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Retrying immediately");
                            }
                            this._alarm = this._alarmManager.scheduleDeferrableAlarm(0L, (AlarmListener)this);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Retrying in " + this._wait + " seconds"));
                            }
                            this._alarm = this._alarmManager.scheduleDeferrableAlarm((long)this._wait * 1000L, (AlarmListener)this);
                        }
                    } else {
                        this._finished = true;
                        this.finishTransaction();
                    }
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.tx.jta.TransactionImpl.RetryAlarm", (String)"1327", (Object)this);
                    this._finished = true;
                    this.finishTransaction();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RetryAlarm.alarm");
            }
        }

        private void finishTransaction() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RetryAlarm.finishTransaction");
            }
            TransactionImpl.this.notifyCompletion();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RetryAlarm.finishTransaction");
            }
        }
    }
}

