/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.PartnerLogData;
import com.ibm.tx.jta.impl.RecoveryWrapper;
import com.ibm.tx.jta.impl.XARecoveryData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;

public class XARecoveryWrapper
implements RecoveryWrapper {
    private static final TraceComponent tc = Tr.register(XARecoveryWrapper.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static final long serialVersionUID = -4128788408195351556L;
    protected String _xaResFactoryClassName;
    protected Serializable _xaResInfo;
    protected transient String[] _xaResFactoryClasspath;
    protected transient int _xaPriority;

    public XARecoveryWrapper(String xaResFactoryClassName, Serializable xaResInfo) {
        this(xaResFactoryClassName, xaResInfo, null, 0);
    }

    public XARecoveryWrapper(String xaResFactoryClassName, Serializable xaResInfo, String[] xaResFactoryClasspath) {
        this(xaResFactoryClassName, xaResInfo, xaResFactoryClasspath, 0);
    }

    public XARecoveryWrapper(String xaResFactoryClassName, Serializable xaResInfo, String[] xaResFactoryClasspath, int priority) {
        this._xaResFactoryClassName = xaResFactoryClassName;
        this._xaResInfo = xaResInfo;
        this._xaResFactoryClasspath = this.canonicalise(xaResFactoryClasspath);
        this._xaPriority = priority;
    }

    @Override
    public boolean isSameAs(RecoveryWrapper rw) {
        if (this == rw) {
            return true;
        }
        if (rw != null && rw instanceof XARecoveryWrapper) {
            XARecoveryWrapper other = (XARecoveryWrapper)rw;
            if (this._xaResInfo.equals(other.getXAResourceInfo())) {
                if (this._xaPriority == other.getPriority()) {
                    if (this._xaResFactoryClassName.equals(other.getXAResourceFactoryClassName())) {
                        Object[] thisClasspath = this.getXAResourceFactoryClasspath();
                        Object[] otherClasspath = other.getXAResourceFactoryClasspath();
                        if (thisClasspath != null && thisClasspath.length == 0) {
                            thisClasspath = null;
                        }
                        if (otherClasspath != null && otherClasspath.length == 0) {
                            otherClasspath = null;
                        }
                        if (Arrays.equals(thisClasspath, otherClasspath)) {
                            return true;
                        }
                        if (tc.isDebugEnabled()) {
                            int i;
                            Tr.debug((TraceComponent)tc, (String)"XAResFactoryClasspaths differ", (Object[])new Object[0]);
                            if (this._xaResFactoryClasspath != null) {
                                for (i = 0; i < this._xaResFactoryClasspath.length; ++i) {
                                    Tr.debug((TraceComponent)tc, (String)("this classpath[" + i + "]=" + this._xaResFactoryClasspath[i]), (Object[])new Object[0]);
                                }
                            }
                            if (other._xaResFactoryClasspath != null) {
                                for (i = 0; i < other._xaResFactoryClasspath.length; ++i) {
                                    Tr.debug((TraceComponent)tc, (String)("other classpath[" + i + "]=" + other._xaResFactoryClasspath[i]), (Object[])new Object[0]);
                                }
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"XAResFactoryClassNames differ", (Object[])new Object[]{this._xaResFactoryClassName, other.getXAResourceFactoryClassName()});
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"XAResInfos differ", (Object[])new Object[]{this._xaResInfo, other.getXAResourceInfo()});
            }
        }
        return false;
    }

    @Override
    public byte[] serialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serialize", (Object[])new Object[]{this});
        }
        byte[] b = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.flush();
            out.close();
            b = bos.toByteArray();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.XARecoveryWrapper.serialize", (String)"162");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to serialize an object to the byte stream", (Object[])new Object[]{e});
            }
            b = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serialize", b);
        }
        return b;
    }

    @Override
    public PartnerLogData container(FailureScopeController failureScopeController) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"container", (Object[])new Object[]{failureScopeController});
        }
        XARecoveryData pld = new XARecoveryData(failureScopeController, this);
        byte[] serializedLogData = this.serialize();
        String[] classpathArray = this._xaResFactoryClasspath;
        if (serializedLogData == null) {
            Tr.warning((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED", (Object[])new Object[0]);
            NotSerializableException e = new NotSerializableException("XAResource recovery information failed serialization");
            Tr.audit((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object[])new Object[]{this._xaResInfo, e});
        } else {
            try {
                XARecoveryWrapper wrapper2 = XARecoveryWrapper.deserialize(serializedLogData);
                if (wrapper2 != null) {
                    wrapper2.setXAResourceFactoryClasspath(classpathArray);
                    wrapper2.setPriority(this._xaPriority);
                }
                if (!this.isSameAs(wrapper2)) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0040_OBJECT_DESERIALIZE_FAILED", null);
                    Tr.audit((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object[])new Object[]{this._xaResInfo, null});
                    serializedLogData = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"XAResourceInfo fails equality test", (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.XARecoveryWrapper.container", (String)"193");
                Tr.error((TraceComponent)tc, (String)"WTRN0040_OBJECT_DESERIALIZE_FAILED", (Object[])new Object[]{e});
                Tr.audit((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object[])new Object[]{this._xaResInfo, e});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"XAResourceInfo fails deserialization test", (Object[])new Object[]{e});
                }
                serializedLogData = null;
            }
        }
        if (serializedLogData != null) {
            byte[] combinedData = null;
            if (classpathArray != null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"XAResourceInfo classpath data found. Adding to log data", (Object[])new Object[0]);
                }
                StringBuffer classpathString = new StringBuffer();
                if (tc.isDebugEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Creating String from array elements.", (Object[])new Object[0]);
                }
                for (int i = 0; i < classpathArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Element [" + i + "] = " + classpathArray[i]), (Object[])new Object[0]);
                    }
                    classpathString.append(classpathArray[i]);
                    classpathString.append(File.pathSeparator);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ResourceInfo classpath", (Object[])new Object[]{classpathString.toString()});
                }
                byte[] classpathData = classpathString.toString().getBytes();
                combinedData = new byte[classpathData.length + 1 + serializedLogData.length];
                System.arraycopy(classpathData, 0, combinedData, 0, classpathData.length);
                combinedData[classpathData.length] = 0;
                System.arraycopy(serializedLogData, 0, combinedData, classpathData.length + 1, serializedLogData.length);
            } else {
                combinedData = new byte[1 + serializedLogData.length];
                combinedData[0] = 0;
                System.arraycopy(serializedLogData, 0, combinedData, 1, serializedLogData.length);
            }
            pld.setSerializedLogData(combinedData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"container", (Object)pld);
        }
        return pld;
    }

    static XARecoveryWrapper deserialize(byte[] serializedWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserialize", (Object[])new Object[0]);
        }
        XARecoveryWrapper wrapper = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serializedWrapper);
            ObjectInputStream oin = new ObjectInputStream(bis);
            wrapper = (XARecoveryWrapper)oin.readObject();
            oin.close();
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.XARecoveryWrapper.deserialize", (String)"298");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to deserialize an object from byte stream", (Object[])new Object[]{e});
            }
            String notfound = e.getMessage();
            int index = notfound.indexOf(":");
            notfound = notfound.substring(index + 1);
            Tr.error((TraceComponent)tc, (String)"WTRN0002_UNABLE_TO_FIND_RESOURCE_CLASS", (Object[])new Object[]{notfound});
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.Transaction.JTA.XARecoveryWrapper.deserialize", (String)"306");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to deserialize an object from byte stream", (Object[])new Object[]{t});
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0040_OBJECT_DESERIALIZE_FAILED", (Object[])new Object[]{t});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deserialize", (Object)wrapper);
        }
        return wrapper;
    }

    public String getXAResourceFactoryClassName() {
        return this._xaResFactoryClassName;
    }

    public Serializable getXAResourceInfo() {
        return this._xaResInfo;
    }

    public void setXAResourceFactoryClasspath(String[] classpath) {
        this._xaResFactoryClasspath = classpath;
    }

    public String[] getXAResourceFactoryClasspath() {
        return this._xaResFactoryClasspath;
    }

    public void setPriority(int priority) {
        this._xaPriority = priority;
    }

    public int getPriority() {
        return this._xaPriority;
    }

    public String toString() {
        String classpath = "";
        if (this._xaResFactoryClasspath != null && this._xaResFactoryClasspath.length > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this._xaResFactoryClasspath.length; ++i) {
                buffer.append(this._xaResFactoryClasspath[i]);
                buffer.append(File.pathSeparator);
            }
            classpath = buffer.toString();
        }
        return this._xaResFactoryClassName + ", " + this._xaResInfo.toString() + ", " + classpath + ", " + this._xaPriority;
    }

    private String[] canonicalise(String[] xaResInfoClasspath) {
        String[] result;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"canonicalise", (Object[])xaResInfoClasspath);
        }
        if (xaResInfoClasspath != null) {
            ArrayList<String> al = new ArrayList<String>();
            for (final String pathElement : xaResInfoClasspath) {
                String cp;
                if (pathElement == null) continue;
                try {
                    cp = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            String path = new File(pathElement).getCanonicalPath();
                            if (!new File(path).exists()) {
                                path = null;
                            }
                            return path;
                        }
                    });
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.Transaction.JTA.XARecoveryWrapper.canonicalise", (String)"512", (Object)this);
                    cp = pathElement;
                }
                if (cp == null) continue;
                al.add(cp);
            }
            result = al.size() > 0 ? al.toArray(new String[al.size()]) : null;
        } else {
            result = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"canonicalise", result);
        }
        return result;
    }
}

