/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public class SignatureTimestampToken
extends PKCS9DerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.SignatureTimestampToken";
    private ContentInfo contentInfo;

    public SignatureTimestampToken(ContentInfo info) {
        this.contentInfo = info;
    }

    public SignatureTimestampToken(byte[] der) throws IOException {
        super(der);
    }

    public SignatureTimestampToken(byte[] der, String provider) throws IOException {
        super(der, provider);
    }

    public SignatureTimestampToken(String filename, boolean base64) throws IOException {
        super(filename, base64);
    }

    public SignatureTimestampToken(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
    }

    @Override
    public boolean isTagValid(byte tag) {
        return tag == 48;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "SignatureTimestampToken";
    }

    @Override
    public Object getValue() {
        if (this.contentInfo == null) {
            return null;
        }
        return this.contentInfo.clone();
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "TimestampToken object is not initialized.");
            }
            throw new IOException("TimestampToken object is not initialized.");
        }
        DerEncoder[] timestampTokenSeq = new DerOutputStream[]{new DerOutputStream()};
        this.contentInfo.encode(timestampTokenSeq[0]);
        DerOutputStream attribute = new DerOutputStream();
        attribute.putOID(this.getObjectIdentifier());
        attribute.putOrderedSetOf((byte)49, timestampTokenSeq);
        DerOutputStream attribSeq = new DerOutputStream();
        attribSeq.write((byte)48, attribute);
        os.write(attribSeq.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[\n");
        buffer.append("SignatureTimestampToken :\n");
        buffer.append(this.contentInfo.toString());
        buffer.append("\n]");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SignatureTimestampToken)) {
            return false;
        }
        return this.contentInfo.equals(((SignatureTimestampToken)obj).getValue());
    }

    @Override
    public int hashCode() {
        return this.contentInfo.hashCode();
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.contentInfo = new ContentInfo(elems[0].toByteArray());
        if (!this.contentInfo.getContentType().equals(PKCSOID.SIGNED_DATA_OID)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "decode", "ContentInfo is not SignedData", this.contentInfo.getContentType());
            }
            throw new IOException("Invalid encoding of SignatureTimestampToken");
        }
        EncapsulatedContentInfo encapContInfo = ((SignedData)this.contentInfo.getContent()).getEncapsulatedContentInfo();
        if (encapContInfo == null || !encapContInfo.getContentType().equals(PKCSOID.TSTINFO_OID)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "decode", "EncapsulatedContentInfo does not contain a TSTInfo object", encapContInfo == null ? null : encapContInfo.getContentType());
            }
            throw new IOException("Invalid encoding of SignatureTimestampToken");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", encoding);
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        return PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SignatureTimestampToken result = new SignatureTimestampToken(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
            }
            return null;
        }
    }
}

