/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public final class InhibitAnyPolicyExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "InhibitAnyPolicy";
    public static final String NUMBER = "value";
    private BigInteger skipCerts = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.InhibitAnyPolicyExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.skipCerts == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        os.putInteger(this.skipCerts);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public InhibitAnyPolicyExtension(int skipCerts) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "InhibitAnyPolicyExtension", new Integer(skipCerts));
        }
        this.skipCerts = BigInteger.valueOf(skipCerts);
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "InhibitAnyPolicyExtension");
        }
    }

    public InhibitAnyPolicyExtension(BigInteger skipCerts) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "InhibitAnyPolicyExtension", skipCerts);
        }
        this.skipCerts = skipCerts;
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "InhibitAnyPolicyExtension");
        }
    }

    public InhibitAnyPolicyExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "InhibitAnyPolicyExtension", critical, value);
        }
        if (!critical.booleanValue()) {
            if (debug != null) {
                debug.text(16384L, className, "InhibitAnyPolicyExtension", "The InhibitAnyPolicyExtension must be critical");
            }
            throw new IOException("The InhibitAnyPolicyExtension must be critical");
        }
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            extValue[i2] = Array.getByte(value, i2);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.skipCerts = val.getInteger();
        if (debug != null) {
            debug.exit(16384L, className, "InhibitAnyPolicyExtension");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof BigInteger)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type BigInteger.");
                }
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.skipCerts = (BigInteger)obj;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.skipCerts == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.skipCerts);
            }
            return this.skipCerts;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", "Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.skipCerts = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s2 = super.toString() + "InhibitAnyPolicy: " + (this.skipCerts == null ? "" : this.skipCerts.toString()) + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s2);
        }
        return s2;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

