/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.inputstream.HttpInputStreamConnectWeb;
import com.ibm.ws.http.channel.inputstream.HttpInputStreamObserver;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTInputStream
extends WSServletInputStream {
    protected InputStream in;
    protected HttpInputStreamConnectWeb inStream = null;
    protected long contentLength;
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTInputStream";
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt.SRTInputStream");

    @Override
    public void finish() throws IOException {
        this.in.close();
    }

    @Override
    public void init(InputStream in) throws IOException {
        this.in = in;
        if (in != null && in instanceof HttpInputStreamConnectWeb) {
            this.inStream = (HttpInputStreamConnectWeb)in;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "set up for " + (Object)((Object)this) + " ,in" + this.inStream);
            }
        } else if (in == null) {
            this.inStream = null;
        }
    }

    @Override
    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] output) throws IOException {
        return this.in.read(output, 0, output.length);
    }

    public int read(byte[] output, int offset, int length) throws IOException {
        return this.in.read(output, offset, length);
    }

    public void close() throws IOException {
        if (this.in != null && this.inStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "close", "close called->" + (Object)((Object)this));
            }
            this.in.close();
        } else {
            super.close();
        }
    }

    public long skip(long n) throws IOException {
        if (this.in != null && this.inStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "skip", "skip called->" + (Object)((Object)this));
            }
            return this.in.skip(n);
        }
        return super.skip(n);
    }

    public int available() throws IOException {
        if (this.in != null && this.inStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "available", "available called->" + (Object)((Object)this));
            }
            return this.in.available();
        }
        return super.available();
    }

    public InputStream getInStream() {
        return this.inStream;
    }

    @Override
    public void restart() {
        if (this.inStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "restart", "SRTInputStream: Start re-read of data" + (Object)((Object)this));
            }
            this.inStream.restart();
        }
    }

    public void setupforMultiRead(boolean set) {
        if (this.inStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setISObserver", "set up for Multiread" + (Object)((Object)this));
            }
            this.inStream.setupforMultiRead(set);
        }
    }

    public void cleanupforMultiRead() {
        if (this.inStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "cleanupforMultiRead", "clean up for Multiread" + (Object)((Object)this));
            }
            this.inStream.cleanupforMultiRead();
        }
    }

    public void setISObserver(HttpInputStreamObserver obs) {
        if (this.inStream != null) {
            this.inStream.setISObserver(obs);
        }
    }
}

