/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.BrTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.renderer.FlexContainerRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.Map;
import java.util.regex.Pattern;

public class DisplayFlexTagWorker
implements ITagWorker,
IDisplayAware {
    private static final Pattern ANY_SYMBOL_PATTERN = Pattern.compile("\\S+");
    private final Div flexContainer = new Div();
    private final WaitingInlineElementsHelper inlineHelper;

    public DisplayFlexTagWorker(IElementNode element, ProcessorContext context) {
        this.flexContainer.setNextRenderer((IRenderer)new FlexContainerRenderer(this.flexContainer));
        Map styles = element.getStyles();
        this.inlineHelper = new WaitingInlineElementsHelper(styles == null ? null : (String)styles.get("white-space"), styles == null ? null : (String)styles.get("text-transform"));
        AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.flexContainer, element);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (this.inlineHelperContainsText()) {
            this.addInlineWaitingLeavesToFlexContainer();
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        if (ANY_SYMBOL_PATTERN.matcher(content).find()) {
            this.inlineHelper.add(content);
        }
        return true;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.flexContainer;
    }

    @Override
    public String getDisplay() {
        return "flex";
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer element = childTagWorker.getElementResult();
        if (childTagWorker instanceof BrTagWorker) {
            this.inlineHelper.add((ILeafElement)element);
        } else {
            if (this.inlineHelperContainsText()) {
                this.addInlineWaitingLeavesToFlexContainer();
            }
            if (element instanceof IBlockElement) {
                this.flexContainer.add((IBlockElement)element);
            } else if (element instanceof Image) {
                this.flexContainer.add((Image)element);
            } else if (element instanceof AreaBreak) {
                this.flexContainer.add((AreaBreak)element);
            } else {
                return false;
            }
        }
        return true;
    }

    private void addInlineWaitingLeavesToFlexContainer() {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.flexContainer);
        this.inlineHelper.clearWaitingLeaves();
    }

    private boolean inlineHelperContainsText() {
        boolean containsText = false;
        for (IElement element : this.inlineHelper.getWaitingLeaves()) {
            if (!(element instanceof Text) || !ANY_SYMBOL_PATTERN.matcher(((Text)element).getText()).find()) continue;
            containsText = true;
        }
        return containsText;
    }
}

