/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.JsonTable;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.FamilyExistsException;
import com.mapr.db.exceptions.FamilyNotFoundException;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.AdminImplHelper;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.fs.ErrnoException;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.tables.TableProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;

@API.Internal
public class AdminImpl
implements Admin {
    private static final Configuration DEFAULT_CONFIGURATION = new Configuration();
    private final MapRFileSystem maprfs_;
    private final AdminImplHelper helper_;
    private boolean shoulCloseFS_ = false;

    public AdminImpl(Configuration conf) throws DBException {
        this(AdminImpl.newMapRFS(conf));
        this.shoulCloseFS_ = true;
    }

    public AdminImpl(MapRFileSystem maprfs) throws DBException {
        this.maprfs_ = maprfs;
        this.helper_ = new AdminImplHelper(this, maprfs);
    }

    private static MapRFileSystem newMapRFS(Configuration conf) throws DBException {
        try {
            MapRFileSystem maprfs = new MapRFileSystem();
            maprfs.initialize(new URI("maprfs:///"), conf);
            return maprfs;
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    @Override
    public synchronized void close() throws DBException {
        try {
            if (this.shoulCloseFS_) {
                this.maprfs_.close();
                this.shoulCloseFS_ = false;
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "close()");
        }
    }

    @Override
    public List<Path> listTables() throws DBException {
        return this.listTables((Path)null);
    }

    @Override
    public List<Path> listTables(String folderOrPattern) throws DBException {
        return this.listTables(folderOrPattern == null ? null : new Path(folderOrPattern));
    }

    @Override
    public List<Path> listTables(Path folderOrPattern) throws DBException {
        try {
            return this._listTables(folderOrPattern);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "listTables()");
        }
    }

    private List<Path> _listTables(Path folderOrPattern) throws IOException {
        FileStatus[] children;
        try {
            MapRFileStatus patternStat;
            if (folderOrPattern == null) {
                folderOrPattern = this.maprfs_.getWorkingDirectory();
            }
            children = (patternStat = this.maprfs_.getMapRFileStatus(folderOrPattern)).isDirectory() ? this.maprfs_.listMapRStatus(folderOrPattern, false, false) : new MapRFileStatus[]{patternStat};
        }
        catch (FileNotFoundException e) {
            children = this.maprfs_.globStatus(folderOrPattern);
        }
        LinkedList tables = Lists.newLinkedList();
        if (children != null) {
            for (FileStatus fileStatus : children) {
                TableProperties prop;
                if (!fileStatus.isTable() || !(prop = this.maprfs_.getTableProperties(fileStatus.getPath())).getAttr().getJson()) continue;
                tables.add(new Path(fileStatus.getPath().toUri().getPath()));
            }
        }
        return tables;
    }

    @Override
    public JsonTable createTable(String tablePath) throws TableExistsException, DBException {
        return this.helper_._createTable(new TableDescriptorImpl(new Path(tablePath)), null, true);
    }

    @Override
    public JsonTable createTable(Path tablePath) throws DBException {
        return this.helper_._createTable(new TableDescriptorImpl(tablePath), null, true);
    }

    @Override
    public JsonTable createTable(TableDescriptor tableDesc) throws TableExistsException, DBException {
        return this.helper_._createTable(tableDesc, null, true);
    }

    public JsonTable createTable(TableDescriptor tableDesc, Value[] splitPoints) throws TableExistsException, DBException {
        byte[][] encodedSplitKeys = null;
        if (splitPoints != null && splitPoints.length > 0) {
            encodedSplitKeys = new byte[splitPoints.length][];
            for (int i = 0; i < splitPoints.length; ++i) {
                Preconditions.checkArgument((boolean)IdCodec.isSupportedType(splitPoints[i].getType()), (Object)(splitPoints[i].getType() + " is not a supported type for split points."));
                encodedSplitKeys[i] = IdCodec.encodeAsBytes(splitPoints[i]);
            }
        }
        return this.helper_._createTable(tableDesc, encodedSplitKeys, true);
    }

    @Override
    public JsonTable createTable(TableDescriptor tableDesc, String[] splitPoints) throws TableExistsException, DBException {
        byte[][] encodedSplitKeys = null;
        if (splitPoints != null && splitPoints.length > 0) {
            encodedSplitKeys = new byte[splitPoints.length][];
            for (int i = 0; i < splitPoints.length; ++i) {
                encodedSplitKeys[i] = IdCodec.encodeAsBytes(splitPoints[i]);
            }
        }
        return this.helper_._createTable(tableDesc, encodedSplitKeys, true);
    }

    @Override
    public JsonTable createTable(TableDescriptor tableDesc, ByteBuffer[] splitPoints) throws TableExistsException, DBException {
        byte[][] encodedSplitKeys = null;
        if (splitPoints != null && splitPoints.length > 0) {
            encodedSplitKeys = new byte[splitPoints.length][];
            for (int i = 0; i < splitPoints.length; ++i) {
                encodedSplitKeys[i] = IdCodec.encodeAsBytes(splitPoints[i]);
            }
        }
        return this.helper_._createTable(tableDesc, encodedSplitKeys, true);
    }

    @API.Internal
    public JsonTable createTable(String tablePath, boolean openTable) throws TableExistsException, DBException {
        return this.helper_._createTable(new TableDescriptorImpl(new Path(tablePath)), null, openTable);
    }

    @API.Internal
    public JsonTable createTable(TableDescriptor tableDesc, boolean openTable) throws TableExistsException, DBException {
        return this.helper_._createTable(tableDesc, null, openTable);
    }

    @Override
    public void alterTable(TableDescriptor desc) throws TableNotFoundException, DBException {
        try {
            TableDescriptor oldDesc = this.getTableDescriptor(desc.getPath());
            if (!oldDesc.isBulkLoad() && desc.isBulkLoad()) {
                throw new OpNotPermittedException("Bulk load mode can only be turned off.");
            }
            if (!desc.getFamilies().equals(oldDesc.getFamilies())) {
                throw new OpNotPermittedException("alterTable() can not be used to modify families of the table.");
            }
            TableDescriptorImpl descImpl = (TableDescriptorImpl)desc;
            this.maprfs_.modifyTableAttr(desc.getPath(), descImpl.getTableAttr().clearJson().build(), descImpl.getTableAces().build());
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "alterTable()");
        }
    }

    public void addFamily(Path tablePath, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyExistsException, DBException {
        try {
            if (familyDesc.getTTL() != 0L) {
                throw new OpNotPermittedException("TLL cannot be set with multiple column families.");
            }
            this.maprfs_.createColumnFamily(tablePath, familyDesc.getName(), this.helper_.getColumnFamilyAttr(false, null, familyDesc), null);
        }
        catch (IOException e) {
            if (e instanceof ErrnoException && ((ErrnoException)e).getErrno() == 17) {
                throw new FamilyExistsException(tablePath, familyDesc, e);
            }
            throw ExceptionHandler.handle(e, "addFamily()");
        }
    }

    @Override
    public boolean deleteFamily(String tablePath, String familyName) throws TableNotFoundException, FamilyNotFoundException, DBException {
        return this.deleteFamily(new Path(tablePath), familyName);
    }

    @Override
    public boolean deleteFamily(Path tablePath, String familyName) throws TableNotFoundException, FamilyNotFoundException, DBException {
        if (familyName.equals("default")) {
            throw new OpNotPermittedException("default family cannot be deleted.");
        }
        try {
            this.maprfs_.deleteColumnFamily(tablePath, familyName);
            return true;
        }
        catch (IOException e) {
            if (e instanceof ErrnoException && ((ErrnoException)e).getErrno() == 2) {
                return false;
            }
            throw ExceptionHandler.handle(e, "deleteFamily()");
        }
    }

    @Override
    public void alterFamily(String tablePath, String familyName, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyNotFoundException, OpNotPermittedException, DBException {
        this.alterFamily(new Path(tablePath), familyName, familyDesc);
    }

    @Override
    public void alterFamily(Path tablePath, String familyName, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyNotFoundException, DBException {
        if (familyName.equals("default") && familyDesc.hasName() && !familyDesc.getName().equals("default")) {
            throw new OpNotPermittedException("default family name cannot be altered.");
        }
        TableDescriptor tableDesc = this.getTableDescriptor(tablePath);
        FamilyDescriptor oldFamilyDesc = tableDesc.getFamily(familyName);
        if (oldFamilyDesc == null) {
            throw new FamilyNotFoundException(tablePath, familyName);
        }
        if (!oldFamilyDesc.getJsonFieldPath().equals((Object)familyDesc.getJsonFieldPath())) {
            throw new OpNotPermittedException("A family's Json path can not be altered.");
        }
        try {
            this.maprfs_.modifyColumnFamily(tablePath, familyName, this.helper_.getColumnFamilyAttr(true, familyName, familyDesc));
        }
        catch (IOException e) {
            if (e instanceof ErrnoException) {
                switch (((ErrnoException)e).getErrno()) {
                    case 2: {
                        throw new FamilyNotFoundException(tablePath, familyName, e);
                    }
                    case 17: {
                        throw new FamilyExistsException(tablePath, familyDesc, e);
                    }
                }
            }
            throw ExceptionHandler.handle(e, "alterFamily()");
        }
    }

    @Override
    public boolean tableExists(String tablePath) throws DBException {
        return this.tableExists(new Path(tablePath));
    }

    @Override
    public boolean tableExists(Path tablePath) throws DBException {
        try {
            TableProperties tableProp = this.maprfs_.getTableProperties(tablePath);
            return tableProp.getAttr().getJson();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "tableExists()");
        }
    }

    @Override
    public TableDescriptor getTableDescriptor(String tablePath) throws DBException {
        return this.getTableDescriptor(new Path(tablePath));
    }

    @Override
    public TableDescriptor getTableDescriptor(Path tablePath) throws DBException {
        try {
            TableProperties props = this.maprfs_.getTableProperties(tablePath);
            List cfAttrs = this.maprfs_.listColumnFamily(tablePath, false);
            return new TableDescriptorImpl(tablePath, cfAttrs, props);
        }
        catch (IOException e) {
            throw new TableNotFoundException(tablePath, e);
        }
    }

    @Override
    public boolean deleteTable(String tablePath) throws DBException {
        return this.deleteTable(new Path(tablePath));
    }

    @Override
    public boolean deleteTable(Path tablePath) throws DBException {
        if (!this.tableExists(tablePath)) {
            return false;
        }
        try {
            return this.maprfs_.delete(tablePath);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "deleteTable()");
        }
    }

    @Deprecated
    public static void createTableForCopy(String replicaPath, String srcPath, List<String> cfList, boolean isBulkload) throws DBException {
        try (AdminImpl admin = new AdminImpl(DEFAULT_CONFIGURATION);){
            if (admin.tableExists(replicaPath)) {
                throw new TableExistsException(replicaPath);
            }
            if (!admin.tableExists(srcPath)) {
                throw new TableNotFoundException(srcPath);
            }
            TableDescriptor desc = MapRDBImpl.newTableDescriptor(replicaPath).addFamily(MapRDBImpl.newDefaultFamilyDescriptor()).setBulkLoad(isBulkload);
            TableDescriptorImpl descImpl = (TableDescriptorImpl)desc;
            descImpl.resetHasSecondaryIndex();
            MapRDBTableImpl srcTable = (MapRDBTableImpl)MapRDBImpl.getTable(srcPath);
            List cfAttrs = srcTable.maprTable().getMapRFS().listColumnFamily(srcTable.maprTable().getTablePath(), false);
            BiMap<FieldPath, Integer> srcIdPathMap = MapRDBTableImplHelper.getCFIdPathMap(cfAttrs);
            if (srcIdPathMap.size() == 0) {
                throw new DBException("Source table has no column families.");
            }
            for (Map.Entry entry : srcIdPathMap.entrySet()) {
                String cfName = srcTable.maprTable().getFamilyName(((Integer)entry.getValue()).intValue());
                if (cfName.equals("default") || cfList.size() != 0 && !cfList.contains(cfName)) continue;
                desc.addFamily(MapRDBImpl.newFamilyDescriptor(cfName, ((FieldPath)entry.getKey()).asPathString()));
            }
            srcTable.close();
            admin.createTable(desc, false);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "createTableForCopy()");
        }
    }

    @Override
    public Collection<IndexDesc> getTableIndexes(String tablePath) throws DBException {
        return this.getTableIndexes(new Path(tablePath));
    }

    @Override
    public Collection<IndexDesc> getTableIndexes(Path tablePath) throws DBException {
        return this.getTableIndexes(tablePath, false);
    }

    public Collection<IndexDesc> getTableIndexes(Path tablePath, boolean refreshNow) throws DBException {
        return this.helper_.getTableIndexes(tablePath, refreshNow);
    }
}

