/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValuePair;
import com.mapr.db.rowcol.KeyValueSizeDescriptor;
import com.mapr.db.rowcol.RootTimeDescriptor;
import com.mapr.db.rowcol.RowcolType;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.db.util.ByteBufferToStringHashMap;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;
import org.ojai.util.impl.MutableFieldSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueDeserializeHelper {
    private static final Logger logger = LoggerFactory.getLogger(KeyValueDeserializeHelper.class);
    private static final ThreadLocal<ByteBufferToStringHashMap> fieldCacheThreadLocal = new ThreadLocal();
    private static ThreadLocal<KeyValuePair> threadLocalKVPair = new ThreadLocal<KeyValuePair>(){

        @Override
        protected KeyValuePair initialValue() {
            return new KeyValuePair();
        }
    };

    private static final ByteBufferToStringHashMap getThreadLocalFieldCache() {
        ByteBufferToStringHashMap fieldCache = fieldCacheThreadLocal.get();
        if (fieldCache == null) {
            fieldCache = new ByteBufferToStringHashMap();
            fieldCacheThreadLocal.set(fieldCache);
            logger.debug("Created a new field-cache for thread: " + Thread.currentThread().toString());
        } else {
            logger.trace("fetch a fieldcache threadlocal");
        }
        return fieldCache;
    }

    public static Value.Type getType(ByteBuffer input) {
        byte rowColType = input.get();
        if (rowColType == 0) {
            return null;
        }
        Value.Type type = RowcolType.valueType(rowColType & 0x1F);
        return type;
    }

    private static DocumentReader.EventType getReaderEventFromType(Value.Type type, boolean start) {
        switch (type) {
            case ARRAY: {
                return start ? DocumentReader.EventType.START_ARRAY : DocumentReader.EventType.END_ARRAY;
            }
            case MAP: {
                return start ? DocumentReader.EventType.START_MAP : DocumentReader.EventType.END_MAP;
            }
            case NULL: {
                return DocumentReader.EventType.NULL;
            }
            case BOOLEAN: {
                return DocumentReader.EventType.BOOLEAN;
            }
            case STRING: {
                return DocumentReader.EventType.STRING;
            }
            case BYTE: {
                return DocumentReader.EventType.BYTE;
            }
            case SHORT: {
                return DocumentReader.EventType.SHORT;
            }
            case INT: {
                return DocumentReader.EventType.INT;
            }
            case LONG: {
                return DocumentReader.EventType.LONG;
            }
            case FLOAT: {
                return DocumentReader.EventType.FLOAT;
            }
            case DOUBLE: {
                return DocumentReader.EventType.DOUBLE;
            }
            case DECIMAL: {
                return DocumentReader.EventType.DECIMAL;
            }
            case DATE: {
                return DocumentReader.EventType.DATE;
            }
            case TIME: {
                return DocumentReader.EventType.TIME;
            }
            case TIMESTAMP: {
                return DocumentReader.EventType.TIMESTAMP;
            }
            case INTERVAL: {
                return DocumentReader.EventType.INTERVAL;
            }
            case BINARY: {
                return DocumentReader.EventType.BINARY;
            }
        }
        throw new TypeException("Unknown type " + type);
    }

    private static MutableFieldSegment getMutableFieldSegment(String fieldName, int index) {
        if (fieldName != null) {
            return new MutableFieldSegment(fieldName);
        }
        return new MutableFieldSegment(index);
    }

    public static void deserializeWithoutKeyValue(SerializationContext context, ByteBuffer input) {
        if (context.isRoot()) {
            context.setNewRecord(false);
            RootTimeDescriptor.deserialize(input, context);
            TimeDescriptor.deserialize(null, input, context, true);
        }
        Value.Type type = KeyValueDeserializeHelper.getType(input);
        context.setType(type);
        if (type == null) {
            return;
        }
        int numBitsForValue = context.isArrayElement() ? 8 : KeyValueSizeDescriptor.valueSizeBitsForType(type);
        context.setNumBitsForValue(numBitsForValue);
        context.setKeyValueSize(input);
        TimeDescriptor.deserialize(null, input, context);
        if (context.isArrayElement()) {
            ArrayIndexDescriptor.deserialize(null, input, context);
        } else {
            int[] kvOrder = KeyValueSizeDescriptor.decodeKeyValueSize(0, input);
            context.setOrderInMap(kvOrder[0]);
        }
    }

    public static boolean deserializeNextKeyValue(boolean isArrayElement, int[] assocArrIdx, KeyValue parentKv, SerializationContext context, ByteBuffer input, KeyValuePair kvPair) {
        KeyValue kv = null;
        String key = null;
        Value.Type type = null;
        ByteBufferToStringHashMap fieldCache_ = KeyValueDeserializeHelper.getThreadLocalFieldCache();
        do {
            byte rowColType;
            if ((rowColType = input.get()) == 0) {
                return false;
            }
            type = RowcolType.valueType(rowColType & 0x1F);
            if (type == Value.Type.MAP) {
                kv = new DBDocumentImpl();
            } else if (type == Value.Type.ARRAY) {
                kv = new DBList(InsertContext.OpType.NONE);
            } else {
                kv = context.newKeyValue();
                kv.type_ = type.getCode();
            }
            kv.setIsArrayElement(isArrayElement);
            rowColType = (byte)(rowColType >> 5 & 7);
            kv.opType = (byte)(InsertContext.OpType.valueOf(rowColType).ordinal() & 0xFF);
            int numBitsForValue = isArrayElement ? 8 : KeyValueSizeDescriptor.valueSizeBitsForType(type);
            int[] keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(numBitsForValue, input);
            TimeDescriptor.deserialize(kv, input, context);
            int arrIndex = -1;
            if (isArrayElement) {
                ArrayIndexDescriptor.deserialize(kv, input, context);
                if (context.getIndexType() == ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE) {
                    int n = assocArrIdx[0];
                    assocArrIdx[0] = n + 1;
                    kv.setOrderOfField(n);
                }
                arrIndex = kv.getOrderOfField();
            } else {
                assert (arrIndex == -1);
                KeyValueDeserializeHelper.deserializeOrderOfField(kv, input);
                key = fieldCache_.get(input, keyValueSize[0]);
            }
            if (context.shouldPrunePaths()) {
                context.moveToNextField(KeyValueDeserializeHelper.getMutableFieldSegment(key, arrIndex), KeyValueDeserializeHelper.getReaderEventFromType(type, true));
            }
            context.setNewRecord(false);
            KeyValueDeserializeHelper.deserializeValue(key, kv, input, context, keyValueSize[1]);
        } while (!context.shouldIncludeField());
        kvPair.setKey(key);
        kvPair.setValue(kv);
        return true;
    }

    private static void deserializeOrderOfField(KeyValue kv, ByteBuffer input) {
        int[] keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(0, input);
        kv.setOrderOfField(keyValueSize[0]);
    }

    private static void deserializeValue(String key, KeyValue kv, ByteBuffer input, SerializationContext context, int valueSize) {
        Value.Type type = kv.getType();
        switch (type) {
            case ARRAY: {
                KeyValueDeserializeHelper.deserializeArrayValues(kv, context, input);
                break;
            }
            case MAP: {
                KeyValueDeserializeHelper.deserializeMap(kv, context, input);
                break;
            }
            case BINARY: {
                byte[] bytes = new byte[valueSize];
                input.get(bytes);
                ByteBuffer b = ByteBuffer.wrap(bytes);
                kv.objValue = b;
                return;
            }
            case NULL: {
                return;
            }
            case BOOLEAN: {
                kv.primValue = valueSize;
                return;
            }
            case BYTE: {
                kv.primValue = input.get();
                return;
            }
            case DECIMAL: {
                kv.objValue = BigDecimalSizeDescriptor.deSerialize(input);
                return;
            }
            case LONG: 
            case DOUBLE: {
                kv.primValue = input.getLong();
                return;
            }
            case INT: 
            case FLOAT: {
                kv.primValue = input.getInt();
                return;
            }
            case SHORT: {
                kv.primValue = input.getShort();
                return;
            }
            case STRING: {
                String v = Bytes.toString((ByteBuffer)input, (int)valueSize);
                kv.objValue = v;
                return;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVAL: {
                kv.primValue = KeyValueDeserializeHelper.deserializeVarLong(valueSize, input);
                return;
            }
            default: {
                throw new TypeException("Unknown type " + kv.getType());
            }
        }
        if (context.shouldPrunePaths()) {
            context.moveToNextField(KeyValueDeserializeHelper.getMutableFieldSegment(key, kv.isArrayElement() ? kv.getOrderOfField() : -1), KeyValueDeserializeHelper.getReaderEventFromType(type, false));
        }
    }

    public static long deserializeVarLong(int valueSize, ByteBuffer input) {
        switch (valueSize) {
            case 0: {
                return 0L;
            }
            case 1: {
                return (long)input.get() & 0xFFL;
            }
            case 2: {
                return (long)input.getShort() & 0xFFFFL;
            }
            case 4: {
                return (long)input.getInt() & 0xFFFFFFFFL;
            }
            case 8: {
                return input.getLong();
            }
        }
        throw new IllegalArgumentException("Invalid size in serialize " + valueSize);
    }

    private static void deserializeMap(KeyValue kv, SerializationContext context, ByteBuffer input) {
        DBDocumentImpl rec = (DBDocumentImpl)kv;
        KeyValuePair value = threadLocalKVPair.get();
        TimeAndUniq savedBaseTs = context.getBaseTime();
        while (KeyValueDeserializeHelper.deserializeNextKeyValue(false, null, kv, context, input, value)) {
            rec.map.put(value.getKey(), value.getValue());
        }
        context.setBaseTime(savedBaseTs);
    }

    private static void deserializeArrayValues(KeyValue kv, SerializationContext context, ByteBuffer input) {
        DBList rec = (DBList)kv;
        KeyValuePair kvPair = threadLocalKVPair.get();
        TimeAndUniq savedBaseTs = context.getBaseTime();
        int[] assocArrIdx = new int[]{0};
        while (KeyValueDeserializeHelper.deserializeNextKeyValue(true, assocArrIdx, kv, context, input, kvPair)) {
            KeyValue value = kvPair.getValue();
            if (value.getArrayIndexType() == ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE) {
                int index = value.getOrderOfField();
                while (rec.list.size() < index) {
                    rec.addNullToList();
                }
                context.setHasArrayProjection();
                value.setArrayIndexType(ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE);
            }
            rec.list.add(value);
        }
        context.setBaseTime(savedBaseTs);
    }
}

