/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.exceptions.IllegalFieldnameException;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.SerializationContext;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;

public class Validators {
    public static void validateSupportedDBTypes(KeyValue value) {
        Value.Type t = value.getType();
        if (t == Value.Type.DECIMAL || t == Value.Type.INTERVAL) {
            throw new UnsupportedOperationException("BigDecimal and Interval type not supported");
        }
    }

    public static void checkForArrayNotation(FieldPath fp) {
        for (FieldSegment curSegment = fp.getRootSegment(); curSegment != null; curSegment = curSegment.getChild()) {
            if (!curSegment.isIndexed() || curSegment.getIndexSegment().hasIndex()) continue;
            throw new IllegalArgumentException("[] cannot be used to get/set/delete a value in a Document");
        }
    }

    static void validateFieldForRowColSerialization(String fieldName, KeyValue kv, SerializationContext context) {
        if (context.isCheckFieldName() && fieldName != null && fieldName.charAt(0) == '$') {
            throw new IllegalFieldnameException(fieldName, "Field name starting with '$' are reserved for system defined field.");
        }
    }
}

