/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.util.IndexKeyCompValueCombinationsGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ojai.Document;

public final class DocumentProjectionComparator {
    private static List<String> emptyIndexFieldPaths_ = new ArrayList<String>();
    private List<String> indexFieldPaths_;
    private List<String> includedFieldPaths_;
    private IndexKeyCompValueCombinationsGenerator ikcvcg_;

    public DocumentProjectionComparator(List<String> indexFieldPaths, List<String> includedFieldPaths) {
        this.indexFieldPaths_ = indexFieldPaths;
        this.includedFieldPaths_ = includedFieldPaths;
        this.ikcvcg_ = new IndexKeyCompValueCombinationsGenerator(indexFieldPaths, includedFieldPaths);
    }

    public IndexKeyCompValueCombinationsGenerator.IndexKeyComponentValueCombinations getIndexKeyComponentValueCombinations(Document doc) {
        return this.ikcvcg_.getIndexKeyComponentValueCombinations(doc);
    }

    public int match(Document d, List<Document> l) {
        ArrayList<Object[]> vcl = new ArrayList<Object[]>();
        for (Document doc : l) {
            for (Object[] vc : this.ikcvcg_.getIndexKeyComponentValueCombinations(doc)) {
                vcl.add((Object[])vc.clone());
            }
        }
        for (Object[] vc : this.ikcvcg_.getIndexKeyComponentValueCombinations(d)) {
            if (this.removeElement(vcl, vc)) continue;
            return -1;
        }
        return vcl.size();
    }

    private boolean removeElement(List<Object[]> l, Object[] e) {
        int i = 0;
        for (Object[] ol : l) {
            if (Arrays.equals(ol, e)) {
                l.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean matchIncluded(Document d, Document iDoc) {
        Object[] vc;
        IndexKeyCompValueCombinationsGenerator tmp = new IndexKeyCompValueCombinationsGenerator(emptyIndexFieldPaths_, this.includedFieldPaths_);
        Object[] priValues = null;
        Object[] iValues = null;
        Iterator<Object[]> iterator = tmp.getIndexKeyComponentValueCombinations(d).iterator();
        while (iterator.hasNext()) {
            priValues = vc = iterator.next();
        }
        iterator = tmp.getIndexKeyComponentValueCombinations(iDoc).iterator();
        while (iterator.hasNext()) {
            iValues = vc = iterator.next();
        }
        return priValues == null || iValues == null ? priValues == null && iValues == null : Arrays.equals(priValues, iValues);
    }

    public Object[] getIndexFieldsPreprocessedForConditionGeneration() {
        return this.ikcvcg_.getIndexFieldsPreprocessedForConditionGeneration();
    }
}

