/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.IOHelper;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.exceptions.UnimplementedFeatureException;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XdmSequence;
import com.marklogic.xcc.types.XdmValue;
import com.marklogic.xcc.types.XdmVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RequestImpl
implements Request {
    private final Session session;
    private RequestOptions options;
    private Map<XName, XdmVariable[]> variables = new HashMap<XName, XdmVariable[]>();
    private long position = 1L;
    private long count = Long.MAX_VALUE;

    public RequestImpl(Session session, RequestOptions options) {
        this.session = session;
        this.setOptions(options);
    }

    abstract void urlEncodeXQueryString(StringBuffer var1, Logger var2);

    abstract String serverPath();

    abstract String requestVar();

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setOptions(RequestOptions options) {
        this.options = options == null ? new RequestOptions() : options;
    }

    @Override
    public RequestOptions getOptions() {
        return this.options;
    }

    @Override
    public RequestOptions getEffectiveOptions() {
        RequestOptions eff = new RequestOptions();
        RequestOptions req = this.getOptions();
        RequestOptions ses = this.getSession().getDefaultRequestOptions();
        eff.applyEffectiveValues(new RequestOptions[]{ses, req});
        return eff;
    }

    @Override
    public void setVariable(XdmVariable variable) {
        XdmValue value = variable.getValue();
        if (value instanceof XdmSequence) {
            throw new UnimplementedFeatureException("Setting variables that are sequences is not supported");
        }
        this.clearVariable(variable);
        XdmVariable[] vars = new XdmVariable[]{variable};
        this.variables.put(variable.getName(), vars);
    }

    @Override
    public XdmVariable setNewVariable(XName xname, XdmValue value) {
        XdmVariable variable = ValueFactory.newVariable(xname, value);
        this.setVariable(variable);
        return variable;
    }

    @Override
    public void setNewVariables(XName xname, XdmValue[] values) {
        this.clearVariables(xname);
        XdmVariable[] vars = new XdmVariable[values.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = ValueFactory.newVariable(xname, values[i]);
        }
        if (vars.length == 0) {
            vars = new XdmVariable[]{ValueFactory.newVariable(xname, ValueFactory.newJSNull())};
        }
        this.variables.put(xname, vars);
    }

    @Override
    public XdmVariable setNewVariable(String namespace, String localname, ValueType type, Object value) {
        return this.setNewVariable(new XName(namespace, localname), ValueFactory.newValue(type, value));
    }

    @Override
    public void setNewVariables(String namespace, String localname, ValueType type, Object[] values) {
        XName name = new XName(namespace, localname);
        this.clearVariables(name);
        XdmVariable[] vars = new XdmVariable[values.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = ValueFactory.newVariable(name, ValueFactory.newValue(type, values[i]));
        }
        if (vars.length == 0) {
            vars = new XdmVariable[]{ValueFactory.newVariable(name, ValueFactory.newJSNull())};
        }
        this.variables.put(name, vars);
    }

    @Override
    public XdmVariable setNewVariable(String localname, ValueType type, Object value) {
        return this.setNewVariable(null, localname, type, value);
    }

    @Override
    public void setNewVariables(String localname, ValueType type, Object[] values) {
        XName name = new XName(null, localname);
        this.clearVariables(name);
        XdmVariable[] vars = new XdmVariable[values.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = ValueFactory.newVariable(name, ValueFactory.newValue(type, values[i]));
        }
        if (vars.length == 0) {
            vars = new XdmVariable[]{ValueFactory.newVariable(name, ValueFactory.newJSNull())};
        }
        this.variables.put(name, vars);
    }

    @Override
    public XdmVariable setNewStringVariable(String namespace, String localname, String value) {
        return this.setNewVariable(namespace, localname, ValueType.XS_STRING, value);
    }

    @Override
    public XdmVariable setNewStringVariable(String localname, String value) {
        return this.setNewStringVariable(null, localname, value);
    }

    @Override
    public XdmVariable setNewIntegerVariable(String namespace, String localname, long value) {
        return this.setNewVariable(namespace, localname, ValueType.XS_INTEGER, new Long(value));
    }

    @Override
    public XdmVariable setNewIntegerVariable(String localname, long value) {
        return this.setNewIntegerVariable(null, localname, value);
    }

    @Override
    public void clearVariable(XdmVariable variable) {
        this.variables.remove(variable.getName());
    }

    public void clearVariables(XName varName) {
        this.variables.remove(varName);
    }

    @Override
    public void clearVariables() {
        this.variables.clear();
    }

    @Override
    public XdmVariable[] getVariables() {
        ArrayList<XdmVariable> varList = new ArrayList<XdmVariable>();
        for (XdmVariable[] vars : this.variables.values()) {
            for (XdmVariable var : vars) {
                varList.add(var);
            }
        }
        XdmVariable[] vars = new XdmVariable[varList.size()];
        return varList.toArray(vars);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(long position) {
        this.position = position;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    String encodedQueryString(Logger logger) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.requestVar()).append("=");
        this.urlEncodeXQueryString(sb, logger);
        this.encodeQueryOptions(sb, null);
        this.encodeQueryVariables(sb, logger);
        this.encodePositionRange(sb);
        this.encodeTxn(sb);
        String payload = sb.toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Eval request POST payload: '" + payload + "'");
        }
        return payload;
    }

    public void encodeTxn(StringBuffer sb) {
        if (((SessionImpl)this.session).txnID != null) {
            sb.append("&txnid=").append(((SessionImpl)this.session).txnID);
        }
        if (((SessionImpl)this.session).isInCompatibleMode()) {
            return;
        }
        if (this.session.getTransactionMode() != null) {
            sb.append("&txnmode=").append((Object)this.session.getTransactionMode());
        }
        if (this.session.getCachedTxnTimeout() != 0) {
            sb.append("&txntimelimit=").append(this.session.getCachedTxnTimeout());
        }
    }

    private void encodePositionRange(StringBuffer sb) {
        if (this.position > 1L) {
            sb.append("&pos=").append(this.position);
        }
        if (this.count < Long.MAX_VALUE) {
            sb.append("&cnt=").append(this.count);
        }
    }

    public void encodeQueryOptions(StringBuffer sb, RequestOptions requestOptions) {
        RequestOptions options = requestOptions == null ? this.getEffectiveOptions() : requestOptions;
        sb.append("&locale=").append(options.getLocale().toString());
        sb.append("&tzoffset=").append(options.getTimeZone().getOffset(System.currentTimeMillis()) / 1000);
        if (this.session.getContentBaseName() != null) {
            String dbname = this.session.getContentBaseName();
            if (this.isName(dbname)) {
                sb.append("&dbname=");
                IOHelper.urlEncodeToStringBuffer(sb, this.session.getContentBaseName());
            } else {
                sb.append("&dbid=").append(dbname.substring(1));
            }
        }
        if (options.getEffectivePointInTime() != null) {
            sb.append("&timestamp=").append(options.getEffectivePointInTime().toString());
        }
        if (options.getRequestName() != null) {
            sb.append("&requestname=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getRequestName());
        }
        if (options.getDefaultXQueryVersion() != null) {
            sb.append("&defaultxquery=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getDefaultXQueryVersion());
        }
        if (options.getRequestTimeLimit() != -1) {
            sb.append("&timelimit=").append(options.getRequestTimeLimit());
        }
    }

    private void encodeQueryVariables(StringBuffer sb, Logger logger) {
        XdmVariable[] vars = this.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            XdmVariable var = vars[i];
            XName xname = var.getName();
            XdmValue value = var.getValue();
            sb.append("&evn").append(i).append("=");
            if (xname.getNamespace() != null) {
                sb.append(xname.getNamespace());
            }
            sb.append("&evl").append(i).append("=").append(xname.getLocalname());
            sb.append("&evt").append(i).append("=");
            IOHelper.urlEncodeToStringBuffer(sb, value.getValueType().toString());
            sb.append("&evv").append(i).append("=");
            IOHelper.urlEncodeToStringBuffer(sb, value.asString());
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest(" ev" + i + ": " + xname.toString() + "(" + value.getValueType() + ") " + value.toString());
        }
    }

    protected boolean isName(String name) {
        if (name.length() == 0) {
            return true;
        }
        return name.charAt(0) != '#';
    }
}

