/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ContentWithFileNameWritable;
import com.marklogic.contentpump.ImportRecordReader;
import com.marklogic.contentpump.utilities.FileIterator;
import com.marklogic.contentpump.utilities.IdGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class AggregateXMLReader<VALUEIN>
extends ImportRecordReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(AggregateXMLReader.class);
    public static String DEFAULT_NS = null;
    private int currDepth = 0;
    protected XMLStreamReader xmlSR;
    protected String recordName;
    protected String recordNamespace;
    private int recordDepth = Integer.MAX_VALUE;
    private StringBuilder buffer;
    protected String idName;
    protected String currentId = null;
    private boolean keepGoing = true;
    protected HashMap<String, Stack<String>> nameSpaces = new HashMap();
    protected boolean startOfRecord = true;
    protected boolean hasNext = true;
    private boolean newDoc = false;
    private boolean newUriId = false;
    protected boolean useAutomaticId = false;
    protected String mode;
    protected IdGenerator idGen;
    protected XMLInputFactory f;
    protected FSDataInputStream fInputStream;
    protected long start;
    protected long pos;
    protected boolean overflow;
    protected long end;
    protected boolean compressed = false;

    @Override
    public void close() throws IOException {
        if (this.xmlSR != null) {
            try {
                this.xmlSR.close();
            }
            catch (XMLStreamException e) {
                LOG.error((Object)"Error closing stream reader", (Throwable)e);
            }
        }
        if (this.fInputStream != null) {
            this.fInputStream.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        if (!this.hasNext) {
            return 1.0f;
        }
        return this.pos > this.end ? 1.0f : (float)(this.pos - this.start) / (float)(this.end - this.start);
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.initAggConf(context);
        this.f = XMLInputFactory.newInstance();
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(context.getConfiguration());
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initStreamReader(inSplit);
    }

    protected void initStreamReader(InputSplit inSplit) throws IOException, InterruptedException {
        this.start = 0L;
        this.end = inSplit.getLength();
        this.overflow = false;
        this.fInputStream = this.openFile(inSplit, true);
        if (this.fInputStream == null) {
            return;
        }
        try {
            this.xmlSR = this.f.createXMLStreamReader((InputStream)this.fInputStream, this.encoding);
        }
        catch (XMLStreamException e) {
            LOG.error((Object)"ParseError");
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.useAutomaticId) {
            this.idGen = new IdGenerator(this.file.toUri().getPath() + "-" + ((FileSplit)inSplit).getStart());
        }
    }

    protected void initAggConf(TaskAttemptContext context) {
        Configuration conf = context.getConfiguration();
        this.idName = conf.get("mapreduce.marklogic.input.uriid");
        if (this.idName == null) {
            this.useAutomaticId = true;
        }
        this.recordName = conf.get("mapreduce.marklogic.aggregate.recordelement");
        this.recordNamespace = conf.get("mapreduce.marklogic.aggregate.recordnamespace");
    }

    private void write(String str) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        if (this.newDoc && this.currDepth >= this.recordDepth) {
            this.buffer.append(str);
        }
    }

    protected void copyNameSpaceDecl() {
        if (this.recordDepth < this.currDepth) {
            return;
        }
        int stop = this.xmlSR.getNamespaceCount();
        if (stop > 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"checking namespace declarations");
            }
            for (int i = 0; i < stop; ++i) {
                String nsDeclPrefix = this.xmlSR.getNamespacePrefix(i);
                String nsDeclUri = this.xmlSR.getNamespaceURI(i);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(nsDeclPrefix + ":" + nsDeclUri));
                }
                if (this.nameSpaces.containsKey(nsDeclPrefix)) {
                    this.nameSpaces.get(nsDeclPrefix).push(nsDeclUri);
                    continue;
                }
                Stack<String> s = new Stack<String>();
                s.push(nsDeclUri);
                this.nameSpaces.put(nsDeclPrefix, s);
            }
        }
    }

    protected void removeNameSpaceDecl() {
        if (this.recordDepth < this.currDepth) {
            return;
        }
        int stop = this.xmlSR.getNamespaceCount();
        if (stop > 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"checking namespace declarations");
            }
            for (int i = 0; i < stop; ++i) {
                String nsDeclPrefix = this.xmlSR.getNamespacePrefix(i);
                if (this.nameSpaces.containsKey(nsDeclPrefix)) {
                    if (this.nameSpaces.get(nsDeclPrefix).isEmpty()) continue;
                    this.nameSpaces.get(nsDeclPrefix).pop();
                    continue;
                }
                LOG.warn((Object)("Namespace " + nsDeclPrefix + " not in scope"));
            }
        }
    }

    private void processStartElement() throws XMLStreamException {
        String prefix;
        String name = this.xmlSR.getLocalName();
        String namespace = this.xmlSR.getNamespaceURI();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Start-tag: " + this.xmlSR.getName() + " at depth " + this.currDepth));
        }
        if ("".equals(namespace)) {
            namespace = null;
        }
        if (namespace == null) {
            prefix = this.xmlSR.getPrefix();
            if ("".equals(prefix)) {
                prefix = DEFAULT_NS;
            }
            if (this.nameSpaces.get(prefix) != null) {
                namespace = this.nameSpaces.get(prefix).peek();
            }
        }
        prefix = this.xmlSR.getPrefix();
        int attrCount = this.xmlSR.getAttributeCount();
        boolean isNewRootStart = false;
        ++this.currDepth;
        Location loc = this.xmlSR.getLocation();
        if (this.recordName == null) {
            this.recordName = name;
            if (this.recordNamespace == null) {
                this.recordNamespace = namespace;
            }
            this.recordDepth = this.currDepth;
            isNewRootStart = true;
            this.newDoc = true;
            this.newUriId = true;
            if (this.useAutomaticId) {
                this.setKey(this.idGen.incrementAndGet(), loc.getLineNumber(), loc.getColumnNumber(), true);
            }
        } else if (name.equals(this.recordName) && (this.recordNamespace == null && namespace == null || this.recordNamespace != null && this.recordNamespace.equals(namespace))) {
            this.recordDepth = this.currDepth;
            isNewRootStart = true;
            this.newDoc = true;
            this.newUriId = true;
            if (this.useAutomaticId) {
                this.setKey(this.idGen.incrementAndGet(), loc.getLineNumber(), loc.getColumnNumber(), true);
            }
        }
        this.copyNameSpaceDecl();
        if (!this.newDoc) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        if (prefix != null && !prefix.equals("")) {
            sb.append(prefix + ":" + name);
        } else {
            sb.append(name);
        }
        if (isNewRootStart) {
            Set<String> keys = this.nameSpaces.keySet();
            for (String k : keys) {
                String v = this.nameSpaces.get(k).peek();
                if (DEFAULT_NS == k || "".equals(k)) {
                    sb.append(" xmlns=\"" + v + "\"");
                    continue;
                }
                sb.append(" xmlns:" + k + "=\"" + v + "\"");
            }
        } else {
            int stop = this.xmlSR.getNamespaceCount();
            if (stop > 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"checking namespace declarations");
                }
                for (int i = 0; i < stop; ++i) {
                    String nsDeclPrefix = this.xmlSR.getNamespacePrefix(i);
                    String nsDeclUri = this.xmlSR.getNamespaceURI(i);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(nsDeclPrefix + ":" + nsDeclUri));
                    }
                    if (DEFAULT_NS == nsDeclPrefix) {
                        sb.append(" xmlns=\"" + nsDeclUri + "\"");
                        continue;
                    }
                    sb.append(" xmlns:" + nsDeclPrefix + "=\"" + nsDeclUri + "\"");
                }
            }
        }
        for (int i = 0; i < attrCount; ++i) {
            String aPrefix = this.xmlSR.getAttributePrefix(i);
            String aName = this.xmlSR.getAttributeLocalName(i);
            String aValue = StringEscapeUtils.escapeXml10((String)this.xmlSR.getAttributeValue(i));
            sb.append(" " + (null == aPrefix || "".equals(aPrefix) ? "" : aPrefix + ":") + aName + "=\"" + aValue + "\"");
            if (this.useAutomaticId || !this.newDoc || !("@" + aName).equals(this.idName) || this.currentId != null) continue;
            this.currentId = aValue;
            this.setKey(aValue, loc.getLineNumber(), loc.getColumnNumber(), true);
        }
        sb.append(">");
        if (!this.useAutomaticId && this.newDoc && name.equals(this.idName)) {
            int nextToken = this.xmlSR.next();
            if (nextToken != 4) {
                throw new XMLStreamException("badly formed xml or " + this.idName + " is not a simple node: at" + this.xmlSR.getLocation());
            }
            do {
                String idStr = StringEscapeUtils.escapeXml10((String)this.xmlSR.getText());
                if (this.currentId == null) {
                    this.currentId = "";
                }
                this.currentId = this.currentId + idStr;
                sb.append(idStr);
            } while ((nextToken = this.xmlSR.next()) == 4);
            if (this.newUriId) {
                this.setKey(this.currentId, loc.getLineNumber(), loc.getColumnNumber(), true);
                this.newUriId = false;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Duplicate URI_ID match found: key = " + this.key));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("URI_ID: " + this.currentId));
            }
            if (nextToken != 2) {
                throw new XMLStreamException("badly formed xml: no END_TAG after id text" + this.xmlSR.getLocation());
            }
            sb.append("</");
            if (prefix != null && !prefix.equals("")) {
                sb.append(prefix + ":" + name);
            } else {
                sb.append(name);
            }
            sb.append(">");
            --this.currDepth;
        }
        this.write(sb.toString());
    }

    private boolean processEndElement() throws XMLStreamException {
        String prefix;
        String name = this.xmlSR.getLocalName();
        String namespace = this.xmlSR.getNamespaceURI();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("End-tag: " + this.xmlSR.getName() + " at depth " + this.currDepth));
        }
        if ("".equals(namespace)) {
            namespace = null;
        }
        if (namespace == null) {
            prefix = this.xmlSR.getPrefix();
            if ("".equals(prefix)) {
                prefix = DEFAULT_NS;
            }
            if (this.nameSpaces.get(prefix) != null && !this.nameSpaces.get(prefix).isEmpty()) {
                namespace = this.nameSpaces.get(prefix).peek();
            }
        }
        prefix = this.xmlSR.getPrefix();
        StringBuilder sb = new StringBuilder();
        sb.append("</");
        if (prefix != null && prefix != "") {
            sb.append(prefix + ":" + name);
        } else {
            sb.append(name);
        }
        sb.append(">");
        this.write(sb.toString());
        if (!(this.newDoc && name.equals(this.recordName) && (this.recordNamespace == null && namespace == null || this.recordNamespace != null && this.recordNamespace.equals(namespace)))) {
            if (this.currDepth == 1) {
                this.cleanupEndElement();
            } else {
                this.removeNameSpaceDecl();
                --this.currDepth;
            }
            return true;
        }
        if (!this.useAutomaticId && null == this.currentId && this.newDoc) {
            LOG.error((Object)("end of record element " + name + " with no id found: " + "aggregate_uri_id" + "=" + this.idName));
            this.cleanupEndElement();
            return true;
        }
        if (this.value instanceof Text) {
            ((Text)this.value).set(this.buffer.toString());
        } else {
            ((Text)((ContentWithFileNameWritable)this.value).getValue()).set(this.buffer.toString());
        }
        this.cleanupEndElement();
        return false;
    }

    protected void cleanupEndElement() {
        this.currentId = null;
        this.newDoc = false;
        this.buffer.setLength(0);
        this.removeNameSpaceDecl();
        --this.currDepth;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[UNCONDITIONALDOLOOP]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

