/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ContentPump;
import com.marklogic.contentpump.MultithreadedMapper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Mapper;

public class BaseMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    public static final Log LOG = LogFactory.getLog(BaseMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runThreadSafe(Mapper.Context outerCtx, Mapper.Context subCtx, MultithreadedMapper.MapRunner runner) throws IOException, InterruptedException {
        this.setup(subCtx);
        Object key = null;
        Object value = null;
        try {
            while (!ContentPump.shutdown && !runner.getShutdown()) {
                Mapper.Context context = outerCtx;
                synchronized (context) {
                    if (!subCtx.nextKeyValue()) {
                        break;
                    }
                    key = subCtx.getCurrentKey();
                    value = subCtx.getCurrentValue();
                }
                this.map(key, value, subCtx);
            }
        }
        finally {
            if (ContentPump.shutdown && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Aborting task...");
            }
            this.cleanup(subCtx);
        }
    }

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.setup(context);
        try {
            while (!ContentPump.shutdown && context.nextKeyValue()) {
                this.map(context.getCurrentKey(), context.getCurrentValue(), context);
            }
        }
        finally {
            if (ContentPump.shutdown && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Aborting task...");
            }
            this.cleanup(context);
        }
    }
}

