/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import java.text.NumberFormat;
import java.text.ParseException;

public enum ColumnDataType {
    STRING{

        @Override
        public Object parse(String s) throws Exception {
            return new String(s);
        }
    }
    ,
    NUMBER{

        @Override
        public Object parse(String s) throws Exception {
            s.trim();
            if ("".equals(s)) {
                throw new Exception("missing value");
            }
            return NumberFormat.getInstance().parse(s);
        }
    }
    ,
    BOOLEAN{

        @Override
        public Object parse(String s) throws Exception {
            s.trim();
            if ("".equals(s)) {
                throw new Exception("missing value");
            }
            if (!"true".equalsIgnoreCase(s) && !"false".equalsIgnoreCase(s)) {
                throw new ParseException("", 0);
            }
            return new Boolean(s);
        }
    };


    public abstract Object parse(String var1) throws Exception;
}

