/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.CombineDocumentSplit;
import com.marklogic.contentpump.ImportRecordReader;
import com.marklogic.contentpump.utilities.FileIterator;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CombineDocumentReader<VALUEIN>
extends ImportRecordReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(CombineDocumentReader.class);
    protected long bytesRead;
    protected long bytesTotal;
    protected TaskAttemptContext context;
    protected int batchSize;

    @Override
    public void close() throws IOException {
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.bytesRead > this.bytesTotal ? 1.0f : (float)this.bytesRead / (float)this.bytesTotal;
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.iterator = new FileIterator(((CombineDocumentSplit)inSplit).getSplits().iterator(), context);
        this.bytesTotal = inSplit.getLength();
        this.context = context;
        this.batchSize = this.conf.getInt("mapreduce.marklogic.output.batchsize", 100);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.iterator.hasNext()) {
            FSDataInputStream fileIn;
            FileSplit split = (FileSplit)this.iterator.next();
            if (split == null) continue;
            this.setFile(split.getPath());
            String uri = this.makeURIFromPath(this.file);
            FileSystem fs = this.file.getFileSystem(this.context.getConfiguration());
            try {
                fileIn = fs.open(this.file);
            }
            catch (IllegalArgumentException e) {
                this.setSkipKey(0, 0, e.getMessage());
                return true;
            }
            long splitLength = split.getLength();
            if (splitLength > Integer.MAX_VALUE || splitLength * 3L > Integer.MAX_VALUE) {
                this.setSkipKey(0, 0, "file size too large: " + splitLength + ". Use streaming option.");
                return true;
            }
            if (this.setKey(uri, 0, 0, true)) {
                return true;
            }
            byte[] buf = new byte[(int)splitLength];
            try {
                fileIn.readFully(buf);
                if (this.value instanceof Text) {
                    ((Text)this.value).set(new String(buf, this.encoding));
                } else if (this.batchSize > 1) {
                    this.value = new BytesWritable(buf);
                } else {
                    ((BytesWritable)this.value).set(buf, 0, buf.length);
                }
                this.bytesRead += (long)buf.length;
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOG.error((Object)e);
                throw e;
            }
            finally {
                fileIn.close();
            }
        }
        return false;
    }
}

