/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.Command;
import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.InputType;
import com.marklogic.contentpump.LocalJob;
import com.marklogic.contentpump.LocalJobRunner;
import com.marklogic.contentpump.Versions;
import com.marklogic.contentpump.utilities.AuditUtil;
import com.marklogic.contentpump.utilities.CommandlineOptions;
import com.marklogic.contentpump.utilities.OptionsFileUtil;
import com.marklogic.mapreduce.MarkLogicConstants;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.VersionInfo;

public class ContentPump
implements MarkLogicConstants,
ConfigConstants {
    public static final Log LOG = LogFactory.getLog(ContentPump.class);
    public static volatile boolean shutdown = false;
    static List<Job> jobs = new LinkedList<Job>();

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            ContentPump.printUsage();
            System.exit(1);
        }
        String[] expandedArgs = null;
        int rc = 1;
        try {
            expandedArgs = OptionsFileUtil.expandArguments(args);
            rc = ContentPump.runCommand(expandedArgs);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while expanding arguments", (Throwable)ex);
            System.err.println(ex.getMessage());
            System.err.println("Try 'mlcp help' for usage.");
        }
        System.exit(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runCommand(String[] args) throws IOException {
        String cpHome;
        boolean distributed;
        CommandLine cmdline;
        String cmd = args[0];
        if (cmd.equalsIgnoreCase("help")) {
            ContentPump.printUsage();
            return 1;
        }
        if (cmd.equalsIgnoreCase("version")) {
            ContentPump.logVersions();
            return 1;
        }
        Command command = Command.forName(cmd);
        String[] optionArgs = Arrays.copyOfRange(args, 1, args.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Command: " + command));
            StringBuilder buf = new StringBuilder();
            boolean isPassword = false;
            for (String arg : optionArgs) {
                if (isPassword) {
                    arg = "...";
                    isPassword = false;
                }
                if (arg.matches(".*password")) {
                    isPassword = true;
                }
                buf.append(arg);
                buf.append(' ');
            }
            LOG.debug((Object)("Arguments: " + buf));
        }
        Configuration conf = new Configuration();
        GenericOptionsParser genericParser = new GenericOptionsParser(conf, optionArgs);
        String[] remainingArgs = genericParser.getRemainingArgs();
        CommandlineOptions options = new CommandlineOptions();
        command.configOptions(options);
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse((Options)options, remainingArgs);
        }
        catch (Exception e) {
            LOG.error((Object)"Error parsing command arguments: ");
            LOG.error((Object)e.getMessage());
            command.printUsage(command, options.getPublicOptions());
            return 1;
        }
        String[] e = cmdline.getArgs();
        int n = e.length;
        int n2 = 0;
        if (n2 < n) {
            String arg = e[n2];
            LOG.error((Object)("Unrecognized argument: " + arg));
            command.printUsage(command, options.getPublicOptions());
            return 1;
        }
        String mode = cmdline.getOptionValue("mode");
        if (mode != null && !"distributed".equalsIgnoreCase(mode) && !"local".equalsIgnoreCase(mode)) {
            LOG.error((Object)("Unrecognized option argument for mode: " + mode));
            return 1;
        }
        String hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
        if (cmdline.hasOption("hadoop_conf_dir")) {
            hadoopConfDir = cmdline.getOptionValue("hadoop_conf_dir");
        }
        boolean bl = distributed = hadoopConfDir != null && (mode == null || mode.equalsIgnoreCase("distributed"));
        if ("distributed".equalsIgnoreCase(mode) && !distributed) {
            LOG.error((Object)"Cannot run in distributed mode.  HADOOP_CONF_DIR is not configured.");
        }
        if (distributed) {
            LOG.error((Object)"MLCP distributed mode has been disabled. Please use local mode instead.");
            return 1;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running in: " + (distributed ? "distributed " : "local") + "mode"));
            if (distributed) {
                LOG.debug((Object)("HADOOP_CONF_DIR is set to " + hadoopConfDir));
            }
        }
        conf.set("mapreduce.marklogic.mode", distributed ? "distributed" : "local");
        if (conf.getBoolean("restrict_input_hosts", true) || conf.getBoolean("restrict_output_hosts", true)) {
            System.setProperty("xcc.httpcompliant", "true");
        }
        if (distributed) {
            if (!cmdline.hasOption("split_input") && Command.getInputType(cmdline).equals(InputType.DELIMITED_TEXT)) {
                conf.setBoolean("mapreduce.marklogic.splitinput", true);
            }
            File hdConfDir = new File(hadoopConfDir);
            try {
                ContentPump.checkHadoopConfDir(hdConfDir);
            }
            catch (IllegalArgumentException e2) {
                LOG.error((Object)"Error found with Hadoop home setting", (Throwable)e2);
                System.err.println(e2.getMessage());
                return 1;
            }
            try {
                ContentPump.setClassLoader(hdConfDir, conf);
            }
            catch (Exception e3) {
                LOG.error((Object)"Error configuring class loader", (Throwable)e3);
                System.err.println(e3.getMessage());
                return 1;
            }
        }
        String bundleVersion = System.getProperty("BUNDLE_ARTIFACT");
        if (bundleVersion != null && "mapr".equals(bundleVersion) && (cpHome = System.getProperty("CONTENTPUMP_HOME")) != null) {
            System.setProperty("java.security.auth.login.config", cpHome + "mapr.conf");
        }
        conf.set("mapreduce.jobtracker.address", "local");
        Job job = null;
        try {
            if (distributed) {
                conf.setInt("mapreduce.job.reduces", 0);
                conf.setBoolean("mapreduce.map.speculative", false);
            } else {
                conf.set("mapreduce.job.working.dir", System.getProperty("user.dir"));
            }
            job = command.createJob(conf, cmdline);
            LOG.info((Object)("Job name: " + job.getJobName()));
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return 1;
        }
        Class<ContentPump> e4 = ContentPump.class;
        synchronized (ContentPump.class) {
            jobs.add(job);
            // ** MonitorExit[e] (shouldn't be in output)
            try {
                if (distributed) {
                    ContentPump.submitJob(job);
                } else {
                    ContentPump.runJobLocally((LocalJob)job, cmdline, command);
                }
                return ContentPump.getReturnCode(job.getJobState());
            }
            catch (Exception e5) {
                LOG.error((Object)"Error running a ContentPump job", (Throwable)e5);
                e5.printStackTrace(System.err);
                return 1;
            }
        }
    }

    private static void setClassLoader(File hdConfDir, Configuration conf) throws Exception {
        ClassLoader parent = conf.getClassLoader();
        URL url = hdConfDir.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader classLoader = new URLClassLoader(urls, parent);
        Thread.currentThread().setContextClassLoader(classLoader);
        conf.setClassLoader((ClassLoader)classLoader);
    }

    private static void checkHadoopConfDir(File hdConfDir) throws IllegalArgumentException {
        if (!hdConfDir.exists()) {
            throw new IllegalArgumentException("Hadoop conf dir " + hdConfDir + " is not found.");
        }
        if (!hdConfDir.isDirectory()) {
            throw new IllegalArgumentException("Hadoop conf dir " + hdConfDir + " is not a directory.");
        }
        if (!hdConfDir.canRead()) {
            throw new IllegalArgumentException("Hadoop conf dir " + hdConfDir + " cannot be read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void submitJob(Job job) throws Exception {
        FilenameFilter jobJarFilter;
        String cpHome = System.getProperty("CONTENTPUMP_HOME");
        File cpHomeDir = new File(cpHome);
        File[] cpJars = cpHomeDir.listFiles(jobJarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && name.startsWith("mlcp");
            }
        });
        if (cpJars == null || cpJars.length == 0) {
            throw new RuntimeException("Content Pump jar file is not found under " + cpHome);
        }
        if (cpJars.length > 1) {
            throw new RuntimeException("More than one Content Pump jar file are found under " + cpHome);
        }
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.job.jar", cpJars[0].toURI().toURL().toString());
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !name.startsWith("hadoop");
            }
        };
        StringBuilder jars = new StringBuilder();
        for (File jar : cpHomeDir.listFiles(filter)) {
            if (jars.length() > 0) {
                jars.append(',');
            }
            jars.append(jar.toURI().toURL().toString());
        }
        conf.set("tmpjars", jars.toString());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("LIBJARS:" + jars.toString()));
        }
        job.waitForCompletion(true);
        AuditUtil.auditMlcpFinish(conf, job.getJobName(), job.getCounters());
        Class<ContentPump> clazz = ContentPump.class;
        synchronized (ContentPump.class) {
            jobs.remove(job);
            ContentPump.class.notify();
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runJobLocally(LocalJob job, CommandLine cmdline, Command cmd) throws Exception {
        LocalJobRunner runner = new LocalJobRunner(job, cmdline, cmd);
        runner.run();
        AuditUtil.auditMlcpFinish(job.getConfiguration(), job.getJobName(), runner.getReporter().counters);
        Class<ContentPump> clazz = ContentPump.class;
        synchronized (ContentPump.class) {
            jobs.remove(job);
            ContentPump.class.notify();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static void printUsage() {
        System.out.println("usage: mlcp COMMAND [ARGS]\n");
        System.out.println("Available commands:");
        System.out.println("  IMPORT  import data to a MarkLogic database");
        System.out.println("  EXPORT  export data from a MarkLogic database");
        System.out.println("  COPY    copy data from one MarkLogic database to another");
        System.out.println("  EXTRACT extract data from MarkLogic forests");
        System.out.println("  HELP    list available commands");
        System.out.println("  VERSION print the version");
    }

    public static void logVersions() {
        System.out.println("ContentPump version: " + Versions.getVersion());
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("Hadoop version: " + VersionInfo.getVersion());
        System.out.println("Supported MarkLogic versions: " + Versions.getMinServerVersion() + " - " + Versions.getMaxServerVersion());
    }

    public static int getReturnCode(JobStatus.State state) {
        switch (state) {
            case RUNNING: {
                return -1;
            }
            case SUCCEEDED: {
                return 0;
            }
            case FAILED: {
                return 1;
            }
            case PREP: {
                return 2;
            }
            case KILLED: {
                return 3;
            }
        }
        return 4;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        boolean needToWait() {
            boolean needToWait = false;
            for (Job job : jobs) {
                if (!(job instanceof LocalJob)) continue;
                needToWait = true;
                break;
            }
            return needToWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            shutdown = true;
            System.setProperty("mlcp.shutdown", "1");
            try {
                Class<ContentPump> clazz = ContentPump.class;
                synchronized (ContentPump.class) {
                    boolean needToWait = false;
                    LinkedList<Job> jobList = new LinkedList<Job>();
                    for (Job job : jobs) {
                        if (!(job instanceof LocalJob)) continue;
                        LOG.info((Object)("Aborting job " + job.getJobName()));
                        needToWait = true;
                        jobList.add(job);
                    }
                    if (needToWait) {
                        for (int i = 0; i < 30; ++i) {
                            if (i > 0) {
                                needToWait = this.needToWait();
                            }
                            if (!needToWait) continue;
                            if (i > 0) {
                                LOG.info((Object)("Waiting..." + (30 - i)));
                            }
                            try {
                                ContentPump.class.wait(1000L);
                                continue;
                            }
                            catch (InterruptedException job) {
                                // empty catch block
                            }
                        }
                    }
                    for (Job job : jobs) {
                        LOG.warn((Object)("Job " + job.getJobName() + " status remains " + job.getJobState()));
                        jobList.remove(job);
                    }
                    for (Job job : jobList) {
                        LOG.warn((Object)("Job " + job.getJobName() + " is aborted"));
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error terminating job", (Throwable)e);
            }
            {
                return;
            }
        }
    }
}

