/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.BaseMapper;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicCounter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class DocumentMapper<VALUE>
extends BaseMapper<DocumentURI, VALUE, DocumentURI, VALUE> {
    public static final Log LOG = LogFactory.getLog(DocumentMapper.class);
    protected Counter readCount;
    protected Counter attemptedCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(DocumentURI uri, VALUE fileContent, Mapper.Context context) throws IOException, InterruptedException {
        Counter counter = this.readCount;
        synchronized (counter) {
            this.readCount.increment(1L);
        }
        if (uri == null) {
            return;
        }
        if (uri.getUri().isEmpty()) {
            LOG.warn((Object)("Skipped record: " + uri));
            return;
        }
        counter = this.attemptedCount;
        synchronized (counter) {
            this.attemptedCount.increment(1L);
        }
        context.write((Object)uri, fileContent);
    }

    public void setup(Mapper.Context context) {
        this.readCount = context.getCounter((Enum)MarkLogicCounter.INPUT_RECORDS);
        this.attemptedCount = context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS);
    }
}

