/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ImportRecordReader;
import com.marklogic.contentpump.SequenceFileKey;
import com.marklogic.contentpump.SequenceFileValue;
import com.marklogic.contentpump.SequenceFileValueType;
import com.marklogic.contentpump.utilities.FileIterator;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileReader<VALUEIN>
extends ImportRecordReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(SequenceFileReader.class);
    protected SequenceFile.Reader reader;
    protected Writable seqKey;
    protected Writable seqValue;
    protected boolean hasNext = true;
    protected int batchSize;

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.batchSize = this.conf.getInt("mapreduce.marklogic.output.batchsize", 100);
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(context.getConfiguration());
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initReader(inSplit);
    }

    protected void initReader(InputSplit inSplit) throws IOException {
        this.setFile(((FileSplit)inSplit).getPath());
        this.reader = new SequenceFile.Reader(this.fs, this.file, this.conf);
        String keyClass = this.conf.get("mapreduce.marklogic.input.sequencefile.keyclass");
        String valueClass = this.conf.get("mapreduce.marklogic.input.sequencefile.valueclass");
        String valueType = this.conf.get("mapreduce.marklogic.input.sequencefile.valuetype");
        SequenceFileValueType svType = SequenceFileValueType.valueOf(valueType);
        Class<? extends Writable> vClass = svType.getWritableClass();
        this.value = ReflectionUtils.newInstance(vClass, (Configuration)this.conf);
        if (!this.reader.getKeyClass().getCanonicalName().equals(keyClass)) {
            throw new IOException("Key class of sequence file on HDFS is " + keyClass + "which is inconsistent with the one in configuration " + this.reader.getKeyClass().getCanonicalName());
        }
        if (!this.reader.getValueClass().getCanonicalName().equals(valueClass)) {
            throw new IOException("Value class of sequence file on HDFS is " + valueClass + "which is inconsistent with the one in configuration " + this.reader.getValueClass().getCanonicalName());
        }
        this.seqKey = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)this.conf);
        this.seqValue = (Writable)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)this.conf);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.reader == null) {
            return false;
        }
        if (this.reader.next(this.seqKey, this.seqValue)) {
            this.setKey(((SequenceFileKey)this.seqKey).getDocumentURI().getUri(), 0, 0, false);
            if (this.value instanceof Text) {
                ((Text)this.value).set(new String(((Text)((SequenceFileValue)this.seqValue).getValue()).getBytes(), "UTF-8"));
            } else if (this.value instanceof BytesWritable) {
                if (this.batchSize > 1) {
                    this.value = new BytesWritable(((BytesWritable)((SequenceFileValue)this.seqValue).getValue()).getBytes());
                } else {
                    ((BytesWritable)this.value).set(new BytesWritable(((BytesWritable)((SequenceFileValue)this.seqValue).getValue()).getBytes()));
                }
            } else {
                LOG.error((Object)("Unexpected type: " + this.value.getClass()));
                this.key = null;
            }
            return true;
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.close();
            this.initReader((InputSplit)this.iterator.next());
            return this.nextKeyValue();
        }
        return false;
    }
}

