/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ContentWithFileNameWritable;
import com.marklogic.contentpump.DelimitedTextReader;
import com.marklogic.contentpump.utilities.CSVParserFormatter;
import com.marklogic.contentpump.utilities.DelimitedSplit;
import com.marklogic.contentpump.utilities.IdGenerator;
import com.marklogic.mapreduce.utilities.TextArrayWritable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class SplitDelimitedTextReader<VALUEIN>
extends DelimitedTextReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(SplitDelimitedTextReader.class);
    private long start;
    private long end;
    private String lineSeparator;

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.initDocType();
        this.initDelimConf();
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(context.getConfiguration());
        this.start = ((DelimitedSplit)inSplit).getStart();
        this.end = this.start + ((DelimitedSplit)inSplit).getLength();
        this.initParser(inSplit);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.parser == null || this.parserIterator == null) {
            return false;
        }
        try {
            if (!this.parserIterator.hasNext()) {
                this.bytesRead = this.fileLen;
                return false;
            }
            CSVRecord record = this.getRecordLine();
            if (record.getCharacterByte() >= this.end) {
                return false;
            }
            String[] values = this.getLine(record);
            if (values.length != this.fields.length) {
                this.setSkipKey(0, 0, "number of fields does not match number of columns");
                return true;
            }
            this.docBuilder.newDoc();
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].equals("")) continue;
                if (!this.generateId && this.uriId == i && this.setKey(values[i], 0, 0, true)) {
                    return true;
                }
                try {
                    this.docBuilder.put(this.fields[i], values[i]);
                    continue;
                }
                catch (Exception e) {
                    this.setSkipKey(0, 0, e.getMessage());
                    return true;
                }
            }
            this.docBuilder.build();
            if (this.generateId && this.setKey(this.idGen.incrementAndGet(), 0, 0, true)) {
                return true;
            }
            if (this.value instanceof Text) {
                ((Text)this.value).set(this.docBuilder.getDoc());
            } else {
                ((Text)((ContentWithFileNameWritable)this.value).getValue()).set(this.docBuilder.getDoc());
            }
        }
        catch (RuntimeException ex) {
            if (ex.getMessage().contains("invalid char between encapsulated token and delimiter")) {
                this.setSkipKey(0, 0, "invalid char between encapsulated token and delimiter");
                if (this.parserIterator.hasNext()) {
                    this.parserIterator.next();
                }
            }
            throw ex;
        }
        return true;
    }

    @Override
    protected void initParser(InputSplit inSplit) throws IOException, InterruptedException {
        this.fileIn = this.openFile(inSplit, true);
        if (this.fileIn == null) {
            return;
        }
        TextArrayWritable taw = ((DelimitedSplit)inSplit).getHeader();
        this.fields = taw.toStrings();
        try {
            this.docBuilder.configFields(this.conf, this.fields);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Skipped file: " + this.file.toUri() + ", reason: " + e.getMessage()));
            return;
        }
        this.lineSeparator = this.retrieveLineSeparator(this.fileIn);
        long adjustedStart = this.start;
        try {
            adjustedStart = this.adjustStartPos();
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("File: " + this.file.toUri() + " may lose records, reason: " + e.getMessage()));
        }
        this.fileIn.seek(adjustedStart);
        this.instream = new InputStreamReader((InputStream)this.fileIn, this.encoding);
        this.bytesRead = 0L;
        this.fileLen = inSplit.getLength();
        if (this.uriName == null) {
            this.generateId = this.conf.getBoolean("mapreduce.marklogic.input.generateuri", false);
            if (this.generateId) {
                this.idGen = new IdGenerator(this.file.toUri().getPath() + "-" + ((FileSplit)inSplit).getStart());
            } else {
                this.uriId = 0;
            }
        }
        boolean found = this.generateId || this.uriId == 0;
        for (int i = 0; i < this.fields.length && !found; ++i) {
            if (!this.fields[i].equals(this.uriName)) continue;
            this.uriId = i;
            found = true;
            break;
        }
        if (!found) {
            LOG.error((Object)("Skipped file: " + this.file.toUri() + ", reason: " + "uri_id" + " " + this.uriName + " is not found"));
            return;
        }
        this.parser = new CSVParser((Reader)this.instream, CSVParserFormatter.getFormat(this.delimiter, null, false, false), adjustedStart, 0L, this.encoding);
        this.parserIterator = this.parser.iterator();
        if (this.parserIterator.hasNext()) {
            this.getLine();
            if (this.parserIterator.hasNext()) {
                CSVRecord record = this.getRecordLine();
                long pos = record.getCharacterByte();
                this.fileIn.seek(pos);
                this.instream = new InputStreamReader((InputStream)this.fileIn, this.encoding);
                this.parser = new CSVParser((Reader)this.instream, CSVParserFormatter.getFormat(this.delimiter, Character.valueOf('\"'), false, false), pos, 0L, this.encoding);
                this.parserIterator = this.parser.iterator();
            }
        }
    }

    private String retrieveLineSeparator(FSDataInputStream fis) throws IOException {
        String lineSeparator = "";
        while (fis.available() > 0) {
            char next;
            char current = (char)fis.read();
            if (current != '\n' && current != '\r') continue;
            lineSeparator = lineSeparator + current;
            if (fis.available() > 0 && ((next = (char)fis.read()) == '\r' || next == '\n')) {
                lineSeparator = lineSeparator + next;
            }
            return lineSeparator;
        }
        return null;
    }

    @Override
    protected String convertToLine(String[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i == values.length - 1 && values[i].trim().equals("")) {
                sb.append(this.lineSeparator);
                return sb.toString();
            }
            String s = values[i];
            sb.append(s);
            sb.append(this.delimiter);
        }
        sb.replace(sb.length() - 1, sb.length(), this.lineSeparator);
        return sb.toString();
    }

    private long adjustStartPos() throws IllegalArgumentException, IOException {
        if (this.start == 0L) {
            return this.start;
        }
        if (this.encoding.equals("UTF-8")) {
            return this.findStartPosUTF8();
        }
        return this.start;
    }

    private long findStartPosUTF8() throws IllegalArgumentException, IOException {
        int numBytes = 4;
        for (long curPos = this.start; this.fileIn.available() > 0 && curPos > 0L; --curPos) {
            if (this.start - curPos >= (long)numBytes) {
                throw new IllegalArgumentException("Invalid UTF-8 encoding");
            }
            this.fileIn.seek(curPos - 1L);
            int prevByte = this.fileIn.read();
            int curByte = this.fileIn.read();
            if (!this.checkFirstByteUTF8(curByte)) continue;
            if (prevByte == 10 || prevByte == 13) {
                return curPos - 1L;
            }
            return curPos + (long)this.delimiterOffsetUTF8(this.delimiter, curPos);
        }
        return this.start;
    }

    private boolean checkFirstByteUTF8(int curByte) throws IllegalArgumentException {
        if (curByte >= 128 && curByte <= 191) {
            return false;
        }
        if (curByte >= 0 && curByte <= 127 || curByte >= 192 && curByte <= 247) {
            return true;
        }
        throw new IllegalArgumentException("Invalid UTF-8 encoding");
    }

    private int delimiterOffsetUTF8(char delimiter, long curPos) throws IOException {
        byte[] delimiterBytes = String.valueOf(delimiter).getBytes(StandardCharsets.UTF_8);
        this.fileIn.seek(curPos);
        for (byte delimiterByte : delimiterBytes) {
            if (this.fileIn.available() <= 0) {
                return 0;
            }
            int curByte = this.fileIn.read();
            if (curByte == delimiterByte) continue;
            return 0;
        }
        return delimiterBytes.length;
    }
}

