/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.CustomContent;
import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.LinkedMapWritable;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicCounter;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.MarkLogicRecordWriter;
import com.marklogic.mapreduce.StreamLocator;
import com.marklogic.mapreduce.ZipEntryInputStream;
import com.marklogic.mapreduce.utilities.AssignmentManager;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.StatisticalAssignmentPolicy;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.DocumentRepairLevel;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.ContentInsertException;
import com.marklogic.xcc.exceptions.QueryException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.impl.SessionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.w3c.dom.Node;

public class ContentWriter<VALUEOUT>
extends MarkLogicRecordWriter<DocumentURI, VALUEOUT>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(ContentWriter.class);
    public static final String ID_PREFIX = "#";
    protected String outputDir;
    protected ContentCreateOptions options;
    protected Map<String, ContentSource> hostSourceMap;
    protected Content[][] forestContents;
    protected String[] forestIds;
    protected int[] curReplica;
    protected boolean[] blacklist;
    protected int[] counts;
    protected HashMap<Content, DocumentURI>[] pendingUris;
    protected List<DocumentURI>[] commitUris;
    protected boolean fastLoad;
    protected int batchSize;
    protected int[] stmtCounts;
    protected Session[] sessions;
    private boolean formatNeeded;
    private FileSystem fs;
    protected InputStream is;
    private boolean streaming;
    private RequestOptions requestOptions;
    protected AssignmentManager am;
    protected int sfId;
    protected boolean countBased;
    protected LinkedMapWritable roleMap;
    protected HashMap<String, ContentPermission[]> permsMap;
    protected int succeeded = 0;
    protected int failed = 0;
    protected boolean needCommit = false;
    protected int hostId = 0;
    protected boolean isCopyColls;
    protected boolean isCopyQuality;
    protected boolean isCopyMeta;
    protected long effectiveVersion;
    protected boolean isTxnCompatible = false;
    protected int batchId = 0;
    protected int batchRetry;
    protected int batchSleepTime;
    protected int commitRetry;
    protected int commitSleepTime;
    protected int commitRetryLimit;
    protected final int MIN_RETRIES = 1;
    protected final int MAX_RETRIES = 15;
    protected final int MIN_SLEEP_TIME = 500;
    protected final int MAX_SLEEP_TIME = 120000;

    public ContentWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad) {
        this(conf, hostSourceMap, fastLoad, null);
    }

    public ContentWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad, AssignmentManager am) {
        super(conf, null);
        String contentTypeStr;
        ContentType contentType;
        int i;
        int srcMapSize;
        this.effectiveVersion = am.getEffectiveVersion();
        this.isTxnCompatible = this.effectiveVersion == 0L;
        this.fastLoad = fastLoad;
        this.hostSourceMap = hostSourceMap;
        this.am = am;
        this.requestOptions = new RequestOptions();
        this.requestOptions.setMaxAutoRetry(0);
        this.permsMap = new HashMap();
        if (fastLoad) {
            this.forestIds = (String[])am.getMasterIds().clone();
            srcMapSize = this.forestIds.length;
            this.curReplica = new int[srcMapSize];
            for (i = 0; i < srcMapSize; ++i) {
                this.curReplica[i] = 0;
            }
        } else {
            srcMapSize = hostSourceMap.size();
            this.forestIds = new String[srcMapSize];
            this.forestIds = hostSourceMap.keySet().toArray(this.forestIds);
            this.blacklist = new boolean[srcMapSize];
            for (i = 0; i < srcMapSize; ++i) {
                this.blacklist[i] = false;
            }
        }
        this.hostId = (int)(Math.random() * (double)srcMapSize);
        int arraySize = fastLoad ? srcMapSize : 1;
        this.sessions = new Session[arraySize];
        this.stmtCounts = new int[arraySize];
        this.outputDir = conf.get("mapreduce.marklogic.output.content.directory");
        this.batchSize = conf.getInt("mapreduce.marklogic.output.batchsize", 100);
        this.pendingUris = new HashMap[arraySize];
        for (int i2 = 0; i2 < arraySize; ++i2) {
            this.pendingUris[i2] = new HashMap();
        }
        if (fastLoad && (am.getPolicy().getPolicyKind() == AssignmentPolicy.Kind.STATISTICAL || am.getPolicy().getPolicyKind() == AssignmentPolicy.Kind.RANGE || am.getPolicy().getPolicyKind() == AssignmentPolicy.Kind.QUERY)) {
            this.countBased = true;
            this.forestContents = new Content[1][this.batchSize];
            this.counts = new int[1];
            this.sfId = -1;
        } else {
            this.forestContents = new Content[arraySize][this.batchSize];
            this.counts = new int[arraySize];
            this.sfId = 0;
        }
        String[] perms = conf.getStrings("mapreduce.marklogic.output.content.permission");
        ArrayList<ContentPermission> permissions = null;
        if (perms != null && perms.length > 0) {
            int i3 = 0;
            while (i3 + 1 < perms.length) {
                String roleName;
                if ((roleName = perms[i3++]) == null || roleName.isEmpty()) {
                    LOG.error((Object)("Illegal role name: " + roleName));
                    continue;
                }
                String perm = perms[i3].trim();
                ContentCapability capability = null;
                if (perm.equalsIgnoreCase(ContentCapability.READ.toString())) {
                    capability = ContentCapability.READ;
                } else if (perm.equalsIgnoreCase(ContentCapability.EXECUTE.toString())) {
                    capability = ContentCapability.EXECUTE;
                } else if (perm.equalsIgnoreCase(ContentCapability.INSERT.toString())) {
                    capability = ContentCapability.INSERT;
                } else if (perm.equalsIgnoreCase(ContentCapability.UPDATE.toString())) {
                    capability = ContentCapability.UPDATE;
                } else if (perm.equalsIgnoreCase(ContentCapability.NODE_UPDATE.toString())) {
                    capability = ContentCapability.NODE_UPDATE;
                } else {
                    LOG.error((Object)("Illegal permission: " + perm));
                }
                if (capability != null) {
                    if (permissions == null) {
                        permissions = new ArrayList<ContentPermission>();
                    }
                    permissions.add(new ContentPermission(capability, roleName));
                }
                ++i3;
            }
        }
        this.options = new ContentCreateOptions();
        String[] collections = conf.getStrings("mapreduce.marklogic.output.content.collection");
        if (collections != null) {
            for (int i4 = 0; i4 < collections.length; ++i4) {
                collections[i4] = collections[i4].trim();
            }
            this.options.setCollections(collections);
        }
        this.options.setQuality(conf.getInt("mapreduce.marklogic.output.content.quality", 0));
        if (permissions != null) {
            this.options.setPermissions(permissions.toArray(new ContentPermission[permissions.size()]));
        }
        if ((contentType = ContentType.valueOf(contentTypeStr = conf.get("mapreduce.marklogic.output.content.type", "XML"))) == ContentType.UNKNOWN) {
            this.formatNeeded = true;
        } else {
            this.options.setFormat(contentType.getDocumentFormat());
        }
        this.options.setLanguage(conf.get("mapreduce.marklogic.output.content.language"));
        String repairLevel = conf.get("mapreduce.marklogic.output.content.repairlevel", "DEFAULT").toLowerCase();
        this.options.setNamespace(conf.get("mapreduce.marklogic.output.content.namespace"));
        if (DocumentRepairLevel.DEFAULT.toString().equals(repairLevel)) {
            this.options.setRepairLevel(DocumentRepairLevel.DEFAULT);
        } else if (DocumentRepairLevel.NONE.toString().equals(repairLevel)) {
            this.options.setRepairLevel(DocumentRepairLevel.NONE);
        } else if (DocumentRepairLevel.FULL.toString().equals(repairLevel)) {
            this.options.setRepairLevel(DocumentRepairLevel.FULL);
        }
        this.streaming = conf.getBoolean("mapreduce.marklogic.output.content.streaming", false);
        String encoding = conf.get("mapreduce.marklogic.output.content.encoding");
        if (encoding != null) {
            this.options.setEncoding(encoding);
        }
        this.options.setTemporalCollection(conf.get("mapreduce.marklogic.output.temporalcollection"));
        this.needCommit = this.needCommit();
        if (this.needCommit) {
            this.commitUris = new ArrayList[arraySize];
            for (int i5 = 0; i5 < arraySize; ++i5) {
                this.commitUris[i5] = new ArrayList<DocumentURI>(this.txnSize * this.batchSize);
            }
        }
        this.isCopyColls = conf.getBoolean("mapreduce.marklogic.copycollections", true);
        this.isCopyQuality = conf.getBoolean("mapreduce.marklogic.copyquality", true);
        this.isCopyMeta = conf.getBoolean("mapreduce.marklogic.copymetadata", true);
        this.commitRetryLimit = this.needCommitRetry() ? 15 : 1;
    }

    protected boolean needCommit() {
        return this.txnSize != 1 || this.batchSize != 1;
    }

    protected boolean needCommitRetry() {
        return this.txnSize == 1;
    }

    protected Content createContent(DocumentURI key, VALUEOUT value) throws IOException {
        String uri = key.getUri();
        Content content = null;
        if (value instanceof Text) {
            if (this.formatNeeded) {
                this.options.setFormat(DocumentFormat.TEXT);
                this.formatNeeded = false;
            }
            this.options.setEncoding("UTF-8");
            content = ContentFactory.newContent((String)uri, (byte[])((Text)value).getBytes(), (int)0, (int)((Text)value).getLength(), (ContentCreateOptions)this.options);
        } else if (value instanceof MarkLogicNode) {
            if (this.formatNeeded) {
                this.options.setFormat(DocumentFormat.XML);
                this.formatNeeded = false;
            }
            content = ContentFactory.newContent((String)uri, (Node)((MarkLogicNode)value).get(), (ContentCreateOptions)this.options);
        } else if (value instanceof ForestDocument) {
            ContentCreateOptions newOptions = this.options;
            if (this.isCopyColls || this.isCopyMeta || this.isCopyQuality) {
                newOptions = (ContentCreateOptions)this.options.clone();
            }
            content = ((ForestDocument)value).createContent(uri, newOptions, this.isCopyColls, this.isCopyMeta, this.isCopyQuality);
        } else if (value instanceof BytesWritable) {
            if (this.formatNeeded) {
                this.options.setFormat(DocumentFormat.BINARY);
                this.formatNeeded = false;
            }
            content = ContentFactory.newContent((String)uri, (byte[])((BytesWritable)value).getBytes(), (int)0, (int)((BytesWritable)value).getLength(), (ContentCreateOptions)this.options);
        } else if (value instanceof CustomContent) {
            ContentCreateOptions newOptions = this.options;
            newOptions = (ContentCreateOptions)this.options.clone();
            content = ((CustomContent)value).getContent(this.conf, newOptions, uri);
        } else if (value instanceof DatabaseDocument) {
            DatabaseDocument doc = (DatabaseDocument)value;
            if (this.formatNeeded) {
                this.options.setFormat(doc.getContentType().getDocumentFormat());
                this.formatNeeded = false;
            }
            this.options.setEncoding("UTF-8");
            content = doc.getContentType() == ContentType.BINARY ? ContentFactory.newContent((String)uri, (byte[])doc.getContentAsByteArray(), (ContentCreateOptions)this.options) : ContentFactory.newContent((String)uri, (byte[])doc.getContentAsText().getBytes(), (ContentCreateOptions)this.options);
        } else if (value instanceof StreamLocator) {
            Path path = ((StreamLocator)value).getPath();
            if (this.fs == null) {
                URI fileUri = path.toUri();
                this.fs = FileSystem.get((URI)fileUri, (Configuration)this.conf);
            }
            switch (((StreamLocator)value).getCodec()) {
                case GZIP: {
                    FSDataInputStream fileIn = this.fs.open(path);
                    this.is = new GZIPInputStream((InputStream)fileIn);
                    break;
                }
                case ZIP: {
                    if (this.is != null) break;
                    FSDataInputStream zipfileIn = this.fs.open(path);
                    ZipInputStream zis = new ZipInputStream((InputStream)zipfileIn);
                    this.is = new ZipEntryInputStream(zis, path.toString());
                    break;
                }
                case NONE: {
                    this.is = this.fs.open(path);
                    break;
                }
                default: {
                    LOG.error((Object)("Unsupported compression codec: " + (Object)((Object)((StreamLocator)value).getCodec()) + " for document " + key));
                    return content;
                }
            }
            content = this.streaming ? ContentFactory.newUnBufferedContent((String)uri, (InputStream)this.is, (ContentCreateOptions)this.options) : ContentFactory.newContent((String)uri, (InputStream)this.is, (ContentCreateOptions)this.options);
        } else {
            throw new UnsupportedOperationException(value.getClass() + " is not supported.");
        }
        return content;
    }

    protected void insertBatch(Content[] batch, int id) throws IOException {
        this.batchRetry = 0;
        this.batchSleepTime = 500;
        while (this.batchRetry < 15) {
            try {
                List errors;
                if (this.batchRetry > 0 && LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getFormattedBatchId() + "Retrying inserting batch, attempts: " + this.batchRetry + "/" + 15));
                }
                if ((errors = this.sessions[id].insertContentCollectErrors(batch)) != null) {
                    for (RequestException ex : errors) {
                        Content content;
                        DocumentURI failedUri;
                        Throwable cause = ex.getCause();
                        if (cause != null) {
                            if (cause instanceof QueryException) {
                                LOG.warn((Object)(this.getFormattedBatchId() + ((QueryException)cause).getFormatString()));
                            } else {
                                LOG.warn((Object)(this.getFormattedBatchId() + cause.getMessage()));
                            }
                        }
                        if (!(ex instanceof ContentInsertException) || (failedUri = this.pendingUris[id].remove(content = ((ContentInsertException)ex).getContent())) == null) continue;
                        ++this.failed;
                        LOG.error((Object)(this.getFormattedBatchId() + "Document failed permanently: " + failedUri));
                    }
                }
                if (this.batchRetry <= 0) break;
                LOG.info((Object)(this.getFormattedBatchId() + "Retrying inserting batch is successful"));
                break;
            }
            catch (Exception e) {
                boolean retryable = true;
                if (e instanceof QueryException) {
                    LOG.warn((Object)(this.getFormattedBatchId() + "QueryException: " + ((QueryException)((Object)e)).getFormatString()));
                    retryable = ((QueryException)((Object)e)).isRetryable();
                } else if (e instanceof RequestServerException) {
                    LOG.warn((Object)(this.getFormattedBatchId() + "RequestServerException: " + e.getMessage()));
                } else {
                    LOG.warn((Object)(this.getFormattedBatchId() + "Exception: " + e.getMessage()));
                    if (e.getMessage().contains("Module Not Found")) {
                        retryable = false;
                    }
                }
                LOG.warn((Object)(this.getFormattedBatchId() + "Failed during inserting"));
                if (this.needCommit) {
                    this.rollback(id);
                }
                if (retryable && ++this.batchRetry < 15) {
                    this.sessions[id].close();
                    this.batchSleepTime = this.sleep(this.batchSleepTime);
                    this.sessions[id] = this.getSession(id, true);
                    continue;
                }
                if (retryable) {
                    LOG.error((Object)(this.getFormattedBatchId() + "Exceeded max batch retry, batch failed permanently"));
                }
                for (Content fc : batch) {
                    DocumentURI failedUri = this.pendingUris[id].remove(fc);
                    if (failedUri == null) continue;
                    ++this.failed;
                    LOG.error((Object)(this.getFormattedBatchId() + "Document failed permanently: " + failedUri));
                }
                throw new IOException(e);
            }
        }
        if (this.needCommit) {
            for (DocumentURI uri : this.pendingUris[id].values()) {
                this.commitUris[id].add(uri);
            }
        } else {
            this.succeeded += this.pendingUris[id].size();
        }
    }

    protected void rollback(int id) throws IOException {
        try {
            this.sessions[id].rollback();
        }
        catch (Exception e) {
            LOG.warn((Object)(this.getFormattedBatchId() + "Failed rolling back transaction: " + e.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
        }
        finally {
            if (this.countBased) {
                this.rollbackCount(id);
            }
            this.commitUris[id].clear();
        }
    }

    protected void commit(int id) throws Exception {
        this.sessions[id].commit();
        this.succeeded += this.commitUris[id].size();
        this.commitUris[id].clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void write(DocumentURI key, VALUEOUT value) throws IOException, InterruptedException {
        InternalUtilities.getUriWithOutputDir(key, this.outputDir);
        fId = 0;
        if (this.fastLoad) {
            if (!this.countBased) {
                this.sfId = fId = this.am.getPlacementForestIndex(key);
            } else {
                if (this.sfId == -1) {
                    this.sfId = this.am.getPlacementForestIndex(key);
                }
                fId = this.sfId;
            }
        }
        sid = fId;
        content = this.createContent(key, value);
        if (content == null) {
            ++this.failed;
            return;
        }
        if (this.countBased) {
            fId = 0;
        }
        this.pendingUris[sid].put(content, (DocumentURI)key.clone());
        v0 = fId;
        v1 = this.counts[v0];
        this.counts[v0] = v1 + 1;
        this.forestContents[fId][v1] = content;
        inserted = false;
        committed = false;
        if (this.counts[fId] == this.batchSize) {
            this.commitRetry = 0;
            this.commitSleepTime = 500;
            if (this.sessions[sid] == null) {
                this.sessions[sid] = this.getSession(sid, false);
            }
            while (this.commitRetry < this.commitRetryLimit) {
                inserted = false;
                committed = false;
                if (this.commitRetry > 0 && ContentWriter.LOG.isDebugEnabled()) {
                    ContentWriter.LOG.debug((Object)(this.getFormattedBatchId() + "Retrying committing batch, attempts: " + this.commitRetry + "/" + 15));
                }
                try {
                    this.insertBatch(this.forestContents[fId], sid);
                }
                catch (Exception var8_9) {
                    // empty catch block
                }
                v2 = sid;
                this.stmtCounts[v2] = this.stmtCounts[v2] + 1;
                if (this.countBased) {
                    this.sfId = -1;
                }
                this.counts[fId] = 0;
                inserted = true;
                if (!this.needCommit || this.stmtCounts[sid] != this.txnSize) break;
                try {
                    this.commit(sid);
                    if (this.commitRetry <= 0) break;
                    ContentWriter.LOG.info((Object)(this.getFormattedBatchId() + "Retrying committing batch is successful"));
                    break;
                }
                catch (Exception e) {
                    ContentWriter.LOG.warn((Object)(this.getFormattedBatchId() + "Failed committing transaction: " + e.getMessage()));
                    if (this.needCommitRetry() && ++this.commitRetry < this.commitRetryLimit) {
                        ContentWriter.LOG.warn((Object)(this.getFormattedBatchId() + "Failed during committing"));
                        this.handleCommitExceptions(sid);
                        this.commitSleepTime = this.sleep(this.commitSleepTime);
                        this.stmtCounts[sid] = 0;
                        this.sessions[sid] = this.getSession(sid, true);
                        continue;
                    }
                    if (this.needCommitRetry()) {
                        ContentWriter.LOG.error((Object)(this.getFormattedBatchId() + "Exceeded max commit retry, batch failed permanently"));
                    }
                    this.failed += this.commitUris[sid].size();
                    for (DocumentURI failedUri : this.commitUris[sid]) {
                        ContentWriter.LOG.error((Object)(this.getFormattedBatchId() + "Document failed permanently: " + failedUri));
                    }
                    this.handleCommitExceptions(sid);
                    break;
                }
                finally {
                    this.stmtCounts[sid] = 0;
                    committed = true;
                }
            }
            ++this.batchId;
            this.pendingUris[sid].clear();
        }
        if (!this.fastLoad && (inserted && !this.needCommit || committed)) {
            oldHostId = this.hostId;
            block10: while (true) {
                this.hostId = (this.hostId + 1) % this.forestIds.length;
                if (!this.blacklist[this.hostId]) break;
                if (this.hostId != oldHostId) continue;
                i = 0;
                while (true) {
                    if (i < this.blacklist.length) ** break;
                    continue block10;
                    this.blacklist[i] = false;
                    ++i;
                }
                break;
            }
            this.sessions[0] = null;
        }
    }

    protected void rollbackCount(int fId) {
        ((StatisticalAssignmentPolicy)this.am.getPolicy()).updateStats(fId, -this.batchSize);
    }

    /*
     * Unable to fully structure code
     */
    protected Session getSession(int fId, boolean nextReplica, Session.TransactionMode mode) {
        session = null;
        if (this.fastLoad) {
            replicas = this.am.getReplicas(this.forestIds[fId]);
            if (nextReplica) {
                this.curReplica[fId] = (this.curReplica[fId] + 1) % replicas.size();
            }
            cs = this.hostSourceMap.get(replicas.get(this.curReplica[fId]).getHostName());
            forestId = replicas.get(this.curReplica[fId]).getForest();
            session = cs.newSession("#" + forestId);
            if (ContentWriter.LOG.isTraceEnabled()) {
                ContentWriter.LOG.trace((Object)("Connect to forest " + forestId + " on " + session.getConnectionUri().getHost()));
            }
        } else {
            if (nextReplica) {
                this.blacklist[this.hostId] = true;
                oldHostId = this.hostId;
                block0: while (true) {
                    this.hostId = (this.hostId + 1) % this.forestIds.length;
                    if (!this.blacklist[this.hostId]) break;
                    if (this.hostId != oldHostId) continue;
                    i = 0;
                    while (true) {
                        if (i < this.blacklist.length) ** break;
                        continue block0;
                        this.blacklist[i] = false;
                        ++i;
                    }
                    break;
                }
            }
            forestId = this.forestIds[this.hostId];
            cs = this.hostSourceMap.get(forestId);
            session = cs.newSession();
            if (ContentWriter.LOG.isTraceEnabled()) {
                ContentWriter.LOG.trace((Object)("Connect to " + session.getConnectionUri().getHost()));
            }
        }
        session.setTransactionMode(mode);
        session.setDefaultRequestOptions(this.requestOptions);
        ((SessionImpl)session).setCompatibleMode(this.isTxnCompatible);
        return session;
    }

    protected Session getSession(int fId, boolean nextReplica) {
        Session.TransactionMode mode = Session.TransactionMode.AUTO;
        if (this.needCommit) {
            mode = Session.TransactionMode.UPDATE;
        }
        return this.getSession(fId, nextReplica, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.batchSize > 1) {
            int sid;
            int len;
            if (this.countBased) {
                len = 1;
                sid = this.sfId;
            } else {
                len = this.fastLoad ? this.forestIds.length : 1;
                sid = 0;
            }
            int i = 0;
            while (i < len) {
                if (sid != -1 && this.pendingUris[sid].size() > 0) {
                    this.commitRetry = 0;
                    this.commitSleepTime = 500;
                    Content[] remainder = new Content[this.counts[i]];
                    System.arraycopy(this.forestContents[i], 0, remainder, 0, this.counts[i]);
                    if (this.sessions[sid] == null) {
                        this.sessions[sid] = this.getSession(sid, false);
                    }
                    while (this.commitRetry < this.commitRetryLimit) {
                        if (this.commitRetry > 0 && LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getFormattedBatchId() + "Retrying committing batch, attempts: " + this.commitRetry + "/" + 15));
                        }
                        try {
                            this.insertBatch(remainder, sid);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n = sid;
                        this.stmtCounts[n] = this.stmtCounts[n] + 1;
                        if (this.stmtCounts[sid] <= 0 || !this.needCommit) break;
                        try {
                            this.commit(sid);
                            if (this.commitRetry <= 0) break;
                            LOG.info((Object)(this.getFormattedBatchId() + "Retrying committing batch is successful"));
                            break;
                        }
                        catch (Exception e) {
                            LOG.warn((Object)(this.getFormattedBatchId() + "Failed committing transaction: " + e.getMessage()));
                            if (this.needCommitRetry() && ++this.commitRetry < this.commitRetryLimit) {
                                LOG.warn((Object)(this.getFormattedBatchId() + "Failed during committing"));
                                this.handleCommitExceptions(sid);
                                this.commitSleepTime = this.sleep(this.commitSleepTime);
                                this.sessions[sid] = this.getSession(sid, true);
                                this.stmtCounts[sid] = 0;
                                continue;
                            }
                            if (this.needCommitRetry()) {
                                LOG.error((Object)(this.getFormattedBatchId() + "Exceeded max commit retry, batch failed permanently"));
                            }
                            this.failed += this.commitUris[sid].size();
                            for (DocumentURI failedUri : this.commitUris[sid]) {
                                LOG.error((Object)(this.getFormattedBatchId() + "Document failed permanently: " + failedUri));
                            }
                            this.handleCommitExceptions(sid);
                            break;
                        }
                        finally {
                            this.stmtCounts[sid] = 0;
                            this.sessions[sid].close();
                        }
                    }
                    ++this.batchId;
                    this.pendingUris[sid].clear();
                }
                ++i;
                ++sid;
            }
        }
        this.closeSessions();
        if (this.is != null) {
            this.is.close();
            if (this.is instanceof ZipEntryInputStream) {
                ((ZipEntryInputStream)this.is).closeZipInputStream();
            }
        }
        context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_COMMITTED).increment((long)this.succeeded);
        context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_FAILED).increment((long)this.failed);
    }

    @Override
    public int getTransactionSize(Configuration conf) {
        if (conf.get("mapreduce.marklogic.output.transactionsize") != null) {
            int txnSize = conf.getInt("mapreduce.marklogic.output.transactionsize", 0);
            return txnSize <= 0 ? 1 : txnSize;
        }
        return 1;
    }

    protected int sleep(int sleepTime) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getFormattedBatchId() + "Sleeping before retrying...sleepTime=" + sleepTime + "ms"));
            }
            InternalUtilities.sleep(sleepTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sleepTime = Math.min(this.batchSleepTime * 2, 120000);
        return sleepTime;
    }

    protected void handleCommitExceptions(int id) throws IOException {
        this.rollback(id);
        this.sessions[id].close();
        this.sessions[id] = null;
    }

    protected void closeSessions() {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            if (this.stmtCounts[i] > 0 && this.needCommit) {
                try {
                    this.commit(i);
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    this.sessions[i].close();
                }
            }
            this.sessions[i].close();
        }
    }

    protected String getFormattedBatchId() {
        return "Batch " + this.hashCode() + "." + this.batchId + ": ";
    }
}

