/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.KeyValueWriter;
import com.marklogic.mapreduce.MarkLogicOutputFormat;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.TextArrayWritable;
import com.marklogic.xcc.ContentSource;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class KeyValueOutputFormat<KEYOUT, VALUEOUT>
extends MarkLogicOutputFormat<KEYOUT, VALUEOUT> {
    public RecordWriter<KEYOUT, VALUEOUT> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        TextArrayWritable hosts = this.getHosts(conf);
        String host = InternalUtilities.getHost(hosts);
        return new KeyValueWriter(conf, host);
    }

    @Override
    public void checkOutputSpecs(Configuration conf, ContentSource cs, JobContext context) throws IOException {
        String queryLanguage;
        if (conf.get("mapreduce.marklogic.output.query") == null) {
            throw new IllegalArgumentException("mapreduce.marklogic.output.query is not specified.");
        }
        if (conf.get("mapreduce.marklogic.output.batchsize") != null) {
            LOG.warn((Object)("Config entry for \"mapreduce.marklogic.output.batchsize\" is not supported for " + this.getClass().getName() + " and will be ignored."));
        }
        if ((queryLanguage = conf.get("mapreduce.marklogic.output.querylanguage")) != null) {
            InternalUtilities.checkQueryLanguage(queryLanguage);
        }
        DefaultStringifier.store((Configuration)conf, (Object)((Object)this.queryHosts(cs)), (String)"mapreduce.marklogic.output.hostforests");
    }
}

