/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.ContentOutputFormat;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentInputFormat;
import com.marklogic.mapreduce.DocumentURI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.w3c.dom.Document;

public class HelloWorld {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"hello world");
        job.setJarByClass(HelloWorld.class);
        job.setInputFormatClass(DocumentInputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setReducerClass(MyReducer.class);
        job.setOutputFormatClass(ContentOutputFormat.class);
        job.setOutputKeyClass(DocumentURI.class);
        job.setOutputValueClass(Text.class);
        conf = job.getConfiguration();
        conf.addResource("marklogic-hello-world.xml");
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class MyReducer
    extends Reducer<IntWritable, Text, DocumentURI, Text> {
        public static final Log LOG = LogFactory.getLog(MyMapper.class);
        private Text result = new Text();
        private static final DocumentURI outputURI = new DocumentURI("HelloWorld.txt");
        private String allWords = new String();

        public void reduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            ArrayList<String> words = new ArrayList<String>();
            for (Text val : values) {
                words.add(val.toString());
            }
            Collections.sort(words);
            this.allWords = "";
            Iterator iter = words.iterator();
            while (iter.hasNext()) {
                this.allWords = this.allWords + (String)iter.next() + " ";
            }
            this.result.set(this.allWords.trim());
            context.write((Object)outputURI, (Object)this.result);
        }
    }

    public static class MyMapper
    extends Mapper<DocumentURI, DatabaseDocument, IntWritable, Text> {
        public static final Log LOG = LogFactory.getLog(MyMapper.class);
        private static final IntWritable one = new IntWritable(1);
        private Text firstWord = new Text();

        public void map(DocumentURI key, DatabaseDocument value, Mapper.Context context) throws IOException, InterruptedException {
            if (key != null && value != null && value.getContentSize() != 0L) {
                ContentType contentType = value.getContentType();
                if (contentType == ContentType.XML) {
                    Document doc = (Document)value.getContentAsMarkLogicNode().get();
                    String text = doc.getDocumentElement().getTextContent();
                    this.firstWord.set(text.split(" ", 2)[0]);
                    context.write((Object)one, (Object)this.firstWord);
                }
            } else {
                LOG.error((Object)("key: " + key + ", value: " + value));
            }
        }
    }
}

