/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import com.marklogic.io.BiendianDataInputStream;
import com.marklogic.tree.CompressedTreeDecoder;
import com.marklogic.tree.ExpandedTree;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.modeler.util.DomUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.w3c.dom.Node;

public class FCheck {
    private static final long maxWrd64 = 0x8004000L;
    private static final int CHECKSUM_SEED = 2038074743;
    private static final int CHECKSUM_STEP = 17;
    private boolean verbose = true;
    private boolean debug = true;
    private long numFragments;
    private long numLists;
    private long listDataSize;
    private long treeDataSize;
    private boolean littleEndian = true;

    public FCheck(boolean verbose) {
        this.verbose = verbose;
    }

    private int compareUnsignedLong(long x, long y) {
        return x == y ? 0 : (x < y ^ x < 0L != y < 0L ? -1 : 1);
    }

    private void panic(File arg, String msg) {
        this.panic(arg.getAbsolutePath(), msg);
    }

    private void panic(String arg, String msg) {
        throw new RuntimeException(arg + " " + msg);
    }

    private void panic(String arg1, String arg2, String msg) {
        throw new RuntimeException(arg1 + " " + arg2 + " " + msg);
    }

    private void checkLabel(File dir) {
        File file = new File(dir, "Label");
        if (!file.canRead()) {
            this.panic(file, "stat");
        }
    }

    private BiendianDataInputStream openFile(File file, int bufferSize) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis, bufferSize);
        BiendianDataInputStream bdis = new BiendianDataInputStream(bis);
        bdis.setLittleEndian(this.littleEndian);
        return bdis;
    }

    public void checkForestLabel(File dir) {
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " -> checkForestLabel");
        }
        this.checkLabel(dir);
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " <- checkForestLabel");
        }
    }

    public void checkStandLabel(File dir) {
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " -> checkStandLabel");
        }
        this.checkLabel(dir);
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " <- checkStandLabel");
        }
    }

    private boolean isObsolete(File dir) {
        return new File(dir, "Obsolete").exists();
    }

    public void checkFrequencies(File dir) throws IOException {
        File file = new File(dir, "Frequencies");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkFrequencies");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        long prevKey = -1L;
        int position = 0;
        while (true) {
            long frequency;
            long key;
            try {
                key = in.readLong();
                frequency = in.readLong();
            }
            catch (EOFException e) {
                break;
            }
            if (frequency > this.numFragments) {
                this.panic(file, "frequency out of range, position=" + position + ", frequency=" + frequency + ", numFragments=" + this.numFragments);
            }
            if (prevKey != -1L && this.compareUnsignedLong(key, prevKey) <= 0) {
                this.panic(file, "key out of order, position=" + position + ", key=0x" + String.format("%16x", key) + ", prevKey=0x" + String.format("%16x", prevKey));
            }
            prevKey = key;
            ++position;
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkFrequencies [" + position + "]");
        }
    }

    public void checkLinkKeys(File dir) throws IOException {
        File file = new File(dir, "LinkKeys");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkLinkKeys");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        try {
            long key;
            while ((key = in.readLong()) != 0L) {
                ++position;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.numFragments == 0L) {
            this.numFragments = position;
        } else if ((long)position != this.numFragments) {
            this.panic(file, "bad count, count=" + position + ", numFragments=" + this.numFragments);
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkLinkKeys [" + position + "]");
        }
    }

    private int computeListChecksum(long key, DataInput in, int words) throws IOException {
        int cksum = 2038074743;
        cksum = (cksum + (int)(key >> 32)) * 17;
        cksum = (cksum + (int)key) * 17;
        while (0 < words--) {
            cksum = (cksum + in.readInt()) * 17;
        }
        return cksum & 0xFFFFFFF0;
    }

    public void checkListData(File dir) throws IOException {
        File file = new File(dir, "ListData");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkListData");
        }
        this.listDataSize = file.length();
        BiendianDataInputStream in = this.openFile(file, 262144);
        long prevKey = -1L;
        int position = 0;
        while (true) {
            int fdatw;
            int hdrWords;
            int datWords;
            int checksum;
            int csword;
            long key;
            try {
                key = (long)in.readInt() << 32 | (long)in.readInt() & 0xFFFFFFFFL;
                csword = in.readInt();
                checksum = csword & 0xFFFFFFF0;
                datWords = csword & 0xF;
                hdrWords = 3;
                if (datWords == 0) {
                    datWords = in.readInt();
                    hdrWords = 4;
                }
                in.getInputStream().mark(4);
                fdatw = in.readInt();
                in.getInputStream().reset();
            }
            catch (EOFException e) {
                break;
            }
            if (key != -1L || csword != -1 || fdatw != -1) {
                int computed;
                if (prevKey != -1L && this.compareUnsignedLong(key, prevKey) <= 0) {
                    this.panic(file, String.format("key out of order, position=%d, key=0x%016x, prevKey=0x%016x", position, key, prevKey));
                }
                prevKey = key;
                if (datWords < 1 || (long)datWords > 134234108L) {
                    this.panic(file, String.format("bad word count, position=%d, key=0x%16x, hdrWords=%d, datWords=%d, checksum=0x%08x", position, key, hdrWords, datWords, checksum));
                }
                if (checksum != (computed = this.computeListChecksum(key, in, datWords))) {
                    this.panic(file, String.format("bad checksum, position=%d, key=0x%016x, hdrWords=%d, datWords=%d, checksum=0x%08x, computed=0x%08x", position, key, hdrWords, datWords, checksum, computed));
                }
            }
            ++position;
        }
        this.numLists = position;
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkListData [" + position + "]");
        }
    }

    public void checkListIndex(File dir) throws IOException {
        File file = new File(dir, "ListIndex");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkListIndex");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        long prevKey = -1L;
        long prevOffset = -1L;
        int position = 0;
        while (true) {
            long offset;
            long key;
            try {
                key = in.readLong();
                offset = in.readLong();
            }
            catch (EOFException e) {
                break;
            }
            if (this.compareUnsignedLong(position, this.numLists) >= 0) {
                this.panic(file, String.format("position out of range, position=%d, key=0x%016x, numFragments=%d", position, key, this.numFragments));
            }
            if (prevKey != -1L && this.compareUnsignedLong(key, prevKey) <= 0) {
                this.panic(file, String.format("key out of order, position=%d, key=0x%016x, prevKey=0x%016x", position, key, prevKey));
            }
            prevKey = key;
            if (prevOffset != -1L && this.compareUnsignedLong(offset, prevOffset) <= 0) {
                this.panic(file, String.format("offset out of order, position=%d, offset=%d, prevOffset=%d", position, offset, prevOffset));
            }
            prevOffset = offset;
            ++position;
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkListIndex [" + position + "]");
        }
    }

    public void checkOrdinals(File dir) throws IOException {
        File file = new File(dir, "Ordinals");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkOrdinals");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        try {
            while (true) {
                long ordinal = in.readLong();
                if (this.verbose) {
                    System.out.println("position=" + position + ", ordinal=" + ordinal);
                }
                ++position;
            }
        }
        catch (EOFException eOFException) {
            if (this.compareUnsignedLong(position, this.numFragments) < 0) {
                this.panic(file, String.format("bad count, count=%d, numFragments=%d", position, this.numFragments));
            }
            if (this.verbose) {
                System.out.println(file.getAbsolutePath() + " <- checkOrdinals [" + position + "]");
            }
            return;
        }
    }

    public void checkQualities(File dir) throws IOException {
        File file = new File(dir, "Qualities");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkQualities");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        try {
            while (true) {
                int quality = in.readInt();
                ++position;
            }
        }
        catch (EOFException eOFException) {
            if ((long)position < this.numFragments) {
                this.panic(file, String.format("bad count, count=%d, numFragments=%d", position, this.numFragments));
            }
            if (this.verbose) {
                System.out.println(file.getAbsolutePath() + " <- checkQualities [" + position + "]");
            }
            return;
        }
    }

    public void checkStopKeySet(File dir) throws IOException {
        File file = new File(dir, "StopKeySet");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkStopKeySet");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        long prevKey = -1L;
        int position = 0;
        try {
            long key;
            while ((key = in.readLong()) != 0L) {
                if (prevKey != -1L && key <= prevKey) {
                    this.panic(file, String.format("key out of order, position=%d, key=0x%016x, prevKey=0x%016x", position, key, prevKey));
                }
                prevKey = key;
                ++position;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkStopKeySet [" + position + "]");
        }
    }

    public void checkTimestamps(File dir) throws IOException {
        File file = new File(dir, "Timestamps");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkTimestamps");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        try {
            while (true) {
                long nascent = in.readLong();
                long deleted = in.readLong();
                if (nascent != 0L || deleted != 0L) {
                    if (this.compareUnsignedLong(deleted, nascent) < 0 && nascent != -1L) {
                        this.panic(file, String.format("bad timestamp, position=%d, nascent=%d, deleted=%d", position, nascent, deleted));
                    }
                    ++position;
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.numFragments == 0L) {
            this.numFragments = position;
        } else if ((long)position != this.numFragments) {
            this.panic(file, String.format("bad count, count=%d, numFragments=%d", position, this.numFragments));
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkTimestamps [" + position + "]");
        }
    }

    private int computeTreeChecksum(int key, DataInput in, int words) throws IOException {
        int cksum = 2038074743;
        cksum = (cksum + key) * 17 & 0xFFFFFFFF;
        while (0 < words--) {
            int w = in.readInt();
            cksum = (cksum + w) * 17 & 0xFFFFFFFF;
        }
        return cksum & 0xFFFFFFF0;
    }

    public void checkTreeData(File dir) throws IOException {
        File file = new File(dir, "TreeData");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkTreeData");
        }
        this.treeDataSize = file.length();
        BiendianDataInputStream in = this.openFile(file, 262144);
        int prevDocid = -1;
        int position = 0;
        while (true) {
            int fdatw;
            int hdrWords;
            int datWords;
            int checksum;
            int csword;
            int docid;
            try {
                docid = in.readInt();
                csword = in.readInt();
                checksum = csword & 0xFFFFFFF0;
                datWords = csword & 0xF;
                hdrWords = 2;
                if (datWords == 0) {
                    datWords = in.readInt();
                    hdrWords = 3;
                }
                in.getInputStream().mark(4);
                fdatw = in.readInt();
                in.getInputStream().reset();
            }
            catch (EOFException e) {
                break;
            }
            if (docid != -1 || csword != -1 || fdatw != -1) {
                int computed;
                if (this.debug) {
                    System.out.println(String.format("TreeData p %08x d %08x c %016x", position, docid, checksum));
                }
                if (prevDocid != -1 && (long)docid <= (long)prevDocid) {
                    this.panic(file, "docid out of order, position=" + position + ", docid=" + docid + ", prevDocid=" + prevDocid);
                }
                prevDocid = docid;
                if (datWords < 1 || (long)datWords > 134234108L) {
                    this.panic(file, "bad word count, position=" + position + ", docid=" + docid + ", hdrWords=" + hdrWords + ", datWords=" + datWords + ", checksum=0x" + Integer.toHexString(checksum));
                }
                if (checksum != (computed = this.computeTreeChecksum(docid, in, datWords))) {
                    this.panic(file, "bad checksum, position=" + position + ", docid=" + docid + ", hdrWords=" + hdrWords + ", datWords=" + datWords + ", checksum=0x" + Integer.toHexString(checksum) + ", computed=0x" + Integer.toHexString(computed));
                }
            }
            ++position;
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkTreeData [" + position + "]");
        }
    }

    public void decodeTreeData(File dir) throws IOException {
        File file = new File(dir, "TreeData");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkTreeData");
        }
        this.treeDataSize = file.length();
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        int hdrWords = 2;
        long prevDocid = -1L;
        while (true) {
            int j;
            int datWords;
            int checksum;
            int docid;
            try {
                docid = in.readInt();
                int csword = in.readInt();
                int fdatw = in.readInt();
                checksum = csword & 0xFFFFFFF0;
                datWords = csword & 0xF;
                if (datWords == 0) {
                    datWords = fdatw;
                    hdrWords = 3;
                    System.out.println("3 header words");
                }
                if (docid == -1 && csword == -1 && fdatw == -1) {
                    System.out.println("Reached the end.");
                    break;
                }
                if (prevDocid != -1L && (long)docid <= prevDocid) {
                    this.panic(file, "docid out of order, position=" + position + ", docid=" + docid + ", prevDocid=" + prevDocid);
                }
                prevDocid = docid;
                j = hdrWords == 2 ? datWords - 1 : datWords;
                j *= 4;
            }
            catch (EOFException e) {
                break;
            }
            if (this.debug) {
                System.out.println(String.format("\n\nTreeData p %d d %d c %016x", position, docid, checksum));
            }
            System.out.println("POSITION " + position);
            System.out.println("docid=" + docid + " datWords=" + datWords);
            try {
                byte kind;
                in.getInputStream().mark(j);
                byte[] buf = new byte[j];
                for (int read = 0; read < j; read += in.read(buf, read, j - read)) {
                }
                ExpandedTree tree = new CompressedTreeDecoder().decode(buf, j);
                System.out.println("URI=" + tree.getDocumentURI());
                if (this.verbose) {
                    String[] cols;
                    for (String col : cols = tree.getCollections()) {
                        System.out.println("collection: " + col);
                    }
                    Map<String, String> metaMap = tree.getMetadata();
                    if (metaMap != null) {
                        for (Map.Entry<String, String> entry : metaMap.entrySet()) {
                            System.out.println("metadata: " + entry.getKey() + ":" + entry.getValue());
                        }
                    }
                }
                if ((kind = tree.rootNodeKind()) == 9) {
                    System.out.println("binary root");
                } else if (kind == 0) {
                    System.out.println("element root");
                } else if (kind == 2) {
                    System.out.println("text root");
                } else if (kind == 14) {
                    System.out.println("json root");
                } else if (kind == 13) {
                    System.out.println("json array");
                } else {
                    System.out.println("unexpected root node kind: " + kind);
                }
                if (kind != 9 && kind != 14 && kind != 13) {
                    Node root = tree.node(0);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DomUtil.writeXml((Node)root, (OutputStream)bos);
                }
            }
            catch (Exception e) {
                System.err.println("Fail at position " + position);
                e.printStackTrace();
            }
            in.getInputStream().reset();
            while (j > 0) {
                long actual = in.getInputStream().skip(j);
                if (actual < (long)j) {
                    j = (int)((long)j - actual);
                    continue;
                }
                if (actual <= (long)j) break;
                this.panic(file, "Over-skipped: actual=" + actual + ",j=" + j);
            }
            ++position;
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkTreeData [" + position + "]");
        }
    }

    public void checkTreeIndex(File dir) throws IOException {
        File file = new File(dir, "TreeIndex");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkTreeIndex");
        }
        Path path = new Path(dir.getAbsolutePath());
        FileSystem fs = path.getFileSystem(new Configuration());
        FileStatus[] children = fs.listStatus(path);
        FileStatus treeIndexStatus = null;
        FileStatus treeDataStatus = null;
        for (FileStatus child : children) {
            String fileName = child.getPath().getName();
            if (fileName.equals("TreeData")) {
                treeDataStatus = child;
            } else if (fileName.equals("TreeIndex")) {
                treeIndexStatus = child;
            }
            if (treeDataStatus != null && treeIndexStatus != null) break;
        }
        if (treeDataStatus == null) {
            throw new RuntimeException("TreeData file not found.");
        }
        if (treeIndexStatus == null) {
            throw new RuntimeException("TreeIndex file not found.");
        }
        long treeDataSize = treeDataStatus.getLen();
        if (treeDataSize == 0L) {
            System.err.println("Found empty TreeData file.  Skipping...");
            return;
        }
        FSDataInputStream is = fs.open(treeIndexStatus.getPath());
        BiendianDataInputStream in = new BiendianDataInputStream((InputStream)is);
        in.setLittleEndian(this.littleEndian);
        int prevDocid = -1;
        long prevOffset = -1L;
        int position = 0;
        while (true) {
            long offset;
            int docid;
            try {
                docid = in.readInt();
                in.readInt();
                offset = in.readLong();
            }
            catch (EOFException e) {
                break;
            }
            if (this.debug) {
                System.out.println(String.format("TreeIndex p %08x d %08x o %016x", position, docid, offset));
            }
            if (this.compareUnsignedLong(offset, treeDataSize) >= 0) {
                this.panic(file, String.format("offset out of range, position=%d, offset=%d, treeDataSize=%d", position, offset, treeDataSize));
            }
            if (prevDocid != -1 && ((long)docid & 0xFFFFFFFFL) <= ((long)prevDocid & 0xFFFFFFFFL)) {
                this.panic(file, String.format("docid out of order, position=%d, docid=%d, prevDocid=%d", position, docid, prevDocid));
            }
            prevDocid = docid;
            if (prevOffset != -1L && this.compareUnsignedLong(offset, prevOffset) <= 0) {
                this.panic(file, String.format("offset out of order, position=%d, offset=%d, prevOffset=%d", position, offset, prevOffset));
            }
            prevOffset = offset;
            ++position;
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkTreeIndex [" + position + "]");
        }
    }

    public void checkUniqKeys(File dir) throws IOException {
        File file = new File(dir, "UniqKeys");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkUniqKeys");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        while (true) {
            try {
                long key = in.readLong();
                if (key == 0L) {
                }
            }
            catch (EOFException e) {}
            break;
            ++position;
        }
        if (this.numFragments == 0L) {
            this.numFragments = position;
        }
        if ((long)position != this.numFragments) {
            this.panic(file, String.format("bad count, count=%d, numFragments=%d", position, this.numFragments));
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkUniqKeys [" + position + "]");
        }
    }

    public void checkURIKeys(File dir) throws IOException {
        File file = new File(dir, "URIKeys");
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " -> checkURIKeys");
        }
        BiendianDataInputStream in = this.openFile(file, 262144);
        int position = 0;
        while (true) {
            try {
                long key = in.readLong();
                if (key == 0L) {
                }
            }
            catch (EOFException e) {}
            break;
            ++position;
        }
        if (this.numFragments == 0L) {
            this.numFragments = position;
        }
        if ((long)position != this.numFragments) {
            this.panic(file, String.format("bad count, count=%d, numFragments=%d", position, this.numFragments));
        }
        if (this.verbose) {
            System.out.println(file.getAbsolutePath() + " <- checkURIKeys [" + position + "]");
        }
    }

    public void checkRangeIndexes(File dir) {
    }

    public void checkStand(File dir) throws IOException {
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " -> checkStand");
        }
        if (this.isObsolete(dir)) {
            return;
        }
        this.numFragments = 0L;
        this.checkStandLabel(dir);
        this.checkListData(dir);
        this.checkLinkKeys(dir);
        this.checkFrequencies(dir);
        this.checkListIndex(dir);
        this.checkOrdinals(dir);
        this.checkQualities(dir);
        this.checkStopKeySet(dir);
        this.checkTimestamps(dir);
        this.checkTreeData(dir);
        this.checkTreeIndex(dir);
        this.checkUniqKeys(dir);
        this.checkURIKeys(dir);
        this.checkRangeIndexes(dir);
        this.decodeTreeData(dir);
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " <- checkStand");
        }
    }

    public void checkJournals(File dir) {
    }

    public void checkForest(File dir) throws IOException {
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " -> checkForest (" + (this.littleEndian ? "Little" : "Big") + " Endian)");
        }
        this.checkForestLabel(dir);
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            String filename = ((File)file).getName();
            if (((File)file).isDirectory()) {
                if (filename.equals("Journals")) {
                    this.checkJournals((File)file);
                    continue;
                }
                if (filename.equals("Large") || filename.equals(".svn")) continue;
                this.checkStand((File)file);
                continue;
            }
            if (filename.equals("Label") || filename.equals("Label_1")) continue;
            this.panic((File)file, "unexpected");
        }
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " <- checkForest");
        }
    }

    public void fcheck(File dir) throws IOException {
        if (this.verbose) {
            System.out.println(dir.getAbsolutePath() + " -> fcheck ");
        }
        this.littleEndian = !"Solaris".equals(System.getProperty("os.name"));
        try {
            try {
                this.checkForest(dir);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().indexOf("bad checksum") >= 0) {
                    if (this.verbose) {
                        System.out.println(e.getMessage());
                    }
                    this.littleEndian = !this.littleEndian;
                    this.checkForest(dir);
                }
                throw e;
            }
            if (this.verbose) {
                System.out.println(dir.getAbsolutePath() + " <- fcheck OK");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(dir.getAbsolutePath() + " <- fcheck FAIL");
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length < 1 || argv.length > 2 || argv.length == 2 && !argv[0].equals("-v")) {
            System.err.println("usage: " + FCheck.class.getName() + " [-v] forestpath");
            System.exit(1);
        }
        new FCheck(argv.length > 1).fcheck(new File(argv[argv.length - 1]));
        System.exit(0);
    }
}

